/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.partition;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionEdgeIterable;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionElement;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionGraph;
import com.tinkerpop.blueprints.util.wrappers.partition.PartitionVertexIterable;

class PartitionIndex<T extends Element>
implements Index<T> {
    protected Index<T> rawIndex;
    protected PartitionGraph graph;

    public PartitionIndex(Index<T> rawIndex, PartitionGraph graph) {
        this.rawIndex = rawIndex;
        this.graph = graph;
    }

    @Override
    public String getIndexName() {
        return this.rawIndex.getIndexName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.rawIndex.getIndexClass();
    }

    @Override
    public long count(String key, Object value) {
        long counter = 0L;
        for (Element element : this.get(key, value)) {
            ++counter;
        }
        return counter;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.rawIndex.remove(key, value, ((PartitionElement)element).getBaseElement());
    }

    @Override
    public void put(String key, Object value, T element) {
        this.rawIndex.put(key, value, ((PartitionElement)element).getBaseElement());
    }

    @Override
    public CloseableIterable<T> get(String key, Object value) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new PartitionVertexIterable(this.rawIndex.get(key, value), this.graph);
        }
        return new PartitionEdgeIterable(this.rawIndex.get(key, value), this.graph);
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) {
        if (Vertex.class.isAssignableFrom(this.getIndexClass())) {
            return new PartitionVertexIterable(this.rawIndex.query(key, query), this.graph);
        }
        return new PartitionEdgeIterable(this.rawIndex.query(key, query), this.graph);
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

