/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.HttpClientManager;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.webservices.WebServiceData;
import org.apache.hop.pipeline.transforms.webservices.WebServiceField;
import org.apache.hop.pipeline.transforms.webservices.WebServiceMeta;
import org.apache.hop.pipeline.transforms.webservices.wsdl.Wsdl;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameter;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameterList;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOperation;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebService
extends BaseTransform<WebServiceMeta, WebServiceData> {
    private static final Class<?> PKG = WebServiceMeta.class;
    public static final String NS_PREFIX = "ns";
    private int nbRowProcess;
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private DecimalFormat decFormat = new DecimalFormat("00");
    private Date dateRef;
    private Wsdl cachedWsdl;
    private HttpClientContext cachedHostConfiguration;
    private HttpClient cachedHttpClient;
    private String cachedURLService;
    private WsdlOperation cachedOperation;
    private WebServiceMeta cachedMeta;
    private List<Integer> indexList;

    public WebService(TransformMeta aTransformMeta, WebServiceMeta meta, WebServiceData data, int value, PipelineMeta aPipelineMeta, Pipeline aPipeline) {
        super(aTransformMeta, (ITransformMeta)meta, (ITransformData)data, value, aPipelineMeta, aPipeline);
        try {
            this.dateRef = this.timeFormat.parse("00:00:00");
        }
        catch (ParseException e) {
            this.logError("Unexpected error in WebService constructor: ", e);
            this.setErrors(1L);
            this.stopAll();
        }
    }

    public boolean processRow() throws HopException {
        if (Utils.isEmpty((CharSequence)((WebServiceMeta)this.meta).getUrl())) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0014.urlNotSpecified", (String[])new String[]{this.getTransformName()}));
        }
        if (Utils.isEmpty((CharSequence)((WebServiceMeta)this.meta).getOperationName())) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0015.OperationNotSelected", (String[])new String[]{this.getTransformName()}));
        }
        Object[] vCurrentRow = this.getRow();
        if (this.first) {
            this.first = false;
            ((WebServiceData)this.data).outputRowMeta = this.getInputRowMeta() != null ? this.getInputRowMeta().clone() : new RowMeta();
            ((WebServiceMeta)this.meta).getFields(((WebServiceData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.defineIndexList(this.getInputRowMeta(), vCurrentRow);
        } else if (vCurrentRow == null) {
            this.setOutputDone();
            return false;
        }
        if (vCurrentRow != null) {
            ++this.nbRowProcess;
            ((WebServiceData)this.data).argumentRows.add(vCurrentRow);
        }
        if (vCurrentRow == null && this.nbRowProcess % ((WebServiceMeta)this.meta).getCallTransform() != 0 || vCurrentRow != null && this.nbRowProcess > 0 && this.nbRowProcess % ((WebServiceMeta)this.meta).getCallTransform() == 0 || vCurrentRow == null && !((WebServiceMeta)this.meta).hasFieldsIn()) {
            this.requestSOAP(vCurrentRow, this.getInputRowMeta());
        }
        if (vCurrentRow == null) {
            this.setOutputDone();
        }
        return vCurrentRow != null;
    }

    private void defineIndexList(IRowMeta rowMeta, Object[] vCurrentRow) throws HopException {
        int index;
        this.indexList = new ArrayList<Integer>();
        if (rowMeta != null) {
            for (WebServiceField curField : ((WebServiceMeta)this.meta).getFieldsIn()) {
                index = rowMeta.indexOfValue(curField.getName());
                if (index >= 0) {
                    this.indexList.add(index);
                    continue;
                }
                throw new HopException("Required input field [" + curField.getName() + "] couldn't be found in the transform input");
            }
        }
        for (WebServiceField curField : ((WebServiceMeta)this.meta).getFieldsOut()) {
            index = ((WebServiceData)this.data).outputRowMeta.indexOfValue(curField.getName());
            if (index < 0) continue;
            ((WebServiceData)this.data).indexMap.put(curField.getWsName(), index);
        }
    }

    private String getRequestXML(WsdlOperation operation, boolean qualifyWSField) throws HopException {
        WsdlOpParameterList parameters = operation.getParameters();
        String requestOperation = Const.NVL((String)((WebServiceMeta)this.meta).getOperationRequestName(), (String)((WebServiceMeta)this.meta).getOperationName());
        Iterator iterator = parameters.iterator();
        ArrayList<String> bodyNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            WsdlOpParameter wsdlOpParameter = (WsdlOpParameter)iterator.next();
            bodyNames.add(wsdlOpParameter.getName().getLocalPart());
        }
        ArrayList<String> headerNames = new ArrayList<String>(parameters.getHeaderNames());
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns=\"");
        xml.append(((WebServiceMeta)this.meta).getOperationNamespace());
        xml.append("\">\n");
        xml.append("  <soapenv:Header>\n");
        this.addParametersToXML(xml, headerNames, qualifyWSField);
        xml.append("  </soapenv:Header>\n");
        xml.append("  <soapenv:Body>\n");
        xml.append("    <ns:").append(requestOperation).append(">\n");
        if (((WebServiceMeta)this.meta).getInFieldContainerName() != null) {
            xml.append("      <ns:" + ((WebServiceMeta)this.meta).getInFieldContainerName() + ">\n");
        }
        this.addParametersToXML(xml, bodyNames, qualifyWSField);
        if (((WebServiceMeta)this.meta).getInFieldContainerName() != null) {
            xml.append("      </ns:" + ((WebServiceMeta)this.meta).getInFieldContainerName() + ">\n");
        }
        xml.append("    </ns:").append(requestOperation).append(">\n");
        xml.append("  </soapenv:Body>\n");
        xml.append("</soapenv:Envelope>\n");
        return xml.toString();
    }

    private void addParametersToXML(StringBuilder xml, List<String> names, boolean qualifyWSField) throws HopException {
        for (Object[] vCurrentRow : ((WebServiceData)this.data).argumentRows) {
            if (((WebServiceMeta)this.meta).getInFieldArgumentName() != null) {
                xml.append("        <ns:").append(((WebServiceMeta)this.meta).getInFieldArgumentName()).append(">\n");
            }
            for (Integer index : this.indexList) {
                IValueMeta vCurrentValue = this.getInputRowMeta().getValueMeta(index.intValue());
                Object data = vCurrentRow[index];
                WebServiceField field = ((WebServiceMeta)this.meta).getFieldInFromName(vCurrentValue.getName());
                if (field == null || !names.contains(field.getWsName())) continue;
                if (!vCurrentValue.isNull(data)) {
                    xml.append("          <");
                    if (qualifyWSField) {
                        xml.append(NS_PREFIX).append(":");
                    }
                    xml.append(field.getWsName()).append(">");
                    if ("time".equals(field.getXsdType())) {
                        long millis = vCurrentValue.getDate(data).getTime() - this.dateRef.getTime();
                        xml.append(this.decFormat.format(millis / 3600000L) + ":" + this.decFormat.format(millis % 3600000L / 60000L) + ":" + this.decFormat.format(millis % 60000L / 1000L));
                    } else if ("date".equals(field.getXsdType())) {
                        xml.append(this.dateFormat.format(vCurrentValue.getDate(data)));
                    } else if ("boolean".equals(field.getXsdType())) {
                        xml.append(vCurrentValue.getBoolean(data) != false ? "true" : "false");
                    } else if ("datetime".equals(field.getXsdType())) {
                        xml.append(this.dateTimeFormat.format(vCurrentValue.getDate(data)));
                    } else if (vCurrentValue.isNumber()) {
                        xml.append(vCurrentValue.getString(data).trim().replace(',', '.'));
                    } else {
                        xml.append(Const.trim((String)vCurrentValue.getString(data)));
                    }
                    xml.append("</");
                    if (qualifyWSField) {
                        xml.append(NS_PREFIX).append(":");
                    }
                    xml.append(field.getWsName()).append(">\n");
                    continue;
                }
                xml.append("          <").append(NS_PREFIX).append(":").append(field.getWsName()).append(" xsi:nil=\"true\"/>\n");
            }
            if (((WebServiceMeta)this.meta).getInFieldArgumentName() == null) continue;
            xml.append("        </ns:").append(((WebServiceMeta)this.meta).getInFieldArgumentName()).append(">\n");
        }
    }

    private synchronized void requestSOAP(Object[] rowData, IRowMeta rowMeta) throws HopException {
        block14: {
            this.initWsdlEnv();
            HttpPost vHttpMethod = null;
            HttpEntity httpEntity = null;
            Charset charSet = Charset.defaultCharset();
            try {
                String xml = this.getRequestXML(this.cachedOperation, this.cachedWsdl.getWsdlTypes().isElementFormQualified(this.cachedWsdl.getTargetNamespace()));
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.SOAPEnvelope", (String[])new String[0]));
                    this.logDetailed(xml);
                }
                vHttpMethod = this.getHttpMethod(this.cachedURLService);
                ByteArrayEntity requestEntity = new ByteArrayEntity(xml.toString().getBytes("UTF-8"));
                vHttpMethod.setEntity((HttpEntity)requestEntity);
                HttpResponse httpResponse = this.cachedHttpClient.execute((HttpUriRequest)vHttpMethod);
                int responseCode = httpResponse.getStatusLine().getStatusCode();
                if (responseCode == 301) {
                    String newLocation = WebService.getLocationFrom(vHttpMethod);
                    vHttpMethod = this.getHttpMethod(newLocation);
                    vHttpMethod.setEntity((HttpEntity)requestEntity);
                    httpResponse = this.cachedHttpClient.execute((HttpUriRequest)vHttpMethod);
                    responseCode = httpResponse.getStatusLine().getStatusCode();
                }
                if (responseCode == 200) {
                    httpEntity = httpResponse.getEntity();
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                    charSet = contentType.getCharset();
                    this.processRows(httpEntity.getContent(), rowData, rowMeta, this.cachedWsdl.getWsdlTypes().isElementFormQualified(this.cachedWsdl.getTargetNamespace()), charSet.toString());
                    break block14;
                }
                if (responseCode == 401) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0011.Authentication", (String[])new String[]{this.cachedURLService}));
                }
                if (responseCode == 404) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0012.NotFound", (String[])new String[]{this.cachedURLService}));
                }
                if (responseCode == 500) {
                    throw new HopTransformException("Internal Server Error 500: " + this.cachedURLService);
                }
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0001.ServerError", (String[])new String[]{Integer.toString(responseCode), Const.NVL((String)new String(EntityUtils.toString((HttpEntity)httpEntity, (String)charSet.toString())), (String)""), this.cachedURLService}));
            }
            catch (UnknownHostException e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0013.UnknownHost", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            catch (IOException e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0005.IOException", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0002.InvalidURI", (String[])new String[]{this.cachedURLService}), (Throwable)e);
            }
            finally {
                ((WebServiceData)this.data).argumentRows.clear();
                if (vHttpMethod != null) {
                    vHttpMethod.releaseConnection();
                }
            }
        }
    }

    private void initWsdlEnv() throws HopException {
        if (((Object)((Object)((WebServiceMeta)this.meta))).equals((Object)this.cachedMeta)) {
            return;
        }
        this.cachedMeta = (WebServiceMeta)this.meta;
        try {
            this.cachedWsdl = new Wsdl(new URI(((WebServiceData)this.data).realUrl), null, null, this.resolve(((WebServiceMeta)this.meta).getHttpLogin()), Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((WebServiceMeta)this.meta).getHttpPassword())));
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0013.ExceptionLoadingWSDL", (String[])new String[0]), (Throwable)e);
        }
        this.cachedURLService = this.cachedWsdl.getServiceEndpoint();
        this.cachedHostConfiguration = HttpClientContext.create();
        this.cachedHttpClient = this.getHttpClient(this.cachedHostConfiguration);
        this.cachedOperation = this.cachedWsdl.getOperation(((WebServiceMeta)this.meta).getOperationName());
        if (this.cachedOperation == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"WebServices.Exception.OperarationNotSupported", (String[])new String[]{((WebServiceMeta)this.meta).getOperationName(), ((WebServiceMeta)this.meta).getUrl()}));
        }
    }

    static String getLocationFrom(HttpPost method) {
        Header locationHeader = method.getFirstHeader("Location");
        return locationHeader.getValue();
    }

    HttpPost getHttpMethod(String vURLService) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(vURLService);
        HttpPost vHttpMethod = new HttpPost(uriBuilder.build());
        vHttpMethod.setHeader("Content-Type", "text/xml;charset=UTF-8");
        String soapAction = "\"" + ((WebServiceMeta)this.meta).getOperationNamespace();
        if (!((WebServiceMeta)this.meta).getOperationNamespace().endsWith("/")) {
            soapAction = soapAction + "/";
        }
        soapAction = soapAction + ((WebServiceMeta)this.meta).getOperationName() + "\"";
        this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.UsingRequestHeaderSOAPAction", (String[])new String[]{soapAction}));
        vHttpMethod.setHeader("SOAPAction", soapAction);
        return vHttpMethod;
    }

    private HttpClient getHttpClient(HttpClientContext context) {
        HttpClientManager.HttpClientBuilderFacade clientBuilder = HttpClientManager.getInstance().createBuilder();
        String login = this.resolve(((WebServiceMeta)this.meta).getHttpLogin());
        if (StringUtils.isNotBlank((String)login)) {
            clientBuilder.setCredentials(login, Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((WebServiceMeta)this.meta).getHttpPassword())));
        }
        int proxyPort = 0;
        if (StringUtils.isNotBlank((String)((WebServiceMeta)this.meta).getProxyHost())) {
            proxyPort = Const.toInt((String)this.resolve(((WebServiceMeta)this.meta).getProxyPort()), (int)8080);
            clientBuilder.setProxy(((WebServiceMeta)this.meta).getProxyHost(), proxyPort);
        }
        CloseableHttpClient httpClient = clientBuilder.build();
        if (proxyPort != 0) {
            HttpHost target = new HttpHost(((WebServiceMeta)this.meta).getProxyHost(), proxyPort, "http");
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(target, (AuthScheme)basicAuth);
            context.setAuthCache((AuthCache)authCache);
        }
        return httpClient;
    }

    public boolean init() {
        ((WebServiceData)this.data).indexMap = new Hashtable<String, Integer>();
        ((WebServiceData)this.data).realUrl = this.resolve(((WebServiceMeta)this.meta).getUrl());
        return super.init();
    }

    public void dispose() {
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFromInputStream(InputStream is, String encoding) throws HopTransformException {
        try {
            StringBuilder sb = new StringBuilder(Math.max(16, is.available()));
            char[] tmp = new char[4096];
            try {
                int cnt;
                InputStreamReader reader = new InputStreamReader(is, encoding != null ? encoding : "UTF-8");
                while ((cnt = reader.read(tmp)) > 0) {
                    sb.append(tmp, 0, cnt);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new HopTransformException("Unable to read web service response data from input stream", (Throwable)e);
        }
    }

    private void processRows(InputStream anXml, Object[] rowData, IRowMeta rowMeta, boolean ignoreNamespacePrefix, String encoding) throws HopException {
        if (((WebServiceMeta)this.meta).isCompatible()) {
            this.compatibleProcessRows(anXml, rowData, rowMeta, ignoreNamespacePrefix, encoding);
            return;
        }
        String response = this.readStringFromInputStream(anXml, encoding);
        try {
            DocumentBuilderFactory documentBuilderFactory = XmlParserFactoryProducer.createSecureDocBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new StringReader(response)));
            Node envelopeNode = doc.getFirstChild();
            String nsPrefix = envelopeNode.getPrefix();
            Node bodyNode = XmlHandler.getSubNode((Node)envelopeNode, (String)(nsPrefix + ":Body"));
            if (bodyNode == null) {
                XmlHandler.getSubNode((Node)envelopeNode, (String)(nsPrefix + ":body"));
            }
            Transformer transformer = null;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            if (this.log.isDetailed()) {
                StringWriter bodyXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(bodyXML));
                this.logDetailed(bodyXML.toString());
            }
            Node responseNode = null;
            NodeList nodeList = null;
            if (!Utils.isEmpty((CharSequence)((WebServiceMeta)this.meta).getRepeatingElementName())) {
                nodeList = ((Element)bodyNode).getElementsByTagName(((WebServiceMeta)this.meta).getRepeatingElementName());
            } else if (((WebServiceMeta)this.meta).isReturningReplyAsString()) {
                StringWriter nodeXML = new StringWriter();
                transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                String xml = response;
                Object[] outputRowData = this.createNewRow(rowData);
                int index = rowData == null ? 0 : this.getInputRowMeta().size();
                outputRowData[index++] = xml;
                this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
            } else {
                NodeList responseChildren = bodyNode.getChildNodes();
                for (int i = 0; i < responseChildren.getLength(); ++i) {
                    Node responseChild = responseChildren.item(i);
                    if (responseChild.getNodeType() != 1) continue;
                    responseNode = responseChild;
                    break;
                }
                if (((WebServiceMeta)this.meta).getFieldsOut().size() == 1) {
                    WebServiceField field = ((WebServiceMeta)this.meta).getFieldsOut().get(0);
                    if (field.getWsName().equals(responseNode.getNodeName())) {
                        StringWriter nodeXML = new StringWriter();
                        transformer.transform(new DOMSource(responseNode), new StreamResult(nodeXML));
                        String xml = nodeXML.toString();
                        Object[] outputRowData = this.createNewRow(rowData);
                        int index = rowData == null ? 0 : this.getInputRowMeta().size();
                        outputRowData[index++] = xml;
                        this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
                    } else if (responseNode != null) {
                        nodeList = responseNode.getChildNodes();
                    }
                } else if (responseNode != null) {
                    nodeList = responseNode.getChildNodes();
                }
            }
            if (nodeList == null || ((WebServiceMeta)this.meta).isReturningReplyAsString()) {
                return;
            }
            Object[] outputRowData = this.createNewRow(rowData);
            boolean singleRow = false;
            int fieldsFound = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (((WebServiceMeta)this.meta).isReturningReplyAsString()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(bodyNode), new StreamResult(nodeXML));
                    String xml = nodeXML.toString();
                    outputRowData = this.createNewRow(rowData);
                    int index = rowData == null ? 0 : this.getInputRowMeta().size();
                    outputRowData[index++] = xml;
                    this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
                    continue;
                }
                WebServiceField field = ((WebServiceMeta)this.meta).getFieldOutFromWsName(node.getNodeName(), ignoreNamespacePrefix);
                if (field != null) {
                    if (!this.getNodeValue(outputRowData, node, field, transformer, true)) continue;
                    singleRow = true;
                    ++fieldsFound;
                    continue;
                }
                if (singleRow) continue;
                if (this.log.isDetailed()) {
                    StringWriter nodeXML = new StringWriter();
                    transformer.transform(new DOMSource(node), new StreamResult(nodeXML));
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServices.Log.ResultRowDataFound", (String[])new String[]{nodeXML.toString()}));
                }
                outputRowData = this.createNewRow(rowData);
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    field = ((WebServiceMeta)this.meta).getFieldOutFromWsName(childNode.getNodeName(), ignoreNamespacePrefix);
                    if (field == null || !this.getNodeValue(outputRowData, childNode, field, transformer, false)) continue;
                    ++fieldsFound;
                }
                if (fieldsFound <= 0) continue;
                this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
            }
            if (singleRow && fieldsFound > 0) {
                this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
            }
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0010.OutputParsingError", (String[])new String[]{response.toString()}), (Throwable)e);
        }
    }

    private Object[] createNewRow(Object[] inputRowData) {
        return inputRowData == null ? RowDataUtil.allocateRowData((int)((WebServiceData)this.data).outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])inputRowData, (int)((WebServiceData)this.data).outputRowMeta.size());
    }

    private void compatibleProcessRows(InputStream anXml, Object[] rowData, IRowMeta rowMeta, boolean ignoreNamespacePrefix, String encoding) throws HopException {
        String response = this.readStringFromInputStream(anXml, encoding);
        StringReader stringReader = new StringReader(response.toString());
        try {
            XMLInputFactory vFactory = XMLInputFactory.newInstance();
            vFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            vFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLStreamReader vReader = vFactory.createXMLStreamReader(stringReader);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)((WebServiceData)this.data).outputRowMeta.size());
            int outputIndex = 0;
            boolean processing = false;
            boolean oneValueRowProcessing = false;
            int event = vReader.next();
            while (vReader.hasNext()) {
                switch (event) {
                    case 1: {
                        WebServiceField field;
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_ELEMENT / " + vReader.getAttributeCount() + " / " + vReader.getNamespaceCount());
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (Utils.isEmpty((CharSequence)((WebServiceMeta)this.meta).getOutFieldArgumentName())) {
                            if (!oneValueRowProcessing) break;
                            field = ((WebServiceMeta)this.meta).getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                            if (field != null) {
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
                                oneValueRowProcessing = false;
                                break;
                            }
                            if (!((WebServiceMeta)this.meta).getOutFieldContainerName().equals(vReader.getLocalName())) break;
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldContainerName = " + ((WebServiceMeta)this.meta).getOutFieldContainerName());
                            }
                            oneValueRowProcessing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("OutFieldArgumentName = " + ((WebServiceMeta)this.meta).getOutFieldArgumentName());
                        }
                        if (((WebServiceMeta)this.meta).getOutFieldArgumentName().equals(vReader.getLocalName())) {
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                            }
                            if (this.log.isRowLevel()) {
                                this.logRowlevel("OutFieldArgumentName = ");
                            }
                            if (processing) {
                                int index;
                                field = ((WebServiceMeta)this.meta).getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                                if (field != null && (index = ((WebServiceData)this.data).outputRowMeta.indexOfValue(field.getName())) >= 0) {
                                    outputRowData[index] = this.getValue(vReader.getElementText(), field);
                                }
                                processing = false;
                                break;
                            }
                            field = ((WebServiceMeta)this.meta).getFieldOutFromWsName(vReader.getLocalName(), ignoreNamespacePrefix);
                            if (((WebServiceMeta)this.meta).getFieldsOut().size() == 1 && field != null) {
                                try {
                                    if (((WebServiceMeta)this.meta).isPassingInputData()) {
                                        for (int i = 0; i < rowMeta.getValueMetaList().size(); ++i) {
                                            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(i);
                                            outputRowData[outputIndex++] = valueMeta.cloneValueData(rowData[i]);
                                        }
                                    }
                                    outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), field);
                                    this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
                                    break;
                                }
                                catch (XMLStreamException e) {
                                    throw new HopTransformException("Unable to get value for field [" + field.getName() + "].  Verify that this is not a complex data type by looking at the response XML.", (Throwable)e);
                                }
                            }
                            for (WebServiceField curField : ((WebServiceMeta)this.meta).getFieldsOut()) {
                                if (Utils.isEmpty((CharSequence)curField.getName())) continue;
                                outputRowData[outputIndex++] = this.getValue(vReader.getElementText(), curField);
                            }
                            processing = true;
                            break;
                        }
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("vReader.getLocalName = " + vReader.getLocalName());
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("OutFieldArgumentName = " + ((WebServiceMeta)this.meta).getOutFieldArgumentName());
                        break;
                    }
                    case 2: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("END_ELEMENT");
                        }
                        if (((WebServiceMeta)this.meta).getOutFieldArgumentName() == null && ((WebServiceMeta)this.meta).getOperationName().equals(vReader.getLocalName())) {
                            oneValueRowProcessing = false;
                            break;
                        }
                        if (((WebServiceMeta)this.meta).getOutFieldArgumentName() == null || !((WebServiceMeta)this.meta).getOutFieldArgumentName().equals(vReader.getLocalName())) break;
                        this.putRow(((WebServiceData)this.data).outputRowMeta, outputRowData);
                        processing = false;
                        break;
                    }
                    case 3: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 4: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CHARACTERS");
                        break;
                    }
                    case 5: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("COMMENT");
                        break;
                    }
                    case 6: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("PROCESSING_INSTRUCTION");
                        break;
                    }
                    case 7: {
                        if (this.log.isRowLevel()) {
                            this.logRowlevel("START_DOCUMENT");
                        }
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel(vReader.getText());
                        break;
                    }
                    case 8: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("END_DOCUMENT");
                        break;
                    }
                    case 9: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_REFERENCE");
                        break;
                    }
                    case 10: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ATTRIBUTE");
                        break;
                    }
                    case 11: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("DTD");
                        break;
                    }
                    case 12: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("CDATA");
                        break;
                    }
                    case 13: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NAMESPACE");
                        break;
                    }
                    case 14: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("NOTATION_DECLARATION");
                        break;
                    }
                    case 15: {
                        if (!this.log.isRowLevel()) break;
                        this.logRowlevel("ENTITY_DECLARATION");
                        break;
                    }
                }
                event = vReader.next();
            }
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServices.ERROR0010.OutputParsingError", (String[])new String[]{response}), (Throwable)e);
        }
    }

    private boolean getNodeValue(Object[] outputRowData, Node node, WebServiceField field, Transformer transformer, boolean singleRowScenario) throws HopException {
        Integer outputIndex = ((WebServiceData)this.data).indexMap.get(field.getWsName());
        if (outputIndex == null) {
            return false;
        }
        if (node.getNodeType() == 3 || !field.isComplex()) {
            Object rowValue = null;
            String textContent = node.getTextContent();
            try {
                outputRowData[outputIndex.intValue()] = rowValue = this.getValue(textContent, field);
                return true;
            }
            catch (Exception e) {
                throw new HopException("Unable to convert value [" + textContent + "] for field [" + field.getWsName() + "], type [" + field.getXsdType() + "]", (Throwable)e);
            }
        }
        if (node.getNodeType() == 1) {
            try {
                StringWriter childNodeXML = new StringWriter();
                transformer.transform(new DOMSource(node), new StreamResult(childNodeXML));
                outputRowData[outputIndex.intValue()] = childNodeXML.toString();
                return true;
            }
            catch (Exception e) {
                throw new HopException("Unable to transform DOM node with name [" + node.getNodeName() + "] to XML", (Throwable)e);
            }
        }
        return false;
    }

    private Object getValue(String vNodeValue, WebServiceField field) throws XMLStreamException, ParseException {
        if (vNodeValue == null) {
            return null;
        }
        if ("boolean".equals(field.getXsdType())) {
            return Boolean.valueOf(vNodeValue);
        }
        if ("date".equals(field.getXsdType())) {
            try {
                return this.dateFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("time".equals(field.getXsdType())) {
            try {
                return this.timeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("datetime".equals(field.getXsdType())) {
            try {
                return this.dateTimeFormat.parse(vNodeValue);
            }
            catch (ParseException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("int".equals(field.getXsdType()) || "short".equals(field.getXsdType()) || "integer".equals(field.getXsdType())) {
            try {
                return Long.parseLong(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("float".equals(field.getXsdType()) || "double".equals(field.getXsdType())) {
            try {
                return Double.parseDouble(vNodeValue);
            }
            catch (NumberFormatException e) {
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
        }
        if ("base64Binary".equals(field.getXsdType())) {
            return Base64.decodeBase64((byte[])vNodeValue.getBytes());
        }
        if ("decimal".equals(field.getXsdType())) {
            return new BigDecimal(vNodeValue);
        }
        return vNodeValue;
    }
}

