/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.utils;

import java.util.Arrays;

public class PerformanceStats {
    private long start = System.currentTimeMillis();
    private long windowStart = System.currentTimeMillis();
    private int[] latencies;
    private int sampling;
    private int iteration = 0;
    private int index = 0;
    private long count;
    private long bytes;
    private int maxLatency;
    private long totalLatency;
    private long windowCount;
    private int windowMaxLatency;
    private long windowTotalLatency;
    private long windowBytes;
    private long reportingInterval;

    public PerformanceStats(long numRecords, int reportingInterval) {
        this.sampling = (int)(numRecords / Math.min(numRecords, 500000L));
        this.latencies = new int[(int)(numRecords / (long)this.sampling) + 1];
        this.index = 0;
        this.maxLatency = 0;
        this.totalLatency = 0L;
        this.windowCount = 0L;
        this.windowMaxLatency = 0;
        this.windowTotalLatency = 0L;
        this.windowBytes = 0L;
        this.totalLatency = 0L;
        this.reportingInterval = reportingInterval;
    }

    public void record(int iter, int latency, int records, long bytes, long time) {
        this.count += (long)records;
        this.bytes += bytes;
        this.totalLatency += (long)latency;
        this.maxLatency = Math.max(this.maxLatency, latency);
        this.windowCount += (long)records;
        this.windowBytes += bytes;
        this.windowTotalLatency += (long)latency;
        this.windowMaxLatency = Math.max(this.windowMaxLatency, latency);
        if (iter % this.sampling == 0) {
            this.latencies[this.index] = latency;
            ++this.index;
        }
        if (time - this.windowStart >= this.reportingInterval) {
            this.printWindow();
            this.newWindow();
        }
    }

    public Callback nextCompletion(long start) {
        Callback cb = new Callback(this.iteration, start);
        ++this.iteration;
        return cb;
    }

    public void printWindow() {
        long elapsed = System.currentTimeMillis() - this.windowStart;
        double recsPerSec = 1000.0 * (double)this.windowCount / (double)elapsed;
        double mbPerSec = 1000.0 * (double)this.windowBytes / (double)elapsed / 1048576.0;
        System.out.printf("%d records processed, %.1f records/sec (%.2f MB/sec), %.1f ms avg latency, %.1f max latency.\n", this.windowCount, recsPerSec, mbPerSec, (double)this.windowTotalLatency / (double)this.windowCount, (double)this.windowMaxLatency);
    }

    public void newWindow() {
        this.windowStart = System.currentTimeMillis();
        this.windowCount = 0L;
        this.windowMaxLatency = 0;
        this.windowTotalLatency = 0L;
        this.windowBytes = 0L;
    }

    public void printTotal() {
        long elapsed = System.currentTimeMillis() - this.start;
        double recsPerSec = 1000.0 * (double)this.count / (double)elapsed;
        double mbPerSec = 1000.0 * (double)this.bytes / (double)elapsed / 1048576.0;
        int[] percs = PerformanceStats.percentiles(this.latencies, this.index, 0.5, 0.95, 0.99, 0.999);
        System.out.printf("%d records processed, %f records/sec (%.2f MB/sec), %.2f ms avg latency, %.2f ms max latency, %d ms 50th, %d ms 95th, %d ms 99th, %d ms 99.9th.\n", this.count, recsPerSec, mbPerSec, (double)this.totalLatency / (double)this.count, (double)this.maxLatency, percs[0], percs[1], percs[2], percs[3]);
    }

    private static int[] percentiles(int[] latencies, int count, double ... percentiles) {
        int size = Math.min(count, latencies.length);
        Arrays.sort(latencies, 0, size);
        int[] values = new int[percentiles.length];
        for (int i = 0; i < percentiles.length; ++i) {
            int index = (int)(percentiles[i] * (double)size);
            values[i] = latencies[index];
        }
        return values;
    }

    public final class Callback {
        private final long start;
        private final int iteration;

        public Callback(int iter, long start) {
            this.start = start;
            this.iteration = iter;
        }

        public void onCompletion(int records, long bytes) {
            long now = System.currentTimeMillis();
            int latency = (int)(now - this.start);
            PerformanceStats.this.record(this.iteration, latency, records, bytes, now);
        }
    }
}

