/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;

public class BitSetCoder
extends AtomicCoder<BitSet> {
    private static final BitSetCoder INSTANCE = new BitSetCoder();
    private static final ByteArrayCoder BYTE_ARRAY_CODER = ByteArrayCoder.of();

    private BitSetCoder() {
    }

    public static BitSetCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(BitSet value, OutputStream outStream) throws CoderException, IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(BitSet value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null BitSet");
        }
        BYTE_ARRAY_CODER.encodeAndOwn(value.toByteArray(), outStream, context);
    }

    @Override
    public BitSet decode(InputStream inStream) throws CoderException, IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public BitSet decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
        return BitSet.valueOf(BYTE_ARRAY_CODER.decode(inStream, context));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        BitSetCoder.verifyDeterministic(this, "BitSetCoder requires its ByteArrayCoder to be deterministic.", BYTE_ARRAY_CODER);
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }
}

