/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class ListCoder<T>
extends IterableLikeCoder<T, List<T>> {
    public static <T> ListCoder<T> of(Coder<T> elemCoder) {
        return new ListCoder<T>(elemCoder);
    }

    @Override
    protected final List<T> decodeToIterable(List<T> decodedElements) {
        return decodedElements;
    }

    protected ListCoder(Coder<T> elemCoder) {
        super(elemCoder, "List");
    }

    @Override
    public boolean consistentWithEquals() {
        return this.getElemCoder().consistentWithEquals();
    }

    @Override
    public Object structuralValue(List<T> values) {
        if (this.consistentWithEquals()) {
            return values;
        }
        ArrayList<Object> ret = new ArrayList<Object>(values.size());
        for (T value : values) {
            ret.add(this.getElemCoder().structuralValue(value));
        }
        return ret;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        ListCoder.verifyDeterministic(this, "ListCoder.elemCoder must be deterministic", this.getElemCoder());
    }

    @Override
    public TypeDescriptor<List<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<List<T>>(this.getClass()){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

