/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.MetricsSink;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;

@Experimental(value=Experimental.Kind.METRICS)
public interface MetricsOptions
extends PipelineOptions {
    @Description(value="The beam sink class to which the metrics will be pushed")
    @Default.InstanceFactory(value=NoOpMetricsSink.class)
    public Class<? extends MetricsSink> getMetricsSink();

    public void setMetricsSink(Class<? extends MetricsSink> var1);

    @Description(value="The metrics push period in seconds")
    @Default.Long(value=5L)
    public Long getMetricsPushPeriod();

    public void setMetricsPushPeriod(Long var1);

    @Description(value="MetricsHttpSink url")
    public String getMetricsHttpSinkUrl();

    public void setMetricsHttpSinkUrl(String var1);

    @Description(value="The graphite metrics host")
    public String getMetricsGraphiteHost();

    public void setMetricsGraphiteHost(String var1);

    @Description(value="The graphite metrics port")
    @Default.Integer(value=2003)
    public Integer getMetricsGraphitePort();

    public void setMetricsGraphitePort(Integer var1);

    public static class NoOpMetricsSink
    implements DefaultValueFactory<Class<? extends MetricsSink>> {
        @Override
        public Class<? extends MetricsSink> create(PipelineOptions options) {
            try {
                Class<?> noOpMetricsSinkClass = Class.forName("org.apache.beam.runners.core.metrics.NoOpMetricsSink", true, ReflectHelpers.findClassLoader());
                return noOpMetricsSinkClass;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("NoOpMetricsSink was not found on classpath", new Object[0]));
            }
        }
    }
}

