/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.OutputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.UnsafeByteOperations;

@NotThreadSafe
public final class ByteStringOutputStream
extends OutputStream {
    private static final int DEFAULT_CAPACITY = 128;
    private static final int MAX_CHUNK_SIZE = 262144;
    private ByteString result;
    private byte[] buffer;
    private int bufferPos;

    public ByteStringOutputStream() {
        this(128);
    }

    public ByteStringOutputStream(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity < 0");
        }
        this.buffer = new byte[initialCapacity];
        this.result = ByteString.EMPTY;
    }

    @Override
    public void write(int b) {
        if (this.bufferPos == this.buffer.length) {
            this.result = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer));
            this.buffer = new byte[Math.min(Math.max(1, this.result.size()), 262144)];
            this.bufferPos = 0;
        }
        this.buffer[this.bufferPos++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        int remainingSpaceInBuffer = this.buffer.length - this.bufferPos;
        while (length > remainingSpaceInBuffer) {
            System.arraycopy(b, offset, this.buffer, this.bufferPos, remainingSpaceInBuffer);
            offset += remainingSpaceInBuffer;
            this.result = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer));
            remainingSpaceInBuffer = Math.min(Math.max(length -= remainingSpaceInBuffer, this.result.size()), 262144);
            this.buffer = new byte[remainingSpaceInBuffer];
            this.bufferPos = 0;
        }
        System.arraycopy(b, offset, this.buffer, this.bufferPos, length);
        this.bufferPos += length;
    }

    public ByteString toByteString() {
        return this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)0, (int)this.bufferPos));
    }

    public ByteString toByteStringAndReset() {
        ByteString rval;
        if (this.bufferPos > 0) {
            boolean copy;
            if (this.buffer.length <= 128) {
                copy = true;
            } else if (this.buffer.length <= 1024) {
                copy = (double)this.bufferPos <= (double)this.buffer.length * 0.875;
            } else if (this.buffer.length <= 8192) {
                copy = (double)this.bufferPos <= (double)this.buffer.length * 0.75;
            } else {
                boolean bl = copy = (double)this.bufferPos <= (double)this.buffer.length * 0.4375;
            }
            if (copy) {
                byte[] bufferCopy = new byte[this.bufferPos];
                System.arraycopy(this.buffer, 0, bufferCopy, 0, this.bufferPos);
                rval = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])bufferCopy));
            } else {
                rval = this.result.concat(UnsafeByteOperations.unsafeWrap((byte[])this.buffer, (int)0, (int)this.bufferPos));
                this.buffer = new byte[Math.min(rval.size(), 262144)];
            }
            this.bufferPos = 0;
        } else {
            rval = this.result;
        }
        this.result = ByteString.EMPTY;
        return rval;
    }

    public int size() {
        return this.result.size() + this.bufferPos;
    }

    public String toString() {
        return String.format("<ByteStringOutputStream@%s size=%d>", Integer.toHexString(System.identityHashCode(this)), this.size());
    }
}

