/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.AutoValue_FailsafeValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Instant;

@AutoValue
@Internal
public abstract class FailsafeValueInSingleWindow<T, ErrorT> {
    public abstract T getValue();

    public abstract Instant getTimestamp();

    public abstract BoundedWindow getWindow();

    public abstract PaneInfo getPane();

    public abstract ErrorT getFailsafeValue();

    public static <T, ErrorT> FailsafeValueInSingleWindow<T, ErrorT> of(T value, Instant timestamp, BoundedWindow window, PaneInfo paneInfo, ErrorT failsafeValue) {
        return new AutoValue_FailsafeValueInSingleWindow<T, ErrorT>(value, timestamp, window, paneInfo, failsafeValue);
    }

    public static class Coder<T, ErrorT>
    extends StructuredCoder<FailsafeValueInSingleWindow<T, ErrorT>> {
        private final org.apache.beam.sdk.coders.Coder<T> valueCoder;
        private final org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder;
        private final org.apache.beam.sdk.coders.Coder<BoundedWindow> windowCoder;

        public static <T, ErrorT> Coder<T, ErrorT> of(org.apache.beam.sdk.coders.Coder<T> valueCoder, org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            return new Coder<T, ErrorT>(valueCoder, failsafeValueCoder, windowCoder);
        }

        Coder(org.apache.beam.sdk.coders.Coder<T> valueCoder, org.apache.beam.sdk.coders.Coder<ErrorT> failsafeValueCoder, org.apache.beam.sdk.coders.Coder<? extends BoundedWindow> windowCoder) {
            this.valueCoder = valueCoder;
            this.failsafeValueCoder = failsafeValueCoder;
            this.windowCoder = windowCoder;
        }

        @Override
        public void encode(FailsafeValueInSingleWindow<T, ErrorT> windowedElem, OutputStream outStream) throws IOException {
            this.encode(windowedElem, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(FailsafeValueInSingleWindow<T, ErrorT> windowedElem, OutputStream outStream, Coder.Context context) throws IOException {
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
            this.windowCoder.encode(windowedElem.getWindow(), outStream);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream);
            this.valueCoder.encode(windowedElem.getValue(), outStream);
            this.failsafeValueCoder.encode(windowedElem.getFailsafeValue(), outStream);
        }

        @Override
        public FailsafeValueInSingleWindow<T, ErrorT> decode(InputStream inStream) throws IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public FailsafeValueInSingleWindow<T, ErrorT> decode(InputStream inStream, Coder.Context context) throws IOException {
            Instant timestamp = InstantCoder.of().decode(inStream);
            BoundedWindow window = this.windowCoder.decode(inStream);
            PaneInfo paneInfo = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream);
            T value = this.valueCoder.decode(inStream);
            ErrorT failsafeValue = this.failsafeValueCoder.decode(inStream);
            return new AutoValue_FailsafeValueInSingleWindow<T, ErrorT>(value, timestamp, window, paneInfo, failsafeValue);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.valueCoder, this.failsafeValueCoder);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getComponents() {
            return ImmutableList.of(this.valueCoder, this.failsafeValueCoder, this.windowCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.valueCoder.verifyDeterministic();
            this.failsafeValueCoder.verifyDeterministic();
            this.windowCoder.verifyDeterministic();
        }
    }
}

