/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mongodbinput;

import com.mongodb.Cursor;
import com.mongodb.DBObject;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.metadata.MongoDbConnection;
import org.apache.hop.mongo.wrapper.field.MongodbInputDiscoverFieldsImpl;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputData;
import org.apache.hop.pipeline.transforms.mongodbinput.MongoDbInputMeta;

public class MongoDbInput
extends BaseTransform<MongoDbInputMeta, MongoDbInputData> {
    private static final Class<?> PKG = MongoDbInputMeta.class;
    private boolean serverDetermined;
    private Object[] currentInputRowDrivingQuery = null;

    public MongoDbInput(TransformMeta transformMeta, MongoDbInputMeta meta, MongoDbInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        try {
            boolean hasNext;
            if (((MongoDbInputMeta)this.meta).getExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery == null) {
                this.currentInputRowDrivingQuery = this.getRow();
                if (this.currentInputRowDrivingQuery == null) {
                    this.setOutputDone();
                    return false;
                }
                if (!this.first) {
                    this.initQuery();
                }
            }
            if (this.first) {
                ((MongoDbInputData)this.data).outputRowMeta = new RowMeta();
                ((MongoDbInputMeta)this.meta).getFields(((MongoDbInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                this.initQuery();
                this.first = false;
                ((MongoDbInputData)this.data).init();
            }
            boolean bl = (((MongoDbInputMeta)this.meta).isQueryIsPipeline() ? ((MongoDbInputData)this.data).pipelineResult.hasNext() : ((MongoDbInputData)this.data).cursor.hasNext()) && !this.isStopped() ? true : (hasNext = false);
            if (hasNext) {
                ServerAddress s;
                DBObject nextDoc = null;
                Object[] row = null;
                nextDoc = ((MongoDbInputMeta)this.meta).isQueryIsPipeline() ? ((MongoDbInputData)this.data).pipelineResult.next() : ((MongoDbInputData)this.data).cursor.next();
                if (!((MongoDbInputMeta)this.meta).isQueryIsPipeline() && !this.serverDetermined && (s = ((MongoDbInputData)this.data).cursor.getServerAddress()) != null) {
                    this.serverDetermined = true;
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{s.toString()}));
                }
                if (((MongoDbInputMeta)this.meta).isOutputJson() || ((MongoDbInputMeta)this.meta).getMongoFields() == null || ((MongoDbInputMeta)this.meta).getMongoFields().size() == 0) {
                    String json = JSON.serialize((Object)nextDoc);
                    row = RowDataUtil.allocateRowData((int)((MongoDbInputData)this.data).outputRowMeta.size());
                    int index = 0;
                    row[index++] = json;
                    this.putRow(((MongoDbInputData)this.data).outputRowMeta, row);
                } else {
                    Object[][] outputRows = ((MongoDbInputData)this.data).mongoDocumentToHop(nextDoc, (IVariables)this);
                    for (int i = 0; i < outputRows.length; ++i) {
                        this.putRow(((MongoDbInputData)this.data).outputRowMeta, outputRows[i]);
                    }
                }
            } else {
                if (!((MongoDbInputMeta)this.meta).getExecuteForEachIncomingRow()) {
                    this.setOutputDone();
                    return false;
                }
                this.currentInputRowDrivingQuery = null;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof HopException) {
                throw (HopException)((Object)e);
            }
            throw new HopException((Throwable)e);
        }
    }

    protected void initQuery() throws HopException, MongoDbException {
        if (((MongoDbInputData)this.data).cursor != null) {
            ((MongoDbInputData)this.data).cursor.close();
        }
        if (this.log.isDetailed()) {
            this.serverDetermined = false;
        }
        String query = this.resolve(((MongoDbInputMeta)this.meta).getJsonQuery());
        String fields = this.resolve(((MongoDbInputMeta)this.meta).getFieldsName());
        if (StringUtils.isEmpty((String)query) && StringUtils.isEmpty((String)fields)) {
            if (((MongoDbInputMeta)this.meta).isQueryIsPipeline()) {
                throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            ((MongoDbInputData)this.data).cursor = ((MongoDbInputData)this.data).collection.find();
        } else if (((MongoDbInputMeta)this.meta).isQueryIsPipeline()) {
            Cursor cursor;
            if (StringUtils.isEmpty((String)query)) {
                throw new HopException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.EmptyAggregationPipeline", (String[])new String[0]));
            }
            if (((MongoDbInputMeta)this.meta).getExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery != null) {
                query = this.resolve(query, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.QueryPulledDataFrom", (String[])new String[]{query}));
            List<DBObject> pipeline = MongodbInputDiscoverFieldsImpl.jsonPipelineToDBObjectList(query);
            DBObject firstP = pipeline.get(0);
            DBObject[] remainder = null;
            if (pipeline.size() > 1) {
                remainder = new DBObject[pipeline.size() - 1];
                for (int i = 1; i < pipeline.size(); ++i) {
                    remainder[i - 1] = pipeline.get(i);
                }
            } else {
                remainder = new DBObject[]{};
            }
            ((MongoDbInputData)this.data).pipelineResult = cursor = ((MongoDbInputData)this.data).collection.aggregate(firstP, remainder);
        } else {
            if (((MongoDbInputMeta)this.meta).getExecuteForEachIncomingRow() && this.currentInputRowDrivingQuery != null) {
                query = this.resolve(query, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
                fields = this.resolve(fields, this.getInputRowMeta(), this.currentInputRowDrivingQuery);
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"MongoDbInput.Message.ExecutingQuery", (String[])new String[]{query}));
            DBObject dbObject = (DBObject)JSON.parse((String)(StringUtils.isEmpty((String)query) ? "{}" : query));
            DBObject dbObject2 = (DBObject)JSON.parse((String)fields);
            ((MongoDbInputData)this.data).cursor = ((MongoDbInputData)this.data).collection.find(dbObject, dbObject2);
        }
    }

    public boolean init() {
        if (super.init()) {
            String connectionName = this.resolve(((MongoDbInputMeta)this.meta).getConnectionName());
            try {
                try {
                    ((MongoDbInputData)this.data).connection = (MongoDbConnection)this.metadataProvider.getSerializer(MongoDbConnection.class).load(connectionName);
                }
                catch (Exception e) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.ErrorLoadingMongoDbConnection", (String[])new String[]{connectionName}));
                }
                if (((MongoDbInputData)this.data).connection == null) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.MongoDbConnection.NotFound", (String[])new String[]{connectionName}));
                }
                String databaseName = this.resolve(((MongoDbInputData)this.data).connection.getDbName());
                if (StringUtils.isEmpty((String)databaseName)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoDBSpecified", (String[])new String[0]));
                }
                String collection = this.resolve(((MongoDbInputMeta)this.meta).getCollection());
                if (StringUtils.isEmpty((String)collection)) {
                    throw new Exception(BaseMessages.getString(PKG, (String)"MongoInput.ErrorMessage.NoCollectionSpecified", (String[])new String[0]));
                }
                if (!StringUtils.isEmpty((String)((MongoDbInputData)this.data).connection.getAuthenticationUser())) {
                    String authInfo = ((MongoDbInputData)this.data).connection.isUsingKerberos() ? BaseMessages.getString(PKG, (String)"MongoDbInput.Message.KerberosAuthentication", (String[])new String[]{this.resolve(((MongoDbInputData)this.data).connection.getAuthenticationUser())}) : BaseMessages.getString(PKG, (String)"MongoDbInput.Message.NormalAuthentication", (String[])new String[]{this.resolve(((MongoDbInputData)this.data).connection.getAuthenticationUser())});
                    this.logBasic(authInfo);
                }
                ((MongoDbInputData)this.data).clientWrapper = ((MongoDbInputData)this.data).connection.createWrapper((IVariables)this, this.log);
                ((MongoDbInputData)this.data).collection = ((MongoDbInputData)this.data).clientWrapper.getCollection(databaseName, collection);
                if (!((MongoDbInputMeta)this.meta).isOutputJson()) {
                    ((MongoDbInputData)this.data).setMongoFields(((MongoDbInputMeta)this.meta).getMongoFields());
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorConnectingToMongoDb.Exception", (String[])new String[]{((MongoDbInputData)this.data).connection.getHostname(), ((MongoDbInputData)this.data).connection.getPort(), ((MongoDbInputData)this.data).connection.getDbName(), ((MongoDbInputMeta)this.meta).getCollection()}), e);
                return false;
            }
        }
        return false;
    }

    public void dispose() {
        if (((MongoDbInputData)this.data).cursor != null) {
            try {
                ((MongoDbInputData)this.data).cursor.close();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        if (((MongoDbInputData)this.data).clientWrapper != null) {
            try {
                ((MongoDbInputData)this.data).clientWrapper.dispose();
            }
            catch (MongoDbException e) {
                this.log.logError(e.getMessage());
            }
        }
        super.dispose();
    }
}

