/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.search.ISearchQuery;

public class SearchQuery
implements ISearchQuery {
    private String searchString;
    private boolean caseSensitive;
    private boolean regEx;

    public SearchQuery() {
    }

    public SearchQuery(String searchString, boolean caseSensitive, boolean regEx) {
        this.searchString = searchString;
        this.caseSensitive = caseSensitive;
        this.regEx = regEx;
    }

    @Override
    public boolean matches(String string) {
        if (StringUtils.isEmpty((String)this.searchString)) {
            return StringUtils.isNotEmpty((String)string);
        }
        if (this.regEx) {
            if (this.caseSensitive) {
                return string.matches(this.searchString);
            }
            return string.toLowerCase().matches(this.searchString.toLowerCase());
        }
        if (this.caseSensitive) {
            return string.contains(this.searchString);
        }
        return string.toLowerCase().contains(this.searchString.toLowerCase());
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean isRegEx() {
        return this.regEx;
    }

    public void setRegEx(boolean regEx) {
        this.regEx = regEx;
    }
}

