/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;

public class FlinkMultiOutputPruningFunction<T>
extends RichFlatMapFunction<WindowedValue<RawUnionValue>, WindowedValue<T>> {
    private final int ourOutputTag;
    private final SerializablePipelineOptions options;

    public FlinkMultiOutputPruningFunction(int ourOutputTag, PipelineOptions options) {
        this.ourOutputTag = ourOutputTag;
        this.options = new SerializablePipelineOptions(options);
    }

    public void open(Configuration parameters) {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options.get());
    }

    public void flatMap(WindowedValue<RawUnionValue> windowedValue, Collector<WindowedValue<T>> collector) throws Exception {
        int unionTag = ((RawUnionValue)windowedValue.getValue()).getUnionTag();
        if (unionTag == this.ourOutputTag) {
            collector.collect((Object)windowedValue.withValue(((RawUnionValue)windowedValue.getValue()).getValue()));
        }
    }
}

