/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import org.apache.beam.runners.flink.translation.types.EncodedValueTypeInformation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Bytes;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class WindowedKvKeySelector<InputT, K>
implements KeySelector<WindowedValue<KV<K, InputT>>, byte[]>,
ResultTypeQueryable<byte[]> {
    private final Coder<K> keyCoder;
    private final Coder<? extends BoundedWindow> windowCoder;

    public WindowedKvKeySelector(Coder<K> keyCoder, Coder<? extends BoundedWindow> windowCoder) {
        this.keyCoder = keyCoder;
        this.windowCoder = windowCoder;
    }

    public byte[] getKey(WindowedValue<KV<K, InputT>> value) throws Exception {
        byte[] encodedKey = CoderUtils.encodeToByteArray(this.keyCoder, (Object)((KV)value.getValue()).getKey());
        byte[] encodedWindow = CoderUtils.encodeToByteArray(this.windowCoder, (Object)((BoundedWindow)Iterables.getOnlyElement((Iterable)value.getWindows())));
        return Bytes.concat((byte[][])new byte[][]{encodedKey, encodedWindow});
    }

    public TypeInformation<byte[]> getProducedType() {
        return new EncodedValueTypeInformation();
    }
}

