/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.DBCellEditor;
import com.ibm.as400.vaccess.DBCellRenderer;
import com.ibm.as400.vaccess.DBCellSelector;
import com.ibm.as400.vaccess.ErrorDialogAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.SQLResultSetTableModel;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.DefaultEditorKit;

public class SQLResultSetTablePane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    transient JTable table_;
    transient JScrollPane tablePane_;
    SQLResultSetTableModel model_;
    private Color tableColor_ = null;
    private boolean tableShowHorizontalLines_ = true;
    private boolean tableShowVerticalLines_ = true;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient ErrorEventSupport errorListeners_ = new ErrorEventSupport(this);
    private transient ListSelectionEventSupport selectionListeners_ = new ListSelectionEventSupport(this);
    private transient WorkingCursorAdapter worker_ = new WorkingCursorAdapter(this);
    DBCellRenderer rightCell_ = new DBCellRenderer(4);
    DBCellRenderer leftCell_ = new DBCellRenderer(2);
    DBCellSelector cellSelector_ = new DBCellSelector();
    DBCellEditor cellEditor_ = new DBCellEditor();
    private static final int TYPE_CHAR = 1;
    private static final int TYPE_TIME = 2;
    private static final int TYPE_TIMESTAMP = 3;
    private static final int TYPE_DATE = 4;
    private static final int TYPE_BIT = 5;
    private static final int TYPE_NUMBER = 6;

    public SQLResultSetTablePane() {
        this.model_ = new SQLResultSetTableModel();
        this.initializeTransient();
    }

    public SQLResultSetTablePane(SQLConnection sQLConnection, String string) {
        this.model_ = new SQLResultSetTableModel(sQLConnection, string);
        this.initializeTransient();
    }

    public SQLResultSetTablePane(ResultSet resultSet, boolean bl) {
        this.model_ = new SQLResultSetTableModel(resultSet, bl);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorListeners_.addErrorListener(errorListener);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionListeners_.addListSelectionListener(listSelectionListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.addPropertyChangeListener(propertyChangeListener);
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.addVetoableChangeListener(vetoableChangeListener);
        super.addVetoableChangeListener(vetoableChangeListener);
    }

    public void clearWarnings() {
        this.model_.clearWarnings();
    }

    public void close() {
        this.model_.close();
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public String getColumnTitle(int n) {
        try {
            return (String)this.table_.getColumnModel().getColumn(n).getHeaderValue();
        }
        catch (Exception exception) {
            Trace.log(4, "getColumnTitle() error:" + exception);
            return null;
        }
    }

    public int getColumnWidth(int n) {
        try {
            return this.table_.getColumnModel().getColumn(n).getPreferredWidth();
        }
        catch (Exception exception) {
            Trace.log(4, "getColumnWidth() error:" + exception);
            return 0;
        }
    }

    public SQLConnection getConnection() {
        return this.model_.getConnection();
    }

    public SQLResultSetTableModel getDataModel() {
        return this.model_;
    }

    public Color getGridColor() {
        return this.tableColor_;
    }

    public String getQuery() {
        return this.model_.getQuery();
    }

    public ResultSet getResultSet() {
        return this.model_.getResultSet();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    public boolean getShowHorizontalLines() {
        return this.tableShowHorizontalLines_;
    }

    public boolean getShowVerticalLines() {
        return this.tableShowVerticalLines_;
    }

    public String getStringValueAt(int n, int n2) {
        if (n >= this.model_.getRowCount()) {
            Trace.log(4, "getStringValueAt() column out of range");
            return null;
        }
        try {
            TableColumnModel tableColumnModel = this.getColumnModel();
            Component component = tableColumnModel.getColumn(n2).getCellRenderer().getTableCellRendererComponent(this.table_, this.getValueAt(n, n2), false, false, n, n2);
            if (component instanceof JLabel) {
                return ((JLabel)component).getText();
            }
            return null;
        }
        catch (Exception exception) {
            Trace.log(4, "getStringValueAt() error:" + exception);
            return null;
        }
    }

    public Object getValueAt(int n, int n2) {
        try {
            return this.model_.getValueAt(n, this.getColumnModel().getColumn(n2).getModelIndex());
        }
        catch (Exception exception) {
            Trace.log(4, "getStringValueAt() error:" + exception);
            return null;
        }
    }

    public SQLWarning getWarnings() {
        return this.model_.getWarnings();
    }

    void handleFocus(FocusEvent focusEvent) {
        this.processFocusEvent(new FocusEvent(this, focusEvent.getID(), focusEvent.isTemporary()));
    }

    private void initializeTransient() {
        boolean bl;
        this.table_ = new JTable();
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setModel(this.model_);
        this.model_.setTable(this.table_);
        this.table_.setAutoResizeMode(0);
        this.table_.setSelectionMode(2);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setColumnSelectionAllowed(true);
        this.table_.setCellSelectionEnabled(true);
        try {
            Class.forName("javax.swing.ActionMap");
            bl = true;
        }
        catch (Throwable throwable) {
            Trace.log(4, "Unable to load JDK 1.3 classes. Will use old behavior for SQLResultSetTablePane.");
            bl = false;
        }
        if (bl) {
            Object object = null;
            JTextField jTextField = new JTextField();
            ActionMap actionMap = jTextField.getActionMap();
            Object[] objectArray = actionMap.allKeys();
            for (int i = 0; i < objectArray.length && object == null; ++i) {
                if (!(actionMap.get(objectArray[i]) instanceof DefaultEditorKit.CopyAction)) continue;
                object = objectArray[i];
            }
            if (object != null) {
                InputMap inputMap = jTextField.getInputMap();
                KeyStroke[] keyStrokeArray = inputMap.allKeys();
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    Object object2 = inputMap.get(keyStrokeArray[i]);
                    if (!object2.equals(object)) continue;
                    this.table_.getInputMap().put(keyStrokeArray[i], object);
                }
                if (this.table_.getInputMap().size() > 0) {
                    AbstractAction abstractAction = new AbstractAction("copy"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (actionEvent.getSource() == SQLResultSetTablePane.this.table_) {
                                StringBuffer stringBuffer = new StringBuffer();
                                int[] nArray = SQLResultSetTablePane.this.table_.getSelectedRows();
                                int[] nArray2 = SQLResultSetTablePane.this.table_.getSelectedColumns();
                                for (int i = 0; i < nArray.length; ++i) {
                                    for (int j = 0; j < nArray2.length; ++j) {
                                        if (!SQLResultSetTablePane.this.table_.isCellSelected(nArray[i], nArray2[j])) continue;
                                        stringBuffer.append(SQLResultSetTablePane.this.table_.getValueAt(nArray[i], nArray2[j]));
                                        stringBuffer.append('\t');
                                    }
                                    stringBuffer.append('\n');
                                }
                                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
                            } else {
                                Trace.log(4, "Copy action received from unknown source: " + actionEvent.getSource());
                            }
                        }
                    };
                    this.table_.getActionMap().put(object, abstractAction);
                } else {
                    Trace.log(4, "Table copy function not enabled. No key bindings found.");
                }
            } else {
                Trace.log(4, "Table copy function not enabled. No copy actions found.");
            }
        }
        if (this.tableColor_ == null) {
            this.tableColor_ = this.table_.getGridColor();
        }
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.model_.addErrorListener(this.errorListeners_);
        this.model_.addWorkingListener(this.worker_);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
        this.setLayout(new BorderLayout());
        this.tablePane_ = new JScrollPane(this.table_);
        this.add("Center", this.tablePane_);
        this.table_.setDoubleBuffered(true);
        this.tablePane_.getViewport().setBackingStoreEnabled(true);
        this.tablePane_.setDoubleBuffered(true);
        this.tablePane_.getViewport().setDoubleBuffered(true);
        if (!bl) {
            this.tablePane_.getViewport().putClientProperty("EnableWindowBlit", Boolean.TRUE);
        }
        this.table_.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                SQLResultSetTablePane.this.handleFocus(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                SQLResultSetTablePane.this.handleFocus(focusEvent);
            }
        });
        this.addFocusListener(new SerializationListener(this));
        this.addFocusListener(new SerializationListener(this.model_, this.table_));
    }

    public void load() {
        this.model_.load();
        this.refreshHeadings();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.model_.addPropertyChangeListener(this.changeListeners_);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.model_.addVetoableChangeListener(this.vetoListeners_);
        this.errorListeners_ = new ErrorEventSupport(this);
        this.model_.addErrorListener(this.errorListeners_);
        this.worker_ = new WorkingCursorAdapter(this);
        this.model_.addWorkingListener(this.worker_);
        this.selectionListeners_ = new ListSelectionEventSupport(this);
        this.initializeTransient();
        this.table_.setGridColor(this.tableColor_);
        this.table_.setShowHorizontalLines(this.tableShowHorizontalLines_);
        this.table_.setShowVerticalLines(this.tableShowVerticalLines_);
    }

    public void refreshHeadings() {
        Runnable runnable = new Runnable(){

            public void run() {
                TableColumnModel tableColumnModel = SQLResultSetTablePane.this.table_.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                TableColumn[] tableColumnArray = new TableColumn[n];
                Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    tableColumnArray[n2] = enumeration.nextElement();
                    ++n2;
                }
                for (n2 = 0; n2 < n; ++n2) {
                    tableColumnModel.removeColumn(tableColumnArray[n2]);
                }
                n2 = SQLResultSetTablePane.this.model_.getColumnCount();
                int n3 = 0;
                if (SQLResultSetTablePane.this.table_.getFont() != null) {
                    n3 = ((Component)SQLResultSetTablePane.this.table_).getFontMetrics(SQLResultSetTablePane.this.table_.getFont()).charWidth('M');
                }
                for (int i = 0; i < n2; ++i) {
                    int n4;
                    TableColumn tableColumn = new TableColumn(i);
                    tableColumn.setIdentifier(SQLResultSetTablePane.this.model_.getColumnID(i));
                    int n5 = SQLResultSetTablePane.this.model_.getColumnType(i);
                    switch (n5) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            n4 = 6;
                            break;
                        }
                        case 91: {
                            n4 = 4;
                            break;
                        }
                        case 92: {
                            n4 = 2;
                            break;
                        }
                        case 93: {
                            n4 = 3;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            n4 = 5;
                            break;
                        }
                        default: {
                            n4 = 1;
                        }
                    }
                    String string = SQLResultSetTablePane.this.model_.getColumnName(i);
                    if (n4 == 1 || n4 == 5 || n4 == 4 || n4 == 2 || n4 == 3) {
                        tableColumn.setCellRenderer(SQLResultSetTablePane.this.leftCell_);
                        tableColumn.setHeaderRenderer(new VObjectHeaderRenderer(string, 2));
                    } else {
                        tableColumn.setCellRenderer(SQLResultSetTablePane.this.rightCell_);
                        tableColumn.setHeaderRenderer(new VObjectHeaderRenderer(string, 4));
                    }
                    if (n3 != 0) {
                        int n6;
                        int n7 = SQLResultSetTablePane.this.model_.getColumnWidth(i);
                        if (n4 == 5) {
                            n7 *= 2;
                        }
                        int n8 = n7 > (n6 = string.length()) ? n7 : n6;
                        tableColumn.setPreferredWidth(n8 * n3 + 10);
                    }
                    if (!SQLResultSetTablePane.this.model_.isUpdatable()) {
                        tableColumn.setCellEditor(SQLResultSetTablePane.this.cellSelector_);
                    } else if (n4 == 1) {
                        tableColumn.setCellEditor(SQLResultSetTablePane.this.cellEditor_);
                    }
                    SQLResultSetTablePane.this.table_.addColumn(tableColumn);
                }
                if (n == 0 && n2 > 0) {
                    if (SQLResultSetTablePane.this.tablePane_ != null) {
                        SQLResultSetTablePane.this.remove(SQLResultSetTablePane.this.tablePane_);
                    }
                    SQLResultSetTablePane.this.tablePane_ = new JScrollPane(SQLResultSetTablePane.this.table_);
                    SQLResultSetTablePane.this.add("Center", SQLResultSetTablePane.this.tablePane_);
                }
                SQLResultSetTablePane.this.validate();
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Error error) {
            Trace.log(1, "invokeAndWait error:" + error);
            runnable.run();
        }
        catch (Exception exception) {
            Trace.log(2, "invokeAndWait exception:" + exception);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorListeners_.removeErrorListener(errorListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionListeners_.removeListSelectionListener(listSelectionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners_.removePropertyChangeListener(propertyChangeListener);
        super.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoListeners_.removeVetoableChangeListener(vetoableChangeListener);
        super.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void setColumnTitle(int n, String string) {
        try {
            this.table_.getColumnModel().getColumn(n).setHeaderValue(string);
        }
        catch (Exception exception) {
            Trace.log(4, "setColumnTitle() error:" + exception);
        }
        this.validate();
        this.repaint();
    }

    public void setColumnWidth(int n, int n2) {
        try {
            this.table_.getColumnModel().getColumn(n).setPreferredWidth(n2);
            this.table_.getColumnModel().getColumn(n).setWidth(n2);
        }
        catch (Exception exception) {
            Trace.log(4, "setColumnWidth() error:" + exception);
        }
        this.validate();
        this.repaint();
    }

    public void setConnection(SQLConnection sQLConnection) throws PropertyVetoException {
        this.model_.setConnection(sQLConnection);
    }

    public void setGridColor(Color color) {
        this.table_.setGridColor(color);
        this.tableColor_ = color;
    }

    public void setQuery(String string) throws PropertyVetoException {
        this.model_.setQuery(string);
    }

    public void setResultSet(ResultSet resultSet) {
        this.model_.setResultSet(resultSet);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.table_.getSelectionModel().removeListSelectionListener(this.selectionListeners_);
        this.table_.setSelectionModel(listSelectionModel);
        this.table_.getSelectionModel().addListSelectionListener(this.selectionListeners_);
    }

    public void setShowHorizontalLines(boolean bl) {
        this.table_.setShowHorizontalLines(bl);
        this.tableShowHorizontalLines_ = bl;
    }

    public void setShowVerticalLines(boolean bl) {
        this.table_.setShowVerticalLines(bl);
        this.tableShowVerticalLines_ = bl;
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String string = "X";
            boolean bl = true;
            while (string != null && !"exit".equalsIgnoreCase(string)) {
                Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                Connection connection = DriverManager.getConnection("jdbc:as400://" + stringArray[0], stringArray[1], stringArray[2]);
                Statement statement = connection.createStatement(1004, 1007);
                ResultSet resultSet = statement.executeQuery("SELECT * FROM QSYS2.SYSCOLUMNS");
                SQLResultSetTablePane sQLResultSetTablePane = new SQLResultSetTablePane(resultSet, false);
                JFrame jFrame = new JFrame("My Window");
                jFrame.getContentPane().add(sQLResultSetTablePane);
                sQLResultSetTablePane.addErrorListener(new ErrorDialogAdapter(jFrame));
                jFrame.pack();
                jFrame.show();
                sQLResultSetTablePane.load();
                System.out.println("Table loaded Sleeping for 10 minutes");
                try {
                    Thread.sleep(600000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

