/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserList;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUserList;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VUserAndGroup
implements VNode,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String allUsersText_ = ResourceLoader.getText("USER_ALL_USERS").trim();
    private static final String usersNotInGroupsText_ = ResourceLoader.getText("USER_USERS_NOT_IN_GROUPS").trim();
    private static final String groupsText_ = ResourceLoader.getText("USER_GROUPS").trim();
    private static Icon icon16_ = ResourceLoader.getIcon("VUserList16.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private static Icon icon32_ = ResourceLoader.getIcon("VUserList32.gif", ResourceLoader.getText("USER_LIST_DESCRIPTION"));
    private AS400 as400_;
    private VNode parent_;
    private transient VNode[] children_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    private static TableColumnModel detailsColumnModel_;
    private static String nameColumnHeader_;
    private static String descriptionColumnHeader_;
    private static String description_;

    public VUserAndGroup(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
        this.initializeTransient();
    }

    public VUserAndGroup(VNode vNode, AS400 aS400) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.as400_ = aS400;
        this.parent_ = vNode;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        return null;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getChildCount() {
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public VObject getDetailsChildAt(int n) {
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getDetailsChildCount() {
        return this.children_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    public int getDetailsIndex(VObject vObject) {
        for (int i = 0; i < this.children_.length; ++i) {
            if (!this.children_[i].equals(vObject)) continue;
            return i;
        }
        return -1;
    }

    public Icon getIcon(int n, boolean bl) {
        if (n != 32) {
            return icon16_;
        }
        return icon32_;
    }

    public int getIndex(TreeNode treeNode) {
        for (int i = 0; i < this.children_.length; ++i) {
            if (!this.children_[i].equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    private String getListName(UserList userList) {
        String string = userList.getUserInfo();
        String string2 = userList.getGroupInfo();
        if (string.toLowerCase().equals("*all") && string2.toLowerCase().equals("*none")) {
            return allUsersText_;
        }
        if (string.toLowerCase().equals("*member") && string2.toLowerCase().equals("*nogroup")) {
            return usersNotInGroupsText_;
        }
        if (string.toLowerCase().equals("*group") && string2.toLowerCase().equals("*none")) {
            return groupsText_;
        }
        Trace.log(2, "userInfo or groupInfo's value is invalid");
        Trace.log(3, "userInfo : " + string);
        Trace.log(3, "groupInfo : " + string2);
        return "";
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public VPropertiesPane getPropertiesPane() {
        return null;
    }

    public Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        return null;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public String getText() {
        return description_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.children_ = new VUserList[3];
        UserList[] userListArray = new UserList[]{new UserList(this.as400_, "*ALL", "*NONE"), new UserList(this.as400_, "*GROUP", "*NONE"), new UserList(this.as400_, "*MEMBER", "*NOGROUP")};
        for (int i = 0; i < 3; ++i) {
            this.children_[i] = new VUserList(userListArray[i], this.getListName(userListArray[i]));
            ((VUserList)this.children_[i]).parent_ = this;
            this.children_[i].addErrorListener(this.errorEventSupport_);
            this.children_[i].addVObjectListener(this.objectEventSupport_);
            this.children_[i].addWorkingListener(this.workingEventSupport_);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isSortable() {
        return false;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.as400_.connectService(2);
            for (int i = 0; i < this.children_.length; ++i) {
                this.children_[i].load();
            }
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        if (vObjectListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
    }

    public String toString() {
        return description_;
    }

    static {
        nameColumnHeader_ = ResourceLoader.getText("USER_LIST_NAME");
        descriptionColumnHeader_ = ResourceLoader.getText("USER_DESCRIPTION_PROMPT");
        description_ = ResourceLoader.getText("USER_USER_AND_GROUP");
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VObject.NAME_PROPERTY);
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VObject.DESCRIPTION_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer());
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn2.setHeaderValue(descriptionColumnHeader_);
        vTableColumn2.setPreferredCharWidth(70);
        detailsColumnModel_.addColumn(vTableColumn2);
    }
}

