/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.FieldSelector;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfig;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.ReplicaInfo;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class InstanceConfigInfo {
    private final InstanceConfigId id;
    private final String displayName;
    private final List<ReplicaInfo> replicas;
    private final List<String> leaderOptions;
    private final List<ReplicaInfo> optionalReplicas;
    private final InstanceConfigInfo baseConfig;
    private final Type configType;
    private final String etag;
    private final boolean reconciling;
    private final State state;
    private final Map<String, String> labels;

    public InstanceConfigId getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ReplicaInfo> getReplicas() {
        return this.replicas;
    }

    public List<String> getLeaderOptions() {
        return this.leaderOptions;
    }

    public List<ReplicaInfo> getOptionalReplicas() {
        return this.optionalReplicas;
    }

    public InstanceConfigInfo getBaseConfig() {
        return this.baseConfig;
    }

    public Type getConfigType() {
        return this.configType;
    }

    public String getEtag() {
        return this.etag;
    }

    public boolean getReconciling() {
        return this.reconciling;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Deprecated
    public InstanceConfigInfo(InstanceConfigId id, String displayName) {
        this((BuilderImpl)InstanceConfigInfo.newBuilder(id).setDisplayName(displayName));
    }

    public static Builder newBuilder(InstanceConfigId id) {
        return new BuilderImpl(id);
    }

    public static Builder newBuilder(InstanceConfigId id, InstanceConfigInfo baseConfig) {
        return new BuilderImpl(id, baseConfig);
    }

    @Deprecated
    public InstanceConfigInfo(InstanceConfigId id, String displayName, List<ReplicaInfo> replicas, List<String> leaderOptions) {
        this((BuilderImpl)InstanceConfigInfo.newBuilder(id).setDisplayName(displayName).setReplicas(replicas).setLeaderOptions(leaderOptions));
    }

    InstanceConfigInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.replicas = new ArrayList<ReplicaInfo>(builder.replicas);
        this.leaderOptions = new ArrayList<String>(builder.leaderOptions);
        this.baseConfig = builder.baseConfig;
        this.optionalReplicas = new ArrayList<ReplicaInfo>(builder.optionalReplicas);
        this.configType = builder.configType;
        this.etag = builder.etag;
        this.reconciling = builder.reconciling;
        this.state = builder.state;
        this.labels = ImmutableMap.copyOf((Map)builder.labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstanceConfigInfo)) {
            return false;
        }
        InstanceConfigInfo that = (InstanceConfigInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.replicas, that.replicas) && Objects.equals(this.leaderOptions, that.leaderOptions) && Objects.equals(this.optionalReplicas, that.optionalReplicas) && Objects.equals(this.baseConfig, that.baseConfig) && Objects.equals((Object)this.configType, (Object)that.configType) && Objects.equals(this.etag, that.etag) && Objects.equals(this.reconciling, that.reconciling) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.labels, that.labels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.displayName, this.replicas, this.leaderOptions, this.optionalReplicas, this.baseConfig, this.configType, this.etag, this.reconciling, this.state, this.labels});
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return String.format("Instance Config[%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s]", new Object[]{this.id, this.displayName, this.replicas, this.leaderOptions, this.optionalReplicas, this.baseConfig, this.configType, this.etag, this.reconciling, this.state, this.labels});
    }

    com.google.spanner.admin.instance.v1.InstanceConfig toProto() {
        InstanceConfig.Builder builder = com.google.spanner.admin.instance.v1.InstanceConfig.newBuilder().setName(this.getId().getName()).setDisplayName(this.getDisplayName()).addAllReplicas((Iterable)this.getReplicas().stream().map(ReplicaInfo::getProto).collect(Collectors.toList())).addAllLeaderOptions(this.getLeaderOptions()).setEtag(this.getEtag()).setReconciling(this.getReconciling()).putAllLabels(this.getLabels()).addAllOptionalReplicas((Iterable)this.getOptionalReplicas().stream().map(ReplicaInfo::getProto).collect(Collectors.toList())).setConfigType(InstanceConfigInfo.toProtoConfigType(this.getConfigType())).setState(InstanceConfigInfo.toProtoState(this.getState()));
        if (this.getBaseConfig() != null) {
            builder.setBaseConfig(this.getBaseConfig().getId().getName());
        }
        return builder.build();
    }

    private static InstanceConfig.Type toProtoConfigType(Type type) {
        switch (type) {
            case TYPE_UNSPECIFIED: {
                return InstanceConfig.Type.TYPE_UNSPECIFIED;
            }
            case GOOGLE_MANAGED: {
                return InstanceConfig.Type.GOOGLE_MANAGED;
            }
            case USER_MANAGED: {
                return InstanceConfig.Type.USER_MANAGED;
            }
        }
        throw new IllegalArgumentException("Unknown config type:" + (Object)((Object)type));
    }

    private static InstanceConfig.State toProtoState(State state) {
        switch (state) {
            case STATE_UNSPECIFIED: {
                return InstanceConfig.State.STATE_UNSPECIFIED;
            }
            case CREATING: {
                return InstanceConfig.State.CREATING;
            }
            case READY: {
                return InstanceConfig.State.READY;
            }
        }
        throw new IllegalArgumentException("Unknown state:" + (Object)((Object)state));
    }

    static InstanceConfig fromProto(com.google.spanner.admin.instance.v1.InstanceConfig proto, InstanceAdminClient client) {
        InstanceConfig.Builder builder = ((InstanceConfig.Builder)((InstanceConfig.Builder)((InstanceConfig.Builder)((InstanceConfig.Builder)InstanceConfig.newBuilder(client, InstanceConfigId.of(proto.getName())).setReconciling(proto.getReconciling()).setReplicas(proto.getReplicasList().stream().map(ReplicaInfo::fromProto).collect(Collectors.toList()))).setDisplayName(proto.getDisplayName()).putAllLabels(proto.getLabelsMap())).setEtag(proto.getEtag()).setLeaderOptions((List)proto.getLeaderOptionsList())).setOptionalReplicas(proto.getOptionalReplicasList().stream().map(ReplicaInfo::fromProto).collect(Collectors.toList()))).setState(InstanceConfigInfo.fromProtoState(proto.getState())).setConfigType(InstanceConfigInfo.fromProtoConfigType(proto.getConfigType()));
        if (!proto.getBaseConfig().isEmpty()) {
            builder.setBaseConfig(InstanceConfigInfo.newBuilder(InstanceConfigId.of(proto.getBaseConfig())).build());
        }
        return builder.build();
    }

    private static State fromProtoState(InstanceConfig.State state) {
        switch (state) {
            case STATE_UNSPECIFIED: {
                return State.STATE_UNSPECIFIED;
            }
            case CREATING: {
                return State.CREATING;
            }
            case READY: {
                return State.READY;
            }
        }
        throw new IllegalArgumentException("Unknown state:" + state);
    }

    private static Type fromProtoConfigType(InstanceConfig.Type type) {
        switch (type) {
            case TYPE_UNSPECIFIED: {
                return Type.TYPE_UNSPECIFIED;
            }
            case GOOGLE_MANAGED: {
                return Type.GOOGLE_MANAGED;
            }
            case USER_MANAGED: {
                return Type.USER_MANAGED;
            }
        }
        throw new IllegalArgumentException("Unknown config type:" + type);
    }

    static class BuilderImpl
    extends Builder {
        private InstanceConfigId id;
        private String displayName = "";
        private List<ReplicaInfo> replicas = new ArrayList<ReplicaInfo>();
        private List<String> leaderOptions = new ArrayList<String>();
        private List<ReplicaInfo> optionalReplicas = new ArrayList<ReplicaInfo>();
        private InstanceConfigInfo baseConfig;
        private Type configType = Type.TYPE_UNSPECIFIED;
        private String etag = "";
        private boolean reconciling = false;
        private State state = State.STATE_UNSPECIFIED;
        private Map<String, String> labels = new HashMap<String, String>();

        BuilderImpl(InstanceConfigId id) {
            this.id = id;
        }

        BuilderImpl(InstanceConfigId id, InstanceConfigInfo baseConfig) {
            this.id = id;
            this.baseConfig = baseConfig;
            this.replicas = new ArrayList<ReplicaInfo>(baseConfig.replicas);
        }

        BuilderImpl(InstanceConfigInfo instanceConfigInfo) {
            this.id = instanceConfigInfo.id;
            this.displayName = instanceConfigInfo.displayName;
            this.replicas = new ArrayList<ReplicaInfo>(instanceConfigInfo.replicas);
            this.leaderOptions = new ArrayList<String>(instanceConfigInfo.leaderOptions);
            this.optionalReplicas = new ArrayList<ReplicaInfo>(instanceConfigInfo.optionalReplicas);
            this.baseConfig = instanceConfigInfo.baseConfig;
            this.configType = instanceConfigInfo.configType;
            this.etag = instanceConfigInfo.etag;
            this.reconciling = instanceConfigInfo.reconciling;
            this.state = instanceConfigInfo.state;
            this.labels = new HashMap<String, String>(instanceConfigInfo.labels);
        }

        @Override
        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        protected Builder setReplicas(List<ReplicaInfo> replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        public Builder setLeaderOptions(List<String> leaderOptions) {
            this.leaderOptions = leaderOptions;
            return this;
        }

        @Override
        protected Builder setOptionalReplicas(List<ReplicaInfo> optionalReplicas) {
            this.optionalReplicas = optionalReplicas;
            return this;
        }

        @Override
        protected Builder setBaseConfig(InstanceConfigInfo baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        @Override
        protected Builder setConfigType(Type configType) {
            this.configType = configType;
            return this;
        }

        @Override
        protected Builder setState(State state) {
            this.state = state;
            return this;
        }

        @Override
        public Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        protected Builder setReconciling(boolean reconciling) {
            this.reconciling = reconciling;
            return this;
        }

        @Override
        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public Builder putAllLabels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        @Override
        public Builder addReadOnlyReplicas(List<ReplicaInfo> readOnlyReplicas) {
            this.replicas.addAll(readOnlyReplicas);
            return this;
        }

        @Override
        public InstanceConfigInfo build() {
            return new InstanceConfigInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setDisplayName(String var1);

        protected abstract Builder setReplicas(List<ReplicaInfo> var1);

        protected abstract Builder setOptionalReplicas(List<ReplicaInfo> var1);

        protected abstract Builder setBaseConfig(InstanceConfigInfo var1);

        public abstract Builder setLeaderOptions(List<String> var1);

        protected abstract Builder setConfigType(Type var1);

        protected abstract Builder setState(State var1);

        public abstract Builder setEtag(String var1);

        protected abstract Builder setReconciling(boolean var1);

        public abstract Builder addLabel(String var1, String var2);

        public abstract Builder putAllLabels(Map<String, String> var1);

        public abstract Builder addReadOnlyReplicas(List<ReplicaInfo> var1);

        public abstract InstanceConfigInfo build();
    }

    public static enum State {
        STATE_UNSPECIFIED,
        CREATING,
        READY;

    }

    public static enum Type {
        TYPE_UNSPECIFIED,
        GOOGLE_MANAGED,
        USER_MANAGED;

    }

    public static enum InstanceConfigField implements FieldSelector
    {
        DISPLAY_NAME("display_name"),
        LABELS("labels");

        private final String selector;

        private InstanceConfigField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static FieldMask toFieldMask(Iterable<InstanceConfigField> fields) {
            FieldMask.Builder builder = FieldMask.newBuilder();
            for (InstanceConfigField field : fields) {
                builder.addPaths(field.getSelector());
            }
            return builder.build();
        }
    }
}

