/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.FieldSelector;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.Instance;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class InstanceInfo {
    private final InstanceId id;
    private final InstanceConfigId configId;
    private final String displayName;
    private final int nodeCount;
    private final int processingUnits;
    private final State state;
    private final ImmutableMap<String, String> labels;
    private final Timestamp updateTime;
    private final Timestamp createTime;

    InstanceInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.configId = builder.configId;
        this.displayName = builder.displayName;
        this.nodeCount = builder.nodeCount;
        this.processingUnits = builder.processingUnits;
        this.state = builder.state;
        this.labels = ImmutableMap.copyOf((Map)builder.labels);
        this.updateTime = builder.updateTime;
        this.createTime = builder.createTime;
    }

    public InstanceId getId() {
        return this.id;
    }

    public InstanceConfigId getInstanceConfigId() {
        return this.configId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getProcessingUnits() {
        return this.processingUnits;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.id.getName()).add("configName", this.configId == null ? null : this.configId.getName()).add("displayName", (Object)this.displayName).add("nodeCount", this.nodeCount).add("processingUnits", this.processingUnits).add("state", (Object)this.state).add("labels", this.labels).add("createTime", (Object)this.createTime).add("updateTime", (Object)this.updateTime).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceInfo that = (InstanceInfo)o;
        return this.id.equals(that.id) && Objects.equals(this.configId, that.configId) && Objects.equals(this.displayName, that.displayName) && this.nodeCount == that.nodeCount && this.processingUnits == that.processingUnits && this.state == that.state && Objects.equals(this.labels, that.labels) && Objects.equals(this.updateTime, that.updateTime) && Objects.equals(this.createTime, that.createTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.configId, this.displayName, this.nodeCount, this.processingUnits, this.state, this.labels, this.updateTime, this.createTime});
    }

    Instance toProto() {
        Instance.Builder builder = Instance.newBuilder().setName(this.getId().getName()).setNodeCount(this.getNodeCount()).setProcessingUnits(this.getProcessingUnits()).putAllLabels(this.getLabels());
        if (this.getDisplayName() != null) {
            builder.setDisplayName(this.getDisplayName());
        }
        if (this.getInstanceConfigId() != null) {
            builder.setConfig(this.getInstanceConfigId().getName());
        }
        return builder.build();
    }

    public static Builder newBuilder(InstanceId id) {
        return new BuilderImpl((InstanceId)Preconditions.checkNotNull((Object)id));
    }

    static class BuilderImpl
    extends Builder {
        private InstanceId id;
        private InstanceConfigId configId;
        private String displayName;
        private int nodeCount;
        private int processingUnits;
        private State state;
        private Map<String, String> labels;
        private Timestamp updateTime;
        private Timestamp createTime;

        BuilderImpl(InstanceId id) {
            this.id = id;
            this.labels = new HashMap<String, String>();
        }

        BuilderImpl(InstanceInfo instance) {
            this.id = instance.id;
            this.configId = instance.configId;
            this.displayName = instance.displayName;
            this.nodeCount = instance.nodeCount;
            this.processingUnits = instance.processingUnits;
            this.state = instance.state;
            this.labels = new HashMap<String, String>((Map<String, String>)instance.labels);
            this.updateTime = instance.updateTime;
            this.createTime = instance.createTime;
        }

        @Override
        public BuilderImpl setInstanceConfigId(InstanceConfigId configId) {
            this.configId = configId;
            return this;
        }

        @Override
        public BuilderImpl setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        Builder setUpdateTime(Timestamp updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        Builder setCreateTime(Timestamp createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public BuilderImpl setNodeCount(int nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        @Override
        public BuilderImpl setProcessingUnits(int processingUnits) {
            this.processingUnits = processingUnits;
            return this;
        }

        @Override
        public BuilderImpl setState(State state) {
            this.state = state;
            return this;
        }

        @Override
        public BuilderImpl addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        @Override
        public BuilderImpl putAllLabels(Map<String, String> labels) {
            this.labels.putAll(labels);
            return this;
        }

        @Override
        public InstanceInfo build() {
            return new InstanceInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setInstanceConfigId(InstanceConfigId var1);

        public abstract Builder setDisplayName(String var1);

        Builder setUpdateTime(Timestamp updateTime) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        Builder setCreateTime(Timestamp createTime) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        public abstract Builder setNodeCount(int var1);

        public Builder setProcessingUnits(int processingUnits) {
            throw new UnsupportedOperationException("Unimplemented");
        }

        public abstract Builder setState(State var1);

        public abstract Builder addLabel(String var1, String var2);

        public abstract Builder putAllLabels(Map<String, String> var1);

        public abstract InstanceInfo build();
    }

    public static enum State {
        UNSPECIFIED,
        CREATING,
        READY;

    }

    public static enum InstanceField implements FieldSelector
    {
        DISPLAY_NAME("display_name"),
        NODE_COUNT("node_count"),
        PROCESSING_UNITS("processing_units"),
        LABELS("labels");

        private final String selector;

        static InstanceField[] defaultFieldsToUpdate(InstanceInfo info) {
            if (info.getNodeCount() > 0) {
                return new InstanceField[]{DISPLAY_NAME, NODE_COUNT, LABELS};
            }
            return new InstanceField[]{DISPLAY_NAME, PROCESSING_UNITS, LABELS};
        }

        private InstanceField(String selector) {
            this.selector = selector;
        }

        public String getSelector() {
            return this.selector;
        }

        static FieldMask toFieldMask(InstanceField ... fields) {
            FieldMask.Builder builder = FieldMask.newBuilder();
            for (InstanceField field : fields) {
                builder.addPaths(field.getSelector());
            }
            return builder.build();
        }
    }
}

