/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Statement;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Objects;

public class Partition
implements Serializable {
    private static final long serialVersionUID = 8067099123096783937L;
    private final ByteString partitionToken;
    private final String table;
    private final KeySet keys;
    private final Iterable<String> columns;
    private final String index;
    private final Options readOptions;
    private final Statement statement;
    private final Options queryOptions;
    private final PartitionOptions partitionOptions;

    private Partition(ByteString partitionToken, PartitionOptions partitionOptions, Statement statement, Options queryOption) {
        this.partitionToken = partitionToken;
        this.partitionOptions = partitionOptions;
        this.statement = statement;
        this.queryOptions = queryOption;
        this.table = null;
        this.keys = null;
        this.columns = null;
        this.index = null;
        this.readOptions = null;
    }

    private Partition(ByteString partitionToken, PartitionOptions partitionOptions, String table, String index, KeySet keys, Iterable<String> columns, Options readOptions) {
        this.partitionToken = partitionToken;
        this.partitionOptions = partitionOptions;
        this.table = table;
        this.index = index;
        this.keys = keys;
        this.columns = columns;
        this.readOptions = readOptions;
        this.statement = null;
        this.queryOptions = null;
    }

    static Partition createReadPartition(ByteString partitionToken, PartitionOptions partitionOptions, String table, String index, KeySet keys, Iterable<String> columns, Options readOptions) {
        return new Partition(partitionToken, partitionOptions, table, index, keys, columns, readOptions);
    }

    static Partition createQueryPartition(ByteString partitionToken, PartitionOptions partitionOptions, Statement statement, Options queryOption) {
        return new Partition(partitionToken, partitionOptions, statement, queryOption);
    }

    ByteString getPartitionToken() {
        return this.partitionToken;
    }

    String getTable() {
        return this.table;
    }

    KeySet getKeys() {
        return this.keys;
    }

    Iterable<String> getColumns() {
        return this.columns;
    }

    String getIndex() {
        return this.index;
    }

    Options getReadOptions() {
        return this.readOptions;
    }

    Statement getStatement() {
        return this.statement;
    }

    Options getQueryOptions() {
        return this.queryOptions;
    }

    PartitionOptions getPartitionOptions() {
        return this.partitionOptions;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("partitionToken: ").append(this.partitionToken.toStringUtf8()).append(" partitionOptions: ").append(this.partitionOptions).append(' ');
        if (this.table != null) {
            b.append("table: ").append(this.table).append(' ');
        }
        if (this.index != null) {
            b.append("index: ").append(this.index).append(' ');
        }
        if (this.keys != null) {
            b.append("keys: ").append(this.keys).append(' ');
        }
        if (this.columns != null) {
            b.append("columns: ").append(this.columns).append(' ');
        }
        if (this.readOptions != null) {
            b.append("readOptions: ").append(this.readOptions).append(' ');
        }
        if (this.statement != null) {
            b.append("statement: ").append(this.statement).append(' ');
        }
        if (this.queryOptions != null) {
            b.append("queryOptions: ").append(this.queryOptions).append(' ');
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition that = (Partition)o;
        return Objects.equals(this.getPartitionToken(), that.getPartitionToken()) && Objects.equals(this.getPartitionOptions(), that.getPartitionOptions()) && Objects.equals(this.getTable(), that.getTable()) && Objects.equals(this.getKeys(), that.getKeys()) && Objects.equals(this.getColumns(), that.getColumns()) && Objects.equals(this.getIndex(), that.getIndex()) && Objects.equals(this.getReadOptions(), that.getReadOptions()) && Objects.equals(this.getStatement(), that.getStatement()) && Objects.equals(this.getQueryOptions(), that.getQueryOptions());
    }

    public int hashCode() {
        return Objects.hash(this.getPartitionToken(), this.getPartitionOptions(), this.getTable(), this.getKeys(), this.getColumns(), this.getIndex(), this.getReadOptions(), this.getStatement(), this.getQueryOptions());
    }
}

