/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.abbvGapsHmm;

import com.wcohen.ss.abbvGapsHmm.AbbvGapsHMM;
import com.wcohen.ss.abbvGapsHmm.Acronym;
import com.wcohen.ss.abbvGapsHmm.Matrix3D;

public abstract class AbbvGapsHMMEvaluator {
    protected AbbvGapsHMM _gapsHMM = null;
    protected Matrix3D _evalMat;
    protected EvalParam _sParam;
    protected EvalParam _lParam;
    protected EvalParam _partialWordParam = null;
    protected Acronym _acronym;
    protected String _currWord;
    protected String _currPartialWord;

    public AbbvGapsHMMEvaluator(AbbvGapsHMM abbvGapsHMM) {
        this._gapsHMM = abbvGapsHMM;
    }

    protected abstract void updateLegalOutgoingEdges(int var1, int var2, AbbvGapsHMM.States var3, int var4, int var5, AbbvGapsHMM.States var6, AbbvGapsHMM.Transitions var7, AbbvGapsHMM.Emissions var8);

    protected abstract void initEvalMat();

    protected abstract void finalizeEvalMat();

    protected abstract String getCurrentWord(String var1, int var2);

    protected abstract String getCurrentChars(String var1, int var2, int var3);

    protected abstract EvalParam getPartialWordParam(String var1, int var2);

    protected abstract void initEvalParams();

    public Matrix3D getEvalMatrix() {
        return this._evalMat;
    }

    protected void evaluate(Acronym acronym) {
        this._acronym = acronym;
        this.initEvalParams();
        int V = AbbvGapsHMM.States.values().length;
        this._evalMat = new Matrix3D(this._sParam.getEvalMatrixSize(), this._lParam.getEvalMatrixSize(), V);
        Integer wordLen = -1;
        this.initEvalMat();
        this._sParam.initEvalRange();
        while (this._sParam.isInEvalRange()) {
            this._lParam.initEvalRange();
            while (this._lParam.isInEvalRange()) {
                wordLen = null;
                int lPos = this._lParam.getEvalStringPos();
                int sPos = this._sParam.getEvalStringPos();
                if (this._lParam.isInStringMatchingRange()) {
                    this._currWord = this.getCurrentWord(acronym._longForm, lPos);
                    if (this._currWord != null) {
                        wordLen = this._currWord.length();
                    }
                    this._partialWordParam = this.getPartialWordParam(acronym._longForm, lPos);
                    if (Character.isLetterOrDigit(acronym._longForm.charAt(lPos))) {
                        this.updateState(AbbvGapsHMM.States.DL, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_DL_alphaNumeric_to_none);
                        this.updateState(AbbvGapsHMM.States.D, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_D_alphaNumeric_to_none);
                    } else {
                        this.updateState(AbbvGapsHMM.States.DL, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_DL_nonAlphaNumeric_to_none);
                        this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_M_nonAlphaNumeric_to_none);
                    }
                    if (this._currWord != null) {
                        Double wordDF;
                        this.updateState(AbbvGapsHMM.States.DL, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_DL_word_to_none);
                        this.updateState(AbbvGapsHMM.States.D, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_D_word_to_none);
                        if (this._gapsHMM.useTDIDF() && (wordDF = this._gapsHMM.getDF(this._currWord)) != null) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.val(), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_commonWordDeletion);
                        }
                    }
                }
                if (this._sParam.isInStringMatchingRange() && !Character.isLetter(acronym._shortForm.charAt(sPos))) {
                    this.updateState(AbbvGapsHMM.States.D, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.val(), AbbvGapsHMM.Emissions.e_D_none_to_nonAlphaNumeric);
                }
                if (this._sParam.isInStringMatchingRange() && this._lParam.isInStringMatchingRange()) {
                    if (!Character.isLetter(acronym._shortForm.charAt(sPos)) && this.charEqualIgnoreCase(acronym._shortForm.charAt(sPos), acronym._longForm.charAt(lPos))) {
                        this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_M_letter_to_letter);
                    }
                    String sfChars_2 = this.getCurrentChars(acronym._shortForm, sPos, 2);
                    if (this._currWord != null) {
                        if (this._currWord.equalsIgnoreCase("and") && this.andToSymbolMatch(acronym._shortForm.charAt(sPos))) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_AND_to_symbol);
                        } else if (this._currWord.equalsIgnoreCase("one") && acronym._shortForm.charAt(sPos) == '1') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_one_to_1);
                        } else if (this._currWord.equalsIgnoreCase("two") && acronym._shortForm.charAt(sPos) == '2') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_two_to_2);
                        } else if (this._currWord.equalsIgnoreCase("three") && acronym._shortForm.charAt(sPos) == '3') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_three_to_3);
                        } else if (this._currWord.equalsIgnoreCase("four") && acronym._shortForm.charAt(sPos) == '4') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_four_to_4);
                        } else if (this._currWord.equalsIgnoreCase("five") && acronym._shortForm.charAt(sPos) == '5') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_five_to_5);
                        } else if (this._currWord.equalsIgnoreCase("six") && acronym._shortForm.charAt(sPos) == '6') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_six_to_6);
                        } else if (this._currWord.equalsIgnoreCase("seven") && acronym._shortForm.charAt(sPos) == '7') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_seven_to_7);
                        } else if (this._currWord.equalsIgnoreCase("eight") && acronym._shortForm.charAt(sPos) == '8') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_eight_to_8);
                        } else if (this._currWord.equalsIgnoreCase("nine") && acronym._shortForm.charAt(sPos) == '9') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_nine_to_9);
                        } else if (this._currWord.equalsIgnoreCase("Silver") && sfChars_2.equalsIgnoreCase("Ag")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Silver_Ag);
                        } else if (this._currWord.equalsIgnoreCase("Gold") && sfChars_2.equalsIgnoreCase("Au")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Gold_Au);
                        } else if (this._currWord.equalsIgnoreCase("Copper") && sfChars_2.equalsIgnoreCase("Cu")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Copper_Cu);
                        } else if (this._currWord.equalsIgnoreCase("Iron") && sfChars_2.equalsIgnoreCase("Fe")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Iron_Fe);
                        } else if (this._currWord.equalsIgnoreCase("Mercury") && sfChars_2.equalsIgnoreCase("Hg")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Mercury_Hg);
                        } else if (this._currWord.equalsIgnoreCase("Sodium") && sfChars_2.equalsIgnoreCase("Na")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Sodium_Na);
                        } else if (this._currWord.equalsIgnoreCase("Lead") && sfChars_2.equalsIgnoreCase("Pb")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Lead_Pb);
                        } else if (this._currWord.equalsIgnoreCase("Antimony") && sfChars_2.equalsIgnoreCase("Sb")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Antimony_Sb);
                        } else if (this._currWord.equalsIgnoreCase("Tin") && sfChars_2.equalsIgnoreCase("Sn")) {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(2), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Tin_Sn);
                        } else if (this._currWord.equalsIgnoreCase("Potassium") && acronym._shortForm.charAt(sPos) == 'K') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Potassium_K);
                        } else if (this._currWord.equalsIgnoreCase("Tungsten") && acronym._shortForm.charAt(sPos) == 'W') {
                            this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(wordLen), AbbvGapsHMM.Emissions.e_M_Tungsten_W);
                        }
                    }
                    if (this._partialWordParam != null) {
                        this._currPartialWord = this._partialWordParam._partialWord;
                        this._partialWordParam.initEvalRange();
                        while (this._partialWordParam.isInEvalRange()) {
                            if (this.charEqualIgnoreCase(acronym._shortForm.charAt(sPos), this._currPartialWord.charAt(this._partialWordParam.getCurrentPartialWordMatchPosition()))) {
                                if (this._partialWordParam.getCurrentPartialWordLen() == 1) {
                                    this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(1), AbbvGapsHMM.Emissions.e_M_letter_to_letter);
                                } else if (this._partialWordParam.isCurrentPartialWordMatchPositionAtWordStart()) {
                                    this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(this._partialWordParam.getCurrentPartialWordLen()), AbbvGapsHMM.Emissions.e_M_word_to_firstLetter);
                                } else {
                                    this.updateState(AbbvGapsHMM.States.M, this._sParam.val(), this._lParam.val(), this._sParam.offset(1), this._lParam.offset(this._partialWordParam.getCurrentPartialWordLen()), AbbvGapsHMM.Emissions.e_M_partialWord_to_letter);
                                }
                            }
                            this._partialWordParam.advanceEvalRange();
                        }
                    }
                }
                this._lParam.advanceEvalRange();
            }
            this._sParam.advanceEvalRange();
        }
        this.finalizeEvalMat();
    }

    protected static boolean posIsAtWordStart(String str, int pos) {
        assert (pos < str.length() && pos >= 0);
        return Character.isLetterOrDigit(str.charAt(pos)) && (pos == 0 || !Character.isLetterOrDigit(str.charAt(pos - 1)));
    }

    protected boolean charEqualIgnoreCase(char c1, char c2) {
        boolean charMatch = Character.toLowerCase(c1) == Character.toLowerCase(c2);
        return charMatch;
    }

    protected boolean andToSymbolMatch(char c) {
        return c == '&' || c == '/' || c == '-';
    }

    protected static boolean posIsAtWord(String str, int pos) {
        assert (pos < str.length() && pos >= 0);
        return Character.isLetterOrDigit(str.charAt(pos));
    }

    protected void updateState(AbbvGapsHMM.States s, int currS, int currL, int prevS, int prevL, AbbvGapsHMM.Emissions emission) {
        switch (s) {
            case M: {
                this.updateOutgoingEdgesStateM(currS, currL, prevS, prevL, emission);
                break;
            }
            case D: {
                this.updateOutgoingEdgesStateD(currS, currL, prevS, prevL, emission);
                break;
            }
            case DL: {
                this.updateOutgoingEdgesStateDL(currS, currL, prevS, prevL, emission);
                break;
            }
            case END: {
                this.updateOutgoingEdgesStateEND(currS, currL, prevS, prevL, emission);
                break;
            }
        }
    }

    protected void updateOutgoingEdgesStateM(int currS, int currL, int prevS, int prevL, AbbvGapsHMM.Emissions emission) {
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.M, prevS, prevL, AbbvGapsHMM.States.DL, AbbvGapsHMM.Transitions.t_DL_to_M, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.M, prevS, prevL, AbbvGapsHMM.States.M, AbbvGapsHMM.Transitions.t_M_in, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.M, prevS, prevL, AbbvGapsHMM.States.D, AbbvGapsHMM.Transitions.t_D_to_M, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.M, prevS, prevL, AbbvGapsHMM.States.S, AbbvGapsHMM.Transitions.t_S_to_M, emission);
    }

    protected void updateOutgoingEdgesStateD(int currS, int currL, int prevS, int prevL, AbbvGapsHMM.Emissions emission) {
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.D, prevS, prevL, AbbvGapsHMM.States.D, AbbvGapsHMM.Transitions.t_D_in, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.D, prevS, prevL, AbbvGapsHMM.States.M, AbbvGapsHMM.Transitions.t_M_to_D, emission);
    }

    protected void updateOutgoingEdgesStateDL(int currS, int currL, int prevS, int prevL, AbbvGapsHMM.Emissions emission) {
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.DL, prevS, prevL, AbbvGapsHMM.States.DL, AbbvGapsHMM.Transitions.t_DL_in, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.DL, prevS, prevL, AbbvGapsHMM.States.S, AbbvGapsHMM.Transitions.t_S_to_DL, emission);
    }

    protected void updateOutgoingEdgesStateEND(int currS, int currL, int prevS, int prevL, AbbvGapsHMM.Emissions emission) {
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.END, prevS, prevL, AbbvGapsHMM.States.D, AbbvGapsHMM.Transitions.t_D_to_END, emission);
        this.updateOutgoingEdges(currS, currL, AbbvGapsHMM.States.END, prevS, prevL, AbbvGapsHMM.States.M, AbbvGapsHMM.Transitions.t_M_to_END, emission);
    }

    protected void updateOutgoingEdges(int currS, int currL, AbbvGapsHMM.States currState, int prevS, int prevL, AbbvGapsHMM.States prevState, AbbvGapsHMM.Transitions transition, AbbvGapsHMM.Emissions emission) {
        if (!this.transitionIsLegal(currS, currL, currState, prevS, prevL, prevState, transition, emission)) {
            return;
        }
        this.updateLegalOutgoingEdges(currS, currL, currState, prevS, prevL, prevState, transition, emission);
    }

    protected boolean transitionIsLegal(int currS, int currL, AbbvGapsHMM.States currState, int prevS, int prevL, AbbvGapsHMM.States prevState, AbbvGapsHMM.Transitions transition, AbbvGapsHMM.Emissions emission) {
        return true;
    }

    protected abstract class EvalParam {
        public int _eval_start;
        public int _eval_end;
        public int _eval_mat_size;
        public int _length;
        public int _current = -1;
        public int _currentStringPos = -1;
        public boolean _partialWordIsAtStart = false;
        public String _partialWord = null;

        public EvalParam(String str) {
            this._length = str.length();
            this._eval_mat_size = this._length + 2;
        }

        public int val() {
            return this._current;
        }

        public abstract void initEvalRange();

        public abstract void advanceEvalRange();

        public abstract boolean isInEvalRange();

        public boolean isAtRangeStart() {
            return this._current == this._eval_start;
        }

        public boolean isAtRangeEnd() {
            return this._current == this._eval_start;
        }

        public abstract boolean isInStringMatchingRange();

        public int getEvalStringPos() {
            return this._currentStringPos;
        }

        public abstract int offset(int var1);

        public int getEvalMatrixSize() {
            return this._eval_mat_size;
        }

        public int getRangeStart() {
            return this._eval_start;
        }

        public int getRangeEnd() {
            return this._eval_end;
        }

        public abstract void setPartialWord(String var1, boolean var2);

        public abstract int getCurrentPartialWordLen();

        public abstract int getCurrentPartialWordMatchPosition();

        public abstract boolean isCurrentPartialWordMatchPositionAtWordStart();
    }
}

