/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.net.DomainNameResolver;

public class DNSDomainNameResolver
implements DomainNameResolver {
    @Override
    public InetAddress[] getAllByDomainName(String domainName) throws UnknownHostException {
        return InetAddress.getAllByName(domainName);
    }

    @Override
    public String getHostnameByIP(InetAddress address) {
        String host = address.getCanonicalHostName();
        if (host != null && host.length() != 0 && host.charAt(host.length() - 1) == '.') {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    @Override
    public String[] getAllResolvedHostnameByDomainName(String domainName, boolean useFQDN) throws UnknownHostException {
        InetAddress[] addresses = this.getAllByDomainName(domainName);
        String[] hosts = new String[addresses.length];
        if (useFQDN) {
            for (int i = 0; i < addresses.length; ++i) {
                hosts[i] = this.getHostnameByIP(addresses[i]);
            }
        } else {
            for (int i = 0; i < addresses.length; ++i) {
                hosts[i] = addresses[i].getHostAddress();
            }
        }
        return hosts;
    }
}

