/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.systemdata;

import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.systemdata.SystemData;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataData;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataMetaInjectionTypeConverter;
import org.apache.hop.pipeline.transforms.systemdata.SystemDataTypes;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SystemDataMeta.Injection.")
@Transform(id="SystemInfo", image="systeminfo.svg", name="i18n::BaseTransform.TypeLongDesc.SystemInfo", description="i18n::BaseTransform.TypeTooltipDesc.SystemInfo", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::SystemDataMeta.keyword"}, documentationUrl="/pipeline/transforms/getsystemdata.html")
public class SystemDataMeta
extends BaseTransformMeta<SystemData, SystemDataData> {
    private static final Class<?> PKG = SystemDataMeta.class;
    @Injection(name="FIELD_NAME")
    private String[] fieldName;
    @Injection(name="FIELD_TYPE", converter=SystemDataMetaInjectionTypeConverter.class)
    private SystemDataTypes[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public SystemDataTypes[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SystemDataTypes[] fieldType) {
        this.fieldType = fieldType;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new SystemDataTypes[count];
    }

    public Object clone() {
        SystemDataMeta retval = (SystemDataMeta)((Object)super.clone());
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, count);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String type = XmlHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = SystemDataTypes.getTypeFromString(type);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform information from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = SystemDataTypes.TYPE_SYSTEM_INFO_SYSTEM_DATE;
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMetaDate v;
            switch (this.fieldType[i]) {
                case TYPE_SYSTEM_INFO_SYSTEM_START: 
                case TYPE_SYSTEM_INFO_SYSTEM_DATE: 
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_FROM: 
                case TYPE_SYSTEM_INFO_PIPELINE_DATE_TO: 
                case TYPE_SYSTEM_INFO_WORKFLOW_DATE_FROM: 
                case TYPE_SYSTEM_INFO_WORKFLOW_DATE_TO: 
                case TYPE_SYSTEM_INFO_PREV_DAY_START: 
                case TYPE_SYSTEM_INFO_PREV_DAY_END: 
                case TYPE_SYSTEM_INFO_THIS_DAY_START: 
                case TYPE_SYSTEM_INFO_THIS_DAY_END: 
                case TYPE_SYSTEM_INFO_NEXT_DAY_START: 
                case TYPE_SYSTEM_INFO_NEXT_DAY_END: 
                case TYPE_SYSTEM_INFO_PREV_MONTH_START: 
                case TYPE_SYSTEM_INFO_PREV_MONTH_END: 
                case TYPE_SYSTEM_INFO_THIS_MONTH_START: 
                case TYPE_SYSTEM_INFO_THIS_MONTH_END: 
                case TYPE_SYSTEM_INFO_NEXT_MONTH_START: 
                case TYPE_SYSTEM_INFO_NEXT_MONTH_END: 
                case TYPE_SYSTEM_INFO_MODIFIED_DATE: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_START: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_END: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_PREV_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_START: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_END: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_THIS_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_OPEN_END: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_START_US: 
                case TYPE_SYSTEM_INFO_NEXT_WEEK_END_US: 
                case TYPE_SYSTEM_INFO_PREV_QUARTER_START: 
                case TYPE_SYSTEM_INFO_PREV_QUARTER_END: 
                case TYPE_SYSTEM_INFO_THIS_QUARTER_START: 
                case TYPE_SYSTEM_INFO_THIS_QUARTER_END: 
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_START: 
                case TYPE_SYSTEM_INFO_NEXT_QUARTER_END: 
                case TYPE_SYSTEM_INFO_PREV_YEAR_START: 
                case TYPE_SYSTEM_INFO_PREV_YEAR_END: 
                case TYPE_SYSTEM_INFO_THIS_YEAR_START: 
                case TYPE_SYSTEM_INFO_THIS_YEAR_END: 
                case TYPE_SYSTEM_INFO_NEXT_YEAR_START: 
                case TYPE_SYSTEM_INFO_NEXT_YEAR_END: {
                    v = new ValueMetaDate(this.fieldName[i]);
                    break;
                }
                case TYPE_SYSTEM_INFO_PIPELINE_NAME: 
                case TYPE_SYSTEM_INFO_FILENAME: 
                case TYPE_SYSTEM_INFO_MODIFIED_USER: 
                case TYPE_SYSTEM_INFO_HOSTNAME: 
                case TYPE_SYSTEM_INFO_HOSTNAME_REAL: 
                case TYPE_SYSTEM_INFO_IP_ADDRESS: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_LOG_TEXT: {
                    v = new ValueMetaString(this.fieldName[i]);
                    break;
                }
                case TYPE_SYSTEM_INFO_COPYNR: 
                case TYPE_SYSTEM_INFO_CURRENT_PID: 
                case TYPE_SYSTEM_INFO_JVM_TOTAL_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_FREE_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_MAX_MEMORY: 
                case TYPE_SYSTEM_INFO_JVM_AVAILABLE_MEMORY: 
                case TYPE_SYSTEM_INFO_AVAILABLE_PROCESSORS: 
                case TYPE_SYSTEM_INFO_JVM_CPU_TIME: 
                case TYPE_SYSTEM_INFO_TOTAL_PHYSICAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_TOTAL_SWAP_SPACE_SIZE: 
                case TYPE_SYSTEM_INFO_COMMITTED_VIRTUAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_FREE_PHYSICAL_MEMORY_SIZE: 
                case TYPE_SYSTEM_INFO_FREE_SWAP_SPACE_SIZE: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_EXIT_STATUS: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_ENTRY_NR: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_ERRORS: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_FILES_RETRIEVED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_DELETED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_INPUT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_OUTPUT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_READ: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_REJECTED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_UPDATED: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_NR_LINES_WRITTEN: {
                    v = new ValueMetaInteger(this.fieldName[i]);
                    v.setLength(10, 0);
                    break;
                }
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_RESULT: 
                case TYPE_SYSTEM_INFO_PREVIOUS_RESULT_IS_STOPPED: {
                    v = new ValueMetaBoolean(this.fieldName[i]);
                    break;
                }
                default: {
                    v = new ValueMetaNone(this.fieldName[i]);
                }
            }
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"type", (String)(this.fieldType[i] != null ? this.fieldType[i].getCode() : "")));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i].ordinal() > SystemDataTypes.TYPE_SYSTEM_INFO_NONE.ordinal()) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.FieldHasNoType", (String[])new String[]{this.fieldName[i]}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SystemDataMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SystemDataMeta)) {
            return false;
        }
        SystemDataMeta that = (SystemDataMeta)((Object)o);
        if (!Arrays.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        return Arrays.equals((Object[])this.fieldType, (Object[])that.fieldType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.fieldName);
        result = 31 * result + Arrays.hashCode((Object[])this.fieldType);
        return result;
    }
}

