/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.writetolog;

import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.w3c.dom.Node;

@Action(id="WRITE_TO_LOG", name="i18n::ActionWriteToLog.Name", description="i18n::ActionWriteToLog.Description", image="WriteToLog.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionWriteToLog.keyword"}, documentationUrl="/workflow/actions/writetolog.html")
public class ActionWriteToLog
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWriteToLog.class;
    private LogLevel actionLogLevel;
    private String logsubject = null;
    private String logmessage = null;

    public ActionWriteToLog(String n) {
        super(n, "");
    }

    public ActionWriteToLog() {
        this("");
    }

    public Object clone() {
        ActionWriteToLog je = (ActionWriteToLog)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"logmessage", (String)this.logmessage));
        retval.append("      ").append(XmlHandler.addTagValue((String)"loglevel", this.getActionLogLevel() == null ? null : this.getActionLogLevel().getCode()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"logsubject", (String)this.logsubject));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.logmessage = XmlHandler.getTagValue((Node)entrynode, (String)"logmessage");
            this.actionLogLevel = LogLevel.getLogLevelForCode((String)XmlHandler.getTagValue((Node)entrynode, (String)"loglevel"));
            this.logsubject = XmlHandler.getTagValue((Node)entrynode, (String)"logsubject");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WriteToLog.Error.UnableToLoadFromXML.Label", (String[])new String[0]), (Throwable)e);
        }
    }

    ILogChannel createLogChannel() {
        LogWriterObject logWriterObject = new LogWriterObject(this.getRealLogSubject(), (ILoggingObject)this, this.parentWorkflow.getLogLevel());
        return logWriterObject.getLogChannel();
    }

    public boolean evaluate(Result result) {
        ILogChannel logChannel = this.createLogChannel();
        String message = this.getRealLogMessage();
        if (Utils.isEmpty((CharSequence)message) || !this.getActionLogLevel().isVisible(logChannel.getLogLevel())) {
            return true;
        }
        try {
            switch (this.getActionLogLevel()) {
                case ERROR: {
                    logChannel.logError(message + Const.CR);
                    break;
                }
                case MINIMAL: {
                    logChannel.logMinimal(message + Const.CR);
                    break;
                }
                case BASIC: {
                    logChannel.logBasic(message + Const.CR);
                    break;
                }
                case DETAILED: {
                    logChannel.logDetailed(message + Const.CR);
                    break;
                }
                case DEBUG: {
                    logChannel.logDebug(message + Const.CR);
                    break;
                }
                case ROWLEVEL: {
                    logChannel.logRowlevel(message + Const.CR);
                    break;
                }
            }
            return true;
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.log.logError(BaseMessages.getString(PKG, (String)"WriteToLog.Error.Label", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"WriteToLog.Error.Description", (String[])new String[0]) + " : " + e.toString()});
            return false;
        }
    }

    public Result execute(Result prevResult, int nr) {
        prevResult.setResult(this.evaluate(prevResult));
        return prevResult;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getRealLogMessage() {
        return Const.NVL((String)this.resolve(this.getLogMessage()), (String)"");
    }

    public String getRealLogSubject() {
        return Const.NVL((String)this.resolve(this.getLogSubject()), (String)"");
    }

    public String getLogMessage() {
        if (this.logmessage == null) {
            this.logmessage = "";
        }
        return this.logmessage;
    }

    public String getLogSubject() {
        if (this.logsubject == null) {
            this.logsubject = "";
        }
        return this.logsubject;
    }

    public void setLogMessage(String s) {
        this.logmessage = s;
    }

    public void setLogSubject(String logsubjectin) {
        this.logsubject = logsubjectin;
    }

    public LogLevel getActionLogLevel() {
        return this.actionLogLevel;
    }

    public void setActionLogLevel(LogLevel in) {
        this.actionLogLevel = in;
    }

    private class LogWriterObject
    implements ILoggingObject {
        private ILogChannel writerLog;
        private LogLevel logLevel;
        private ILoggingObject parent;
        private String subject;
        private String containerObjectId;

        public LogWriterObject(String subject, ILoggingObject parent, LogLevel logLevel) {
            this.subject = subject;
            this.parent = parent;
            this.logLevel = logLevel;
            this.writerLog = new LogChannel((Object)this, parent);
            this.containerObjectId = this.writerLog.getContainerObjectId();
        }

        public String getFilename() {
            return null;
        }

        public String getLogChannelId() {
            return this.writerLog.getLogChannelId();
        }

        public String getObjectCopy() {
            return null;
        }

        public String getObjectName() {
            return this.subject;
        }

        public LoggingObjectType getObjectType() {
            return LoggingObjectType.TRANSFORM;
        }

        public ILoggingObject getParent() {
            return this.parent;
        }

        public ILogChannel getLogChannel() {
            return this.writerLog;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public String getContainerId() {
            return this.containerObjectId;
        }

        public Date getRegistrationDate() {
            return null;
        }

        public boolean isGatheringMetrics() {
            return ActionWriteToLog.this.log.isGatheringMetrics();
        }

        public void setGatheringMetrics(boolean gatheringMetrics) {
            ActionWriteToLog.this.log.setGatheringMetrics(gatheringMetrics);
        }

        public boolean isForcingSeparateLogging() {
            return ActionWriteToLog.this.log.isForcingSeparateLogging();
        }

        public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
            ActionWriteToLog.this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }
}

