/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ContextHolder;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.EmitterProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.NextProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ReplayProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SinkEmptyMulticast;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SinkEmptySerialized;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SinkManyBestEffort;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SinkManySerialized;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.SinkOneSerialized;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Sinks;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.UnicastManySinkNoBackpressure;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.UnicastProcessor;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Scheduler;

final class SinksSpecs {
    static final Sinks.RootSpec UNSAFE_ROOT_SPEC = new RootSpecImpl(false);
    static final Sinks.RootSpec DEFAULT_ROOT_SPEC = new RootSpecImpl(true);

    SinksSpecs() {
    }

    static final class UnicastSpecImpl
    implements Sinks.UnicastSpec {
        final boolean serialized;

        UnicastSpecImpl(boolean serialized) {
            this.serialized = serialized;
        }

        <T, MANY extends Sinks.Many<T> & ContextHolder> Sinks.Many<T> wrapMany(MANY original) {
            if (this.serialized) {
                return new SinkManySerialized(original, original);
            }
            return original;
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer() {
            UnicastProcessor original = UnicastProcessor.create();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer(Queue<T> queue) {
            UnicastProcessor<T> original = UnicastProcessor.create(queue);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer(Queue<T> queue, Disposable endCallback) {
            UnicastProcessor<T> original = UnicastProcessor.create(queue, endCallback);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureError() {
            UnicastManySinkNoBackpressure original = UnicastManySinkNoBackpressure.create();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }
    }

    static final class RootSpecImpl
    implements Sinks.RootSpec,
    Sinks.ManySpec,
    Sinks.MulticastSpec,
    Sinks.MulticastReplaySpec {
        final boolean serialized;
        final Sinks.UnicastSpec unicastSpec;

        RootSpecImpl(boolean serialized) {
            this.serialized = serialized;
            this.unicastSpec = new UnicastSpecImpl(serialized);
        }

        <T, EMPTY extends Sinks.Empty<T> & ContextHolder> Sinks.Empty<T> wrapEmpty(EMPTY original) {
            if (this.serialized) {
                return new SinkEmptySerialized(original, original);
            }
            return original;
        }

        <T, ONE extends Sinks.One<T> & ContextHolder> Sinks.One<T> wrapOne(ONE original) {
            if (this.serialized) {
                return new SinkOneSerialized(original, (ContextHolder)original);
            }
            return original;
        }

        <T, MANY extends Sinks.Many<T> & ContextHolder> Sinks.Many<T> wrapMany(MANY original) {
            if (this.serialized) {
                return new SinkManySerialized(original, original);
            }
            return original;
        }

        @Override
        public Sinks.ManySpec many() {
            return this;
        }

        @Override
        public <T> Sinks.Empty<T> empty() {
            return this.wrapEmpty((Sinks.Empty<T> & ContextHolder)new SinkEmptyMulticast());
        }

        @Override
        public <T> Sinks.One<T> one() {
            NextProcessor original = new NextProcessor(null);
            return this.wrapOne((Sinks.One<T> & ContextHolder)original);
        }

        @Override
        public Sinks.UnicastSpec unicast() {
            return this.unicastSpec;
        }

        @Override
        public Sinks.MulticastSpec multicast() {
            return this;
        }

        @Override
        public Sinks.MulticastReplaySpec replay() {
            return this;
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer() {
            EmitterProcessor original = EmitterProcessor.create();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer(int bufferSize) {
            EmitterProcessor original = EmitterProcessor.create(bufferSize);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> onBackpressureBuffer(int bufferSize, boolean autoCancel) {
            EmitterProcessor original = EmitterProcessor.create(bufferSize, autoCancel);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> directAllOrNothing() {
            SinkManyBestEffort original = SinkManyBestEffort.createAllOrNothing();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> directBestEffort() {
            SinkManyBestEffort original = SinkManyBestEffort.createBestEffort();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> all() {
            ReplayProcessor original = ReplayProcessor.create();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> all(int batchSize) {
            ReplayProcessor original = ReplayProcessor.create(batchSize, true);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> latest() {
            ReplayProcessor original = ReplayProcessor.cacheLast();
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> latestOrDefault(T value) {
            ReplayProcessor<T> original = ReplayProcessor.cacheLastOrDefault(value);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> limit(int historySize) {
            ReplayProcessor original = ReplayProcessor.create(historySize);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> limit(Duration maxAge) {
            ReplayProcessor original = ReplayProcessor.createTimeout(maxAge);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> limit(Duration maxAge, Scheduler scheduler) {
            ReplayProcessor original = ReplayProcessor.createTimeout(maxAge, scheduler);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> limit(int historySize, Duration maxAge) {
            ReplayProcessor original = ReplayProcessor.createSizeAndTimeout(historySize, maxAge);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }

        @Override
        public <T> Sinks.Many<T> limit(int historySize, Duration maxAge, Scheduler scheduler) {
            ReplayProcessor original = ReplayProcessor.createSizeAndTimeout(historySize, maxAge, scheduler);
            return this.wrapMany((Sinks.Many<T> & ContextHolder)original);
        }
    }

    static abstract class AbstractSerializedSink {
        volatile int wip;
        static final AtomicIntegerFieldUpdater<AbstractSerializedSink> WIP = AtomicIntegerFieldUpdater.newUpdater(AbstractSerializedSink.class, "wip");
        volatile Thread lockedAt;
        static final AtomicReferenceFieldUpdater<AbstractSerializedSink, Thread> LOCKED_AT = AtomicReferenceFieldUpdater.newUpdater(AbstractSerializedSink.class, Thread.class, "lockedAt");

        AbstractSerializedSink() {
        }

        boolean tryAcquire(Thread currentThread) {
            if (WIP.get(this) == 0 && WIP.compareAndSet(this, 0, 1)) {
                LOCKED_AT.lazySet(this, currentThread);
            } else {
                if (LOCKED_AT.get(this) != currentThread) {
                    return false;
                }
                WIP.incrementAndGet(this);
            }
            return true;
        }
    }
}

