/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Comparator;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Value;

public class GeneralComparison10
extends BinaryExpression {
    protected int singletonOperator;
    protected AtomicComparer comparer;
    private boolean atomize0 = true;
    private boolean atomize1 = true;
    private boolean maybeBoolean0 = true;
    private boolean maybeBoolean1 = true;

    public GeneralComparison10(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
        this.singletonOperator = GeneralComparison10.getSingletonOperator(n);
    }

    public int computeCardinality() {
        return 16384;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        Comparator comparator = staticContext.getCollation(staticContext.getDefaultCollationName());
        if (comparator == null) {
            comparator = CodepointCollator.getInstance();
        }
        this.comparer = new AtomicComparer(comparator, staticContext.getConfiguration());
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.optimize(optimizer, staticContext, itemType);
        this.operand1 = this.operand1.optimize(optimizer, staticContext, itemType);
        this.operand0 = ExpressionTool.unsorted(optimizer, this.operand0, false);
        this.operand1 = ExpressionTool.unsorted(optimizer, this.operand1, false);
        if (this.operand0 instanceof Value && this.operand1 instanceof Value) {
            return (AtomicValue)this.evaluateItem(staticContext.makeEarlyEvaluationContext());
        }
        TypeHierarchy typeHierarchy = staticContext.getNamePool().getTypeHierarchy();
        ItemType itemType2 = this.operand0.getItemType(typeHierarchy);
        ItemType itemType3 = this.operand1.getItemType(typeHierarchy);
        if (itemType2 instanceof AtomicType) {
            this.atomize0 = false;
        }
        if (itemType3 instanceof AtomicType) {
            this.atomize1 = false;
        }
        if (typeHierarchy.relationship(itemType2, Type.BOOLEAN_TYPE) == 4) {
            this.maybeBoolean0 = false;
        }
        if (typeHierarchy.relationship(itemType3, Type.BOOLEAN_TYPE) == 4) {
            this.maybeBoolean1 = false;
        }
        if (!this.maybeBoolean0 && !this.maybeBoolean1) {
            boolean bl;
            int n = typeHierarchy.relationship(itemType2, Type.NUMBER_TYPE);
            int n2 = typeHierarchy.relationship(itemType3, Type.NUMBER_TYPE);
            boolean bl2 = n != 4;
            boolean bl3 = n2 != 4;
            boolean bl4 = n == 2 || n == 0;
            boolean bl5 = bl = n2 == 2 || n2 == 0;
            if (!bl2 && !bl3) {
                return new GeneralComparison(this.operand0, this.operator, this.operand1).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            }
            if (bl4 && bl) {
                return new GeneralComparison(this.operand0, this.operator, this.operand1).typeCheck(staticContext, itemType).optimize(optimizer, staticContext, itemType);
            }
        }
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        Item item;
        Object object;
        Object object2;
        SequenceIterator sequenceIterator = null;
        if (this.maybeBoolean0) {
            sequenceIterator = this.operand0.iterate(xPathContext);
            object2 = sequenceIterator.next();
            Object object3 = object = object2 == null ? null : sequenceIterator.next();
            if (object2 instanceof BooleanValue && object == null) {
                boolean bl = this.operand1.effectiveBooleanValue(xPathContext);
                return GeneralComparison10.compare((BooleanValue)object2, this.singletonOperator, BooleanValue.get(bl), this.comparer, xPathContext);
            }
            if (object2 == null && !this.maybeBoolean1) {
                return false;
            }
        }
        object2 = null;
        if (this.maybeBoolean1) {
            object2 = this.operand1.iterate(xPathContext);
            object = object2.next();
            Item item2 = item = object == null ? null : object2.next();
            if (object instanceof BooleanValue && item == null) {
                boolean bl = this.operand0.effectiveBooleanValue(xPathContext);
                return GeneralComparison10.compare(BooleanValue.get(bl), this.singletonOperator, (BooleanValue)object, this.comparer, xPathContext);
            }
            if (object == null && !this.maybeBoolean0) {
                return false;
            }
        }
        sequenceIterator = sequenceIterator == null ? this.operand0.iterate(xPathContext) : sequenceIterator.getAnother();
        object2 = object2 == null ? this.operand1.iterate(xPathContext) : object2.getAnother();
        if (this.atomize0) {
            sequenceIterator = Atomizer.AtomizingFunction.getAtomizingIterator(sequenceIterator);
        }
        if (this.atomize1) {
            object2 = Atomizer.AtomizingFunction.getAtomizingIterator((SequenceIterator)object2);
        }
        if (this.operator == 12 || this.operator == 14 || this.operator == 11 || this.operator == 13) {
            sequenceIterator = new MappingIterator(sequenceIterator, new NumberFn(), null);
            object2 = new MappingIterator((SequenceIterator)object2, new NumberFn(), null);
        }
        object = null;
        block2: while ((item = (AtomicValue)sequenceIterator.next()) != null) {
            Object object4;
            if (object2 == null) {
                AtomicValue atomicValue;
                object4 = object.iterator();
                do {
                    if (!object4.hasNext()) continue block2;
                } while (!GeneralComparison10.compare((AtomicValue)item, this.singletonOperator, atomicValue = (AtomicValue)object4.next(), this.comparer, xPathContext));
                return true;
            }
            while (true) {
                if ((object4 = (AtomicValue)object2.next()) == null) {
                    object2 = null;
                    if (object == null) return false;
                    continue block2;
                }
                try {
                    if (GeneralComparison10.compare((AtomicValue)item, this.singletonOperator, (AtomicValue)object4, this.comparer, xPathContext)) {
                        return true;
                    }
                    if (object == null) {
                        object = new ArrayList(40);
                    }
                    object.add(object4);
                }
                catch (DynamicError dynamicError) {
                    if (dynamicError.getXPathContext() == null) {
                        dynamicError.setXPathContext(xPathContext);
                    }
                    if (dynamicError.getLocator() != null) throw dynamicError;
                    dynamicError.setLocator(this);
                    throw dynamicError;
                }
            }
            break;
        }
        return false;
    }

    protected static boolean compare(AtomicValue atomicValue, int n, AtomicValue atomicValue2, AtomicComparer atomicComparer, XPathContext xPathContext) throws XPathException {
        TypeHierarchy typeHierarchy = xPathContext.getNamePool().getTypeHierarchy();
        AtomicType atomicType = (AtomicType)atomicValue.getItemType(typeHierarchy).getPrimitiveItemType();
        AtomicType atomicType2 = (AtomicType)atomicValue2.getItemType(typeHierarchy).getPrimitiveItemType();
        if (Type.isNumericPrimitiveType(atomicType) || Type.isNumericPrimitiveType(atomicType2)) {
            DoubleValue doubleValue = NumberFn.convert(atomicValue);
            DoubleValue doubleValue2 = NumberFn.convert(atomicValue2);
            return ValueComparison.compare(doubleValue, n, doubleValue2, atomicComparer);
        }
        if (atomicType == Type.STRING_TYPE || atomicType2 == Type.STRING_TYPE || atomicType == Type.UNTYPED_ATOMIC_TYPE && atomicType2 == Type.UNTYPED_ATOMIC_TYPE) {
            StringValue stringValue = (StringValue)atomicValue.convert(513, xPathContext);
            StringValue stringValue2 = (StringValue)atomicValue2.convert(513, xPathContext);
            return ValueComparison.compare(stringValue, n, stringValue2, atomicComparer);
        }
        if (atomicType == Type.UNTYPED_ATOMIC_TYPE && (atomicValue = atomicValue.convert(atomicType2, xPathContext, true)) instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue).getException();
        }
        if (atomicType2 == Type.UNTYPED_ATOMIC_TYPE && (atomicValue2 = atomicValue2.convert(atomicType, xPathContext, true)) instanceof ValidationErrorValue) {
            throw ((ValidationErrorValue)atomicValue2).getException();
        }
        return ValueComparison.compare(atomicValue, n, atomicValue2, atomicComparer);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return Type.BOOLEAN_TYPE;
    }

    private static int getSingletonOperator(int n) {
        switch (n) {
            case 6: {
                return 44;
            }
            case 13: {
                return 48;
            }
            case 22: {
                return 45;
            }
            case 12: {
                return 47;
            }
            case 11: {
                return 46;
            }
            case 14: {
                return 49;
            }
        }
        return n;
    }

    protected String displayOperator() {
        return "many-to-many (1.0) " + super.displayOperator();
    }
}

