/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.io.SeekableInputStream;

public class ParquetInputStream
extends SeekableInputStream {
    private final byte[] bytes;
    private final ByteArrayInputStream inputStream;
    private long position;

    public ParquetInputStream(InputStream inputStream) throws IOException {
        try {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] chunk = new byte[65536];
            while ((bytesRead = inputStream.read(chunk, 0, chunk.length)) != -1) {
                buffer.write(chunk, 0, bytesRead);
            }
            this.bytes = buffer.toByteArray();
            this.inputStream = new ByteArrayInputStream(this.bytes);
        }
        catch (IOException e) {
            throw new IOException("Unable to read input stream data into memory", e);
        }
        this.position = 0L;
    }

    public int read(byte[] buffer) throws IOException {
        int bytesRead = this.inputStream.read(buffer);
        this.position += (long)bytesRead;
        return bytesRead;
    }

    public int read(byte[] bytes, int i, int i1) throws IOException {
        int bytesRead = super.read(bytes, i, i1);
        this.position += (long)bytesRead;
        return bytesRead;
    }

    public long skip(long l) throws IOException {
        long skipped = super.skip(l);
        this.position += skipped;
        return skipped;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public synchronized void mark(int pos) {
        this.inputStream.mark(pos);
        this.position = pos;
    }

    public synchronized void reset() throws IOException {
        this.inputStream.reset();
        this.position = 0L;
    }

    public boolean markSupported() {
        return false;
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        this.inputStream.reset();
        this.inputStream.skip(pos);
        this.position = pos;
    }

    public void readFully(byte[] buffer) throws IOException {
        int read = this.inputStream.read(buffer);
        this.position += (long)read;
    }

    public void readFully(byte[] buffer, int i, int i1) throws IOException {
        int read = this.inputStream.read(buffer, i, i1);
        this.position += (long)read;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int read = this.inputStream.read(byteBuffer.array());
        this.position += (long)read;
        return read;
    }

    public void readFully(ByteBuffer byteBuffer) throws IOException {
        int read = this.inputStream.read(byteBuffer.array());
        this.position += (long)read;
    }

    public int read() throws IOException {
        int c = this.inputStream.read();
        ++this.position;
        return c;
    }
}

