/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseDeferredValue;
import com.clickhouse.client.ClickHouseFile;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseUtils;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ClickHouseExternalTable
implements Serializable {
    private static final long serialVersionUID = -5395148151046691946L;
    private final String name;
    private final ClickHouseFile file;
    private final ClickHouseDeferredValue<InputStream> content;
    private final Optional<ClickHouseCompression> compression;
    private final ClickHouseFormat format;
    private final List<ClickHouseColumn> columns;
    private final boolean asTempTable;
    private final String structure;

    public static Builder builder() {
        return new Builder();
    }

    protected ClickHouseExternalTable(String name, ClickHouseFile file, ClickHouseDeferredValue<InputStream> content, ClickHouseCompression compression, ClickHouseFormat format, Collection<ClickHouseColumn> columns, boolean asTempTable) {
        int size;
        this.name = name == null ? "" : name.trim();
        this.file = file != null ? file : ClickHouseFile.NULL;
        this.content = ClickHouseChecker.nonNull(content, "content");
        this.compression = compression == null ? Optional.ofNullable((compression = ClickHouseCompression.fromFileName(this.name)) == ClickHouseCompression.NONE ? null : compression) : Optional.of(compression);
        this.format = format == null ? ClickHouseFormat.TabSeparated : format;
        int n = size = columns == null ? 0 : columns.size();
        if (size == 0) {
            this.columns = Collections.emptyList();
            this.structure = "";
        } else {
            StringBuilder builder = new StringBuilder();
            ArrayList<ClickHouseColumn> list = new ArrayList<ClickHouseColumn>(size);
            for (ClickHouseColumn c : columns) {
                list.add(c);
                builder.append(c.getColumnName()).append(' ').append(c.getOriginalTypeName()).append(',');
            }
            this.columns = Collections.unmodifiableList(list);
            this.structure = builder.deleteCharAt(builder.length() - 1).toString();
        }
        this.asTempTable = asTempTable;
    }

    public boolean hasName() {
        return !this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public ClickHouseFile getFile() {
        return this.file;
    }

    public InputStream getContent() {
        return this.content.get();
    }

    public Optional<ClickHouseCompression> getCompression() {
        return this.compression;
    }

    public ClickHouseFormat getFormat() {
        return this.format;
    }

    public List<ClickHouseColumn> getColumns() {
        return this.columns;
    }

    public boolean isTempTable() {
        return this.asTempTable;
    }

    public String getStructure() {
        return this.structure;
    }

    public static class Builder {
        private String name;
        private ClickHouseFile file;
        private ClickHouseDeferredValue<InputStream> content;
        private ClickHouseCompression compression;
        private ClickHouseFormat format;
        private List<ClickHouseColumn> columns = new LinkedList<ClickHouseColumn>();
        private boolean asTempTable;

        protected Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder compression(ClickHouseCompression compression) {
            this.compression = compression;
            return this;
        }

        public Builder content(ClickHouseFile file) {
            this.file = ClickHouseChecker.nonNull(file, "file");
            this.compression = file.getCompressionAlgorithm();
            this.content = ClickHouseDeferredValue.of(file.asInputStream(), InputStream.class);
            if (file.hasFormat()) {
                this.format = file.getFormat();
            }
            return this;
        }

        public Builder content(InputStream content) {
            this.content = ClickHouseDeferredValue.of(ClickHouseChecker.nonNull(content, "content"), InputStream.class);
            return this;
        }

        @Deprecated
        public Builder content(CompletableFuture<InputStream> content) {
            this.content = ClickHouseDeferredValue.of(ClickHouseChecker.nonNull(content, "Content"));
            return this;
        }

        public Builder content(ClickHouseDeferredValue<InputStream> content) {
            this.content = ClickHouseChecker.nonNull(content, "Content");
            return this;
        }

        public Builder content(String file) {
            String fileName = ClickHouseChecker.nonEmpty(file, "File");
            this.content = ClickHouseDeferredValue.of(() -> {
                try {
                    return ClickHouseUtils.getFileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            });
            return this;
        }

        public Builder format(String format) {
            if (!ClickHouseChecker.isNullOrBlank(format)) {
                this.format = ClickHouseFormat.valueOf(format);
            }
            return this;
        }

        public Builder format(ClickHouseFormat format) {
            this.format = format;
            return this;
        }

        public Builder addColumn(String name, String type) {
            this.columns.add(ClickHouseColumn.of(name, type));
            return this;
        }

        public Builder removeColumn(String name) {
            Iterator<ClickHouseColumn> iterator = this.columns.iterator();
            while (iterator.hasNext()) {
                ClickHouseColumn c = iterator.next();
                if (!c.getColumnName().equals(name)) continue;
                iterator.remove();
            }
            return this;
        }

        public Builder removeColumn(ClickHouseColumn column) {
            this.columns.remove(column);
            return this;
        }

        public Builder columns(String columns) {
            return !ClickHouseChecker.isNullOrBlank(columns) ? this.columns(ClickHouseColumn.parse(columns)) : this;
        }

        public Builder columns(Collection<ClickHouseColumn> columns) {
            if (columns != null) {
                for (ClickHouseColumn c : columns) {
                    this.columns.add(c);
                }
            }
            return this;
        }

        public Builder asTempTable() {
            this.asTempTable = true;
            return this;
        }

        public Builder asExternalTable() {
            this.asTempTable = false;
            return this;
        }

        public ClickHouseExternalTable build() {
            return new ClickHouseExternalTable(this.name, this.file, this.content, this.compression, this.format, this.columns, this.asTempTable);
        }
    }
}

