/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.okhttp;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.grpc.internal.SerializingExecutor;
import com.clickhouse.client.internal.grpc.okhttp.ExceptionHandlingFrameWriter;
import com.clickhouse.client.internal.okio.Buffer;
import com.clickhouse.client.internal.okio.Sink;
import com.clickhouse.client.internal.okio.Timeout;
import com.clickhouse.client.internal.perfmark.Link;
import com.clickhouse.client.internal.perfmark.PerfMark;
import java.io.IOException;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class AsyncSink
implements Sink {
    private final Object lock = new Object();
    private final Buffer buffer = new Buffer();
    private final SerializingExecutor serializingExecutor;
    private final ExceptionHandlingFrameWriter.TransportExceptionHandler transportExceptionHandler;
    @GuardedBy(value="lock")
    private boolean writeEnqueued = false;
    @GuardedBy(value="lock")
    private boolean flushEnqueued = false;
    private boolean closed = false;
    @Nullable
    private Sink sink;
    @Nullable
    private Socket socket;

    private AsyncSink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler) {
        this.serializingExecutor = Preconditions.checkNotNull(executor, "executor");
        this.transportExceptionHandler = Preconditions.checkNotNull(exceptionHandler, "exceptionHandler");
    }

    static AsyncSink sink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler) {
        return new AsyncSink(executor, exceptionHandler);
    }

    void becomeConnected(Sink sink, Socket socket) {
        Preconditions.checkState(this.sink == null, "AsyncSink's becomeConnected should only be called once.");
        this.sink = Preconditions.checkNotNull(sink, "sink");
        this.socket = Preconditions.checkNotNull(socket, "socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        Preconditions.checkNotNull(source, "source");
        if (this.closed) {
            throw new IOException("closed");
        }
        PerfMark.startTask("AsyncSink.write");
        try {
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    this.buffer.write(source, byteCount);
                    if (!this.writeEnqueued && !this.flushEnqueued && this.buffer.completeSegmentByteCount() > 0L) break block9;
                    return;
                }
                this.writeEnqueued = true;
            }
            this.serializingExecutor.execute(new WriteRunnable(){
                final Link link = PerfMark.linkOut();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doRun() throws IOException {
                    PerfMark.startTask("WriteRunnable.runWrite");
                    PerfMark.linkIn(this.link);
                    Buffer buf = new Buffer();
                    try {
                        Object object = AsyncSink.this.lock;
                        synchronized (object) {
                            buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.completeSegmentByteCount());
                            AsyncSink.this.writeEnqueued = false;
                        }
                        AsyncSink.this.sink.write(buf, buf.size());
                    }
                    finally {
                        PerfMark.stopTask("WriteRunnable.runWrite");
                    }
                }
            });
        }
        finally {
            PerfMark.stopTask("AsyncSink.write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        PerfMark.startTask("AsyncSink.flush");
        try {
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    if (!this.flushEnqueued) break block9;
                    return;
                }
                this.flushEnqueued = true;
            }
            this.serializingExecutor.execute(new WriteRunnable(){
                final Link link = PerfMark.linkOut();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doRun() throws IOException {
                    PerfMark.startTask("WriteRunnable.runFlush");
                    PerfMark.linkIn(this.link);
                    Buffer buf = new Buffer();
                    try {
                        Object object = AsyncSink.this.lock;
                        synchronized (object) {
                            buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.size());
                            AsyncSink.this.flushEnqueued = false;
                        }
                        AsyncSink.this.sink.write(buf, buf.size());
                        AsyncSink.this.sink.flush();
                    }
                    finally {
                        PerfMark.stopTask("WriteRunnable.runFlush");
                    }
                }
            });
        }
        finally {
            PerfMark.stopTask("AsyncSink.flush");
        }
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.serializingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncSink.this.buffer.close();
                try {
                    if (AsyncSink.this.sink != null) {
                        AsyncSink.this.sink.close();
                    }
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
                try {
                    if (AsyncSink.this.socket != null) {
                        AsyncSink.this.socket.close();
                    }
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
            }
        });
    }

    private abstract class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public final void run() {
            try {
                if (AsyncSink.this.sink == null) {
                    throw new IOException("Unable to perform write due to unavailable sink.");
                }
                this.doRun();
            }
            catch (Exception e) {
                AsyncSink.this.transportExceptionHandler.onException(e);
            }
        }

        public abstract void doRun() throws IOException;
    }
}

