/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.stream.CapacityPolicy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class AdaptiveQueue<E> {
    private final CapacityPolicy policy;
    private final LinkedList<E> queue;

    public AdaptiveQueue(CapacityPolicy policy, E ... array) {
        this.policy = policy;
        this.queue = array == null || array.length == 0 ? new LinkedList<E>() : new LinkedList<E>(Arrays.asList(array));
    }

    public AdaptiveQueue(CapacityPolicy policy, List<E> list) {
        this.policy = policy;
        this.queue = new LinkedList<E>(list);
    }

    public synchronized void add(E e) {
        this.queue.add(e);
        if (this.policy != null) {
            this.policy.ensureCapacity(0);
        }
    }

    public synchronized void clear() {
        this.queue.clear();
        if (this.policy != null) {
            this.policy.ensureCapacity(0);
        }
    }

    public synchronized boolean offer(E e) {
        if (this.policy == null || this.policy.ensureCapacity(this.queue.size())) {
            this.queue.addLast(e);
            return true;
        }
        return false;
    }

    public synchronized E poll() {
        if (!this.queue.isEmpty()) {
            return this.queue.removeFirst();
        }
        return null;
    }

    public synchronized int size() {
        return this.queue.size();
    }
}

