/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_CreateFileOptions
extends CreateFileOptions {
    private final ImmutableMap<String, byte[]> attributes;
    private final String contentType;
    private final boolean ensureNoDirectoryConflict;
    private final boolean overwriteExisting;
    private final long overwriteGenerationId;

    private AutoValue_CreateFileOptions(ImmutableMap<String, byte[]> attributes, @Nullable String contentType, boolean ensureNoDirectoryConflict, boolean overwriteExisting, long overwriteGenerationId) {
        this.attributes = attributes;
        this.contentType = contentType;
        this.ensureNoDirectoryConflict = ensureNoDirectoryConflict;
        this.overwriteExisting = overwriteExisting;
        this.overwriteGenerationId = overwriteGenerationId;
    }

    @Override
    public ImmutableMap<String, byte[]> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isEnsureNoDirectoryConflict() {
        return this.ensureNoDirectoryConflict;
    }

    @Override
    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    @Override
    public long getOverwriteGenerationId() {
        return this.overwriteGenerationId;
    }

    public String toString() {
        return "CreateFileOptions{attributes=" + this.attributes + ", contentType=" + this.contentType + ", ensureNoDirectoryConflict=" + this.ensureNoDirectoryConflict + ", overwriteExisting=" + this.overwriteExisting + ", overwriteGenerationId=" + this.overwriteGenerationId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CreateFileOptions) {
            CreateFileOptions that = (CreateFileOptions)o;
            return this.attributes.equals(that.getAttributes()) && (this.contentType == null ? that.getContentType() == null : this.contentType.equals(that.getContentType())) && this.ensureNoDirectoryConflict == that.isEnsureNoDirectoryConflict() && this.overwriteExisting == that.isOverwriteExisting() && this.overwriteGenerationId == that.getOverwriteGenerationId();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.contentType == null ? 0 : this.contentType.hashCode();
        h$ *= 1000003;
        h$ ^= this.ensureNoDirectoryConflict ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.overwriteExisting ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= (int)(this.overwriteGenerationId >>> 32 ^ this.overwriteGenerationId);
    }

    @Override
    public CreateFileOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends CreateFileOptions.Builder {
        private ImmutableMap<String, byte[]> attributes;
        private String contentType;
        private Boolean ensureNoDirectoryConflict;
        private Boolean overwriteExisting;
        private Long overwriteGenerationId;

        Builder() {
        }

        private Builder(CreateFileOptions source) {
            this.attributes = source.getAttributes();
            this.contentType = source.getContentType();
            this.ensureNoDirectoryConflict = source.isEnsureNoDirectoryConflict();
            this.overwriteExisting = source.isOverwriteExisting();
            this.overwriteGenerationId = source.getOverwriteGenerationId();
        }

        @Override
        public CreateFileOptions.Builder setAttributes(Map<String, byte[]> attributes) {
            this.attributes = ImmutableMap.copyOf(attributes);
            return this;
        }

        @Override
        public CreateFileOptions.Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setEnsureNoDirectoryConflict(boolean ensureNoDirectoryConflict) {
            this.ensureNoDirectoryConflict = ensureNoDirectoryConflict;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setOverwriteExisting(boolean overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        @Override
        public CreateFileOptions.Builder setOverwriteGenerationId(long overwriteGenerationId) {
            this.overwriteGenerationId = overwriteGenerationId;
            return this;
        }

        @Override
        CreateFileOptions autoBuild() {
            if (this.attributes == null || this.ensureNoDirectoryConflict == null || this.overwriteExisting == null || this.overwriteGenerationId == null) {
                StringBuilder missing = new StringBuilder();
                if (this.attributes == null) {
                    missing.append(" attributes");
                }
                if (this.ensureNoDirectoryConflict == null) {
                    missing.append(" ensureNoDirectoryConflict");
                }
                if (this.overwriteExisting == null) {
                    missing.append(" overwriteExisting");
                }
                if (this.overwriteGenerationId == null) {
                    missing.append(" overwriteGenerationId");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_CreateFileOptions(this.attributes, this.contentType, this.ensureNoDirectoryConflict, this.overwriteExisting, this.overwriteGenerationId);
        }
    }
}

