/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.text;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BaseTextExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements IExplorerFileTypeHandler {
    private Text wText;

    public BaseTextExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    @Override
    public void renderFile(Composite composite) {
        this.wText = new Text(composite, 770);
        PropsUi.setLook((Widget)this.wText, 1);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment(0, 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.wText.setLayoutData((Object)fdText);
        this.reload();
        this.wText.addModifyListener(e -> {
            this.explorerFile.setChanged();
            this.perspective.updateGui();
        });
    }

    @Override
    public void save() throws HopException {
        try {
            String filename = this.explorerFile.getFilename();
            try (OutputStream outputStream = HopVfs.getOutputStream((String)filename, (boolean)false);){
                outputStream.write(this.wText.getText().getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            this.explorerFile.clearChanged();
            this.perspective.refresh();
            this.perspective.updateGui();
        }
        catch (Exception e) {
            throw new HopException("Unable to save file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void reload() {
        try {
            String contents = this.readTextFileContent("UTF-8");
            this.wText.setText(Const.NVL((String)contents, (String)""));
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error reading contents of file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
        }
    }

    @Override
    public void selectAll() {
        this.wText.selectAll();
    }

    @Override
    public void unselectAll() {
        this.wText.setSelection(0, 0);
    }

    @Override
    public void copySelectedToClipboard() {
        this.wText.copy();
    }
}

