/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.InvalidCryptoConfigurationException;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import com.healthmarketscience.jackcess.impl.UnsupportedCodecException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class EncryptionHeader {
    public static final Charset UNICODE_CHARSET = Charset.forName("UTF-16LE");
    public static final int FCRYPTO_API_FLAG = 4;
    public static final int FDOC_PROPS_FLAG = 8;
    public static final int FEXTERNAL_FLAG = 16;
    public static final int FAES_FLAG = 32;
    private static final int ALGID_FLAGS = 0;
    private static final int ALGID_RC4 = 26625;
    private static final int ALGID_AES_128 = 26126;
    private static final int ALGID_AES_192 = 26127;
    private static final int ALGID_AES_256 = 26128;
    private static final int HASHALGID_FLAGS = 0;
    private static final int HASHALGID_SHA1 = 32772;
    private static final String CSP_BASE_STRING = " base ";
    private static final int RC4_BASE_DEFAULT_KEY_SIZE = 40;
    private static final int RC4_STRONG_DEFAULT_KEY_SIZE = 128;
    private final int _flags;
    private final int _sizeExtra;
    private final CryptoAlgorithm _cryptoAlg;
    private final HashAlgorithm _hashAlg;
    private final int _keySize;
    private final int _providerType;
    private final String _cspName;

    public EncryptionHeader(ByteBuffer buffer) {
        this._flags = buffer.getInt();
        this._sizeExtra = buffer.getInt();
        int algId = buffer.getInt();
        int algIdHash = buffer.getInt();
        int keySize = buffer.getInt();
        this._providerType = buffer.getInt();
        this._cryptoAlg = EncryptionHeader.parseCryptoAlgorithm(algId, this._flags);
        this._hashAlg = EncryptionHeader.parseHashAlgorithm(algIdHash, this._flags);
        buffer.getInt();
        buffer.getInt();
        this._cspName = EncryptionHeader.readCspName(buffer);
        this._keySize = EncryptionHeader.parseKeySize(keySize, this._cryptoAlg, this._cspName);
    }

    public int getFlags() {
        return this._flags;
    }

    public int getSizeExtra() {
        return this._sizeExtra;
    }

    public CryptoAlgorithm getCryptoAlgorithm() {
        return this._cryptoAlg;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this._hashAlg;
    }

    public int getKeySize() {
        return this._keySize;
    }

    public int getProviderType() {
        return this._providerType;
    }

    public String getCspName() {
        return this._cspName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EncryptionHeader read(ByteBuffer encProvBuf, Set<CryptoAlgorithm> validCryptoAlgos, Set<HashAlgorithm> validHashAlgos) {
        int headerLen = encProvBuf.getInt();
        int origLimit = encProvBuf.limit();
        int startPos = encProvBuf.position();
        encProvBuf.limit(startPos + headerLen);
        EncryptionHeader header = null;
        try {
            header = new EncryptionHeader(encProvBuf);
            if (!validCryptoAlgos.contains((Object)header.getCryptoAlgorithm())) {
                throw new InvalidCryptoConfigurationException(header + " crypto algorithm must be one of " + validCryptoAlgos);
            }
            if (!validHashAlgos.contains((Object)header.getHashAlgorithm())) {
                throw new InvalidCryptoConfigurationException(header + " hash algorithm must be one of " + validHashAlgos);
            }
            int keySize = header.getKeySize();
            if (!header.getCryptoAlgorithm().isValidKeySize(keySize)) {
                throw new InvalidCryptoConfigurationException(header + " key size is outside allowable range");
            }
            if (keySize % 8 != 0) {
                throw new InvalidCryptoConfigurationException(header + " key size must be multiple of 8");
            }
        }
        finally {
            encProvBuf.limit(origLimit);
        }
        encProvBuf.position(startPos + headerLen);
        return header;
    }

    private static CryptoAlgorithm parseCryptoAlgorithm(int algId, int flags) {
        switch (algId) {
            case 0: {
                if (EncryptionHeader.isFlagSet(flags, 16)) {
                    return CryptoAlgorithm.EXTERNAL;
                }
                if (!EncryptionHeader.isFlagSet(flags, 4)) break;
                return EncryptionHeader.isFlagSet(flags, 32) ? CryptoAlgorithm.AES_128 : CryptoAlgorithm.RC4;
            }
            case 26625: {
                return CryptoAlgorithm.RC4;
            }
            case 26126: {
                return CryptoAlgorithm.AES_128;
            }
            case 26127: {
                return CryptoAlgorithm.AES_192;
            }
            case 26128: {
                return CryptoAlgorithm.AES_256;
            }
        }
        throw new UnsupportedCodecException("Unsupported encryption algorithm " + algId + " (flags " + flags + ")");
    }

    private static HashAlgorithm parseHashAlgorithm(int algIdHash, int flags) {
        switch (algIdHash) {
            case 0: {
                if (EncryptionHeader.isFlagSet(flags, 16)) {
                    return HashAlgorithm.EXTERNAL;
                }
                return HashAlgorithm.SHA1;
            }
            case 32772: {
                return HashAlgorithm.SHA1;
            }
        }
        throw new UnsupportedCodecException("Unsupported hash algorithm " + algIdHash + " (flags " + flags + ")");
    }

    private static int parseKeySize(int keySize, CryptoAlgorithm cryptoAlg, String cspName) {
        if (keySize != 0) {
            return keySize;
        }
        if (cryptoAlg == CryptoAlgorithm.RC4) {
            return (cspName = cspName.trim().toLowerCase()).length() == 0 || cspName.contains(CSP_BASE_STRING) ? 40 : 128;
        }
        return cryptoAlg.getKeySizeMin();
    }

    private static String readCspName(ByteBuffer buffer) {
        int rem = buffer.remaining() / 2 * 2;
        String cspName = "";
        if (rem > 0) {
            ByteBuffer cspNameBuf = ByteBuffer.wrap(ByteUtil.getBytes((ByteBuffer)buffer, (int)rem));
            CharBuffer tmpCspName = UNICODE_CHARSET.decode(cspNameBuf);
            for (int i = 0; i < tmpCspName.limit(); ++i) {
                if (tmpCspName.charAt(i) != '\u0000') continue;
                tmpCspName.limit(i);
                break;
            }
            cspName = tmpCspName.toString();
        }
        return cspName;
    }

    public static boolean isFlagSet(int flagsVal, int flagMask) {
        return (flagsVal & flagMask) != 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)CustomToStringStyle.VALUE_INSTANCE);
    }

    public static enum HashAlgorithm {
        EXTERNAL(0),
        SHA1(32772);

        private final int _algId;

        private HashAlgorithm(int algId) {
            this._algId = algId;
        }

        public int getAlgId() {
            return this._algId;
        }
    }

    public static enum CryptoAlgorithm {
        EXTERNAL(0, 0, 0, 0),
        RC4(26625, 20, 40, 512),
        AES_128(26126, 32, 128, 128),
        AES_192(26127, 32, 192, 192),
        AES_256(26128, 32, 256, 256);

        private final int _algId;
        private final int _encVerifierHashLen;
        private final int _keySizeMin;
        private final int _keySizeMax;

        private CryptoAlgorithm(int algId, int encVerifierHashLen, int keySizeMin, int keySizeMax) {
            this._algId = algId;
            this._encVerifierHashLen = encVerifierHashLen;
            this._keySizeMin = keySizeMin;
            this._keySizeMax = keySizeMax;
        }

        public int getAlgId() {
            return this._algId;
        }

        public int getKeySizeMin() {
            return this._keySizeMin;
        }

        public int getEncryptedVerifierHashLen() {
            return this._encVerifierHashLen;
        }

        public boolean isValidKeySize(int keySize) {
            return this._keySizeMin <= keySize && keySize <= this._keySizeMax;
        }
    }
}

