/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.common.MetricsScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfLogger {
    public static final String ACQUIRE_READ_WRITE_LOCKS = "acquireReadWriteLocks";
    public static final String COMPILE = "compile";
    public static final String WAIT_COMPILE = "waitCompile";
    public static final String PARSE = "parse";
    public static final String ANALYZE = "semanticAnalyze";
    public static final String OPTIMIZER = "optimizer";
    public static final String MATERIALIZED_VIEWS_REGISTRY_REFRESH = "MaterializedViewsRegistryRefresh";
    public static final String DO_AUTHORIZATION = "doAuthorization";
    public static final String DRIVER_EXECUTE = "Driver.execute";
    public static final String INPUT_SUMMARY = "getInputSummary";
    public static final String INPUT_PATHS = "getInputPaths";
    public static final String GET_SPLITS = "getSplits";
    public static final String RUN_TASKS = "runTasks";
    public static final String SERIALIZE_PLAN = "serializePlan";
    public static final String DESERIALIZE_PLAN = "deserializePlan";
    public static final String CLONE_PLAN = "clonePlan";
    public static final String RELEASE_LOCKS = "releaseLocks";
    public static final String PRUNE_LISTING = "prune-listing";
    public static final String PARTITION_RETRIEVING = "partition-retrieving";
    public static final String PRE_HOOK = "PreHook.";
    public static final String POST_HOOK = "PostHook.";
    public static final String FAILURE_HOOK = "FailureHook.";
    public static final String TEZ_COMPILER = "TezCompiler";
    public static final String TEZ_SUBMIT_TO_RUNNING = "TezSubmitToRunningDag";
    public static final String TEZ_BUILD_DAG = "TezBuildDag";
    public static final String TEZ_SUBMIT_DAG = "TezSubmitDag";
    public static final String TEZ_RUN_DAG = "TezRunDag";
    public static final String TEZ_CREATE_VERTEX = "TezCreateVertex.";
    public static final String TEZ_RUN_VERTEX = "TezRunVertex.";
    public static final String TEZ_INITIALIZE_PROCESSOR = "TezInitializeProcessor";
    public static final String TEZ_RUN_PROCESSOR = "TezRunProcessor";
    public static final String TEZ_INIT_OPERATORS = "TezInitializeOperators";
    public static final String LOAD_HASHTABLE = "LoadHashtable";
    public static final String TEZ_GET_SESSION = "TezGetSession";
    public static final String SAVE_TO_RESULTS_CACHE = "saveToResultsCache";
    public static final String SPARK_SUBMIT_TO_RUNNING = "SparkSubmitToRunning";
    public static final String SPARK_BUILD_PLAN = "SparkBuildPlan";
    public static final String SPARK_BUILD_RDD_GRAPH = "SparkBuildRDDGraph";
    public static final String SPARK_CREATE_EXPLAIN_PLAN = "SparkCreateExplainPlan.";
    public static final String SPARK_SUBMIT_JOB = "SparkSubmitJob";
    public static final String SPARK_RUN_JOB = "SparkRunJob";
    public static final String SPARK_CREATE_TRAN = "SparkCreateTran.";
    public static final String SPARK_RUN_STAGE = "SparkRunStage.";
    public static final String SPARK_INIT_OPERATORS = "SparkInitializeOperators";
    public static final String SPARK_GENERATE_TASK_TREE = "SparkGenerateTaskTree";
    public static final String SPARK_OPTIMIZE_OPERATOR_TREE = "SparkOptimizeOperatorTree";
    public static final String SPARK_OPTIMIZE_TASK_TREE = "SparkOptimizeTaskTree";
    public static final String SPARK_FLUSH_HASHTABLE = "SparkFlushHashTable.";
    public static final String SPARK_DYNAMICALLY_PRUNE_PARTITIONS = "SparkDynamicallyPrunePartitions.";
    public static final String FILE_MOVES = "FileMoves";
    public static final String LOAD_TABLE = "LoadTable";
    public static final String LOAD_PARTITION = "LoadPartition";
    public static final String LOAD_DYNAMIC_PARTITIONS = "LoadDynamicPartitions";
    public static final String HIVE_GET_TABLE = "getTablesByType";
    public static final String HIVE_GET_DATABASE = "getDatabase";
    public static final String HIVE_GET_DATABASE_2 = "getDatabase2";
    public static final String HIVE_GET_PARTITIONS = "getPartitions";
    public static final String HIVE_GET_PARTITIONS_2 = "getPartitions2";
    public static final String HIVE_GET_PARTITIONS_BY_EXPR = "getPartitionsByExpr";
    public static final String HIVE_GET_TABLE_COLUMN_STATS = "getTableColumnStatistics";
    public static final String HIVE_GET_AGGR_COL_STATS = "getAggrColStatsFor";
    public static final String HIVE_GET_PK = "getPrimaryKeys";
    public static final String HIVE_GET_FK = "getForeignKeys";
    public static final String HIVE_GET_UNIQ_CONSTRAINT = "getUniqueConstraints";
    public static final String HIVE_GET_NOT_NULL_CONSTRAINT = "getNotNullConstraints";
    public static final String HIVE_GET_TABLE_CONSTRAINTS = "getTableConstraints";
    protected final Map<String, Long> startTimes = new HashMap<String, Long>();
    protected final Map<String, Long> endTimes = new HashMap<String, Long>();
    private static final Logger LOG = LoggerFactory.getLogger((String)PerfLogger.class.getName());
    protected static final ThreadLocal<PerfLogger> perfLogger = new ThreadLocal();
    transient Map<String, MetricsScope> openScopes = new HashMap<String, MetricsScope>();

    private PerfLogger() {
    }

    public static PerfLogger getPerfLogger(HiveConf conf, boolean resetPerfLogger) {
        PerfLogger result = perfLogger.get();
        if (resetPerfLogger || result == null) {
            if (conf == null) {
                result = new PerfLogger();
            } else {
                try {
                    result = (PerfLogger)ReflectionUtils.newInstance((Class)conf.getClassByName(conf.getVar(HiveConf.ConfVars.HIVE_PERF_LOGGER)), (Configuration)conf);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Performance Logger Class not found:" + e.getMessage());
                    result = new PerfLogger();
                }
            }
            perfLogger.set(result);
        }
        return result;
    }

    public static void setPerfLogger(PerfLogger resetPerfLogger) {
        perfLogger.set(resetPerfLogger);
    }

    public void perfLogBegin(String callerName, String method) {
        long startTime = System.currentTimeMillis();
        this.startTimes.put(method, startTime);
        LOG.debug("<PERFLOG method={} from={}>", (Object)method, (Object)callerName);
        this.beginMetrics(method);
    }

    public long perfLogEnd(String callerName, String method) {
        return this.perfLogEnd(callerName, method, null);
    }

    public long perfLogEnd(String callerName, String method, String additionalInfo) {
        long duration;
        Long startTime = this.startTimes.get(method);
        long endTime = System.currentTimeMillis();
        this.endTimes.put(method, endTime);
        long l = duration = startTime == null ? -1L : endTime - startTime;
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("</PERFLOG method=").append(method);
            if (startTime != null) {
                sb.append(" start=").append(startTime);
            }
            sb.append(" end=").append(endTime);
            if (startTime != null) {
                sb.append(" duration=").append(duration);
            }
            sb.append(" from=").append(callerName);
            if (additionalInfo != null) {
                sb.append(" ").append(additionalInfo);
            }
            sb.append(">");
            LOG.debug(sb.toString());
        }
        this.endMetrics(method);
        return duration;
    }

    public Long getStartTime(String method) {
        long startTime = 0L;
        if (this.startTimes.containsKey(method)) {
            startTime = this.startTimes.get(method);
        }
        return startTime;
    }

    public Long getEndTime(String method) {
        long endTime = 0L;
        if (this.endTimes.containsKey(method)) {
            endTime = this.endTimes.get(method);
        }
        return endTime;
    }

    public boolean startTimeHasMethod(String method) {
        return this.startTimes.containsKey(method);
    }

    public boolean endTimeHasMethod(String method) {
        return this.endTimes.containsKey(method);
    }

    public Long getDuration(String method) {
        long duration = 0L;
        if (this.startTimes.containsKey(method) && this.endTimes.containsKey(method)) {
            duration = this.endTimes.get(method) - this.startTimes.get(method);
        }
        return duration;
    }

    public Map<String, Long> getStartTimes() {
        return ImmutableMap.copyOf(this.startTimes);
    }

    public Map<String, Long> getEndTimes() {
        return ImmutableMap.copyOf(this.endTimes);
    }

    private void beginMetrics(String method) {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            MetricsScope scope = metrics.createScope("api_" + method);
            this.openScopes.put(method, scope);
        }
    }

    private void endMetrics(String method) {
        MetricsScope scope;
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null && (scope = this.openScopes.remove(method)) != null) {
            metrics.endScope(scope);
        }
    }

    public void cleanupPerfLogMetrics() {
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            for (MetricsScope openScope : this.openScopes.values()) {
                metrics.endScope(openScope);
            }
        }
        this.openScopes.clear();
    }
}

