/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.GetMapAndMergeResultStatuses;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.GetShufflePushMergerLocations;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.MapSizesByExecutorId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MergeStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.KeyLock;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!\u0002\f\u0018\u0001]i\u0002\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\t\u000b\u001d\u0002A\u0011\u0001\u0015\t\u000f-\u0002!\u0019!C\u0001Y!1A\t\u0001Q\u0001\n5Bq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004M\u0001\u0001\u0006Ia\u0012\u0005\t\u001b\u0002A)\u0019!C\u0005\u001d\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006BB6\u0001A\u0003%A\u000bC\u0004m\u0001\t\u0007I\u0011B7\t\rQ\u0004\u0001\u0015!\u0003o\u0011\u0015)\b\u0001\"\u0011w\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002J\u0001!\t%a\u0013\t\u000f\u0005%\u0003\u0001\"\u0011\u0002T!9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000bCq!a$\u0001\t\u0003\t\tJ\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe^{'o[3s\u0015\tA\u0012$A\u0003ta\u0006\u00148N\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7C\u0001\u0001\u001f!\ty\u0002%D\u0001\u0018\u0013\t\tsC\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006!1m\u001c8g\u0007\u0001\u0001\"aH\u0013\n\u0005\u0019:\"!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003?\u0001AQA\t\u0002A\u0002\u0011\n1\"\\1q'R\fG/^:fgV\tQ\u0006\u0005\u0003/k]ZT\"A\u0018\u000b\u0005A\n\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003eM\n!bY8mY\u0016\u001cG/[8o\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c0\u0005\ri\u0015\r\u001d\t\u0003qej\u0011aM\u0005\u0003uM\u00121!\u00138u!\rADHP\u0005\u0003{M\u0012Q!\u0011:sCf\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\f\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA\"A\u0005%i\u0015\r]*uCR,8/\u0001\u0007nCB\u001cF/\u0019;vg\u0016\u001c\b%A\u0007nKJ<Wm\u0015;biV\u001cXm]\u000b\u0002\u000fB!a&N\u001cI!\rAD(\u0013\t\u0003\u007f)K!a\u0013!\u0003\u00175+'oZ3Ti\u0006$Xo]\u0001\u000f[\u0016\u0014x-Z*uCR,8/Z:!\u0003A1W\r^2i\u001b\u0016\u0014x-\u001a*fgVdG/F\u0001P!\tA\u0004+\u0003\u0002Rg\t9!i\\8mK\u0006t\u0017AG:ik\u001a4G.\u001a)vg\"lUM]4fe2{7-\u0019;j_:\u001cX#\u0001+\u0011\tUCv'W\u0007\u0002-*\u0011q+M\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001cW!\rQ&-\u001a\b\u00037\u0002t!\u0001X0\u000e\u0003uS!AX\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014BA14\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00193\u0003\u0007M+\u0017O\u0003\u0002bgA\u0011a-[\u0007\u0002O*\u0011\u0001nF\u0001\bgR|'/Y4f\u0013\tQwM\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u00027MDWO\u001a4mKB+8\u000f['fe\u001e,'\u000fT8dCRLwN\\:!\u000311W\r^2iS:<Gj\\2l+\u0005q\u0007cA8so5\t\u0001O\u0003\u0002r/\u0005!Q\u000f^5m\u0013\t\u0019\bOA\u0004LKfdunY6\u0002\u001b\u0019,Go\u00195j]\u001edunY6!\u0003]9W\r^'baNK'0Z:Cs\u0016CXmY;u_JLE\rF\u0006x\u0003\u001f\t\u0019\"a\u0006\u0002\u001c\u0005}\u0001c\u0001.yu&\u0011\u0011\u0010\u001a\u0002\t\u0013R,'/\u0019;peB!\u0001h_3~\u0013\ta8G\u0001\u0004UkBdWM\r\t\u00045\nt\bc\u0002\u001d\u0000\u0003\u0007\tIaN\u0005\u0004\u0003\u0003\u0019$A\u0002+va2,7\u0007E\u0002g\u0003\u000bI1!a\u0002h\u0005\u001d\u0011En\\2l\u0013\u0012\u00042\u0001OA\u0006\u0013\r\tia\r\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\u00121\u0001\raN\u0001\ng\",hM\u001a7f\u0013\u0012Da!!\u0006\r\u0001\u00049\u0014!D:uCJ$X*\u00199J]\u0012,\u0007\u0010\u0003\u0004\u0002\u001a1\u0001\raN\u0001\fK:$W*\u00199J]\u0012,\u0007\u0010\u0003\u0004\u0002\u001e1\u0001\raN\u0001\u000fgR\f'\u000f\u001e)beRLG/[8o\u0011\u0019\t\t\u0003\u0004a\u0001o\u0005aQM\u001c3QCJ$\u0018\u000e^5p]\u00069s-\u001a;QkND')Y:fINCWO\u001a4mK6\u000b\u0007oU5{KN\u0014\u00150\u0012=fGV$xN]%e)1\t9#!\f\u00020\u0005E\u00121GA\u001b!\ry\u0012\u0011F\u0005\u0004\u0003W9\"\u0001F'baNK'0Z:Cs\u0016CXmY;u_JLE\r\u0003\u0004\u0002\u00125\u0001\ra\u000e\u0005\u0007\u0003+i\u0001\u0019A\u001c\t\r\u0005eQ\u00021\u00018\u0011\u0019\ti\"\u0004a\u0001o!1\u0011\u0011E\u0007A\u0002]\n1dZ3u\u001b\u0006\u00048+\u001b>fg\nKX\t_3dkR|'/\u00133J[BdGCDA\u0014\u0003w\ti$a\u0010\u0002B\u0005\r\u0013Q\t\u0005\u0007\u0003#q\u0001\u0019A\u001c\t\r\u0005Ua\u00021\u00018\u0011\u0019\tIB\u0004a\u0001o!1\u0011Q\u0004\bA\u0002]Ba!!\t\u000f\u0001\u00049\u0004BBA$\u001d\u0001\u0007q*\u0001\bvg\u0016lUM]4f%\u0016\u001cX\u000f\u001c;\u00023\u001d,G/T1q'&TXm\u001d$pe6+'oZ3SKN,H\u000e\u001e\u000b\u0006o\u00065\u0013q\n\u0005\u0007\u0003#y\u0001\u0019A\u001c\t\r\u0005Es\u00021\u00018\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0015\u000f]\f)&a\u0016\u0002Z!1\u0011\u0011\u0003\tA\u0002]Ba!!\u0015\u0011\u0001\u00049\u0004bBA.!\u0001\u0007\u0011QL\u0001\rG\",hn\u001b+sC\u000e\\WM\u001d\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M\u000e\u0002\u001bI|\u0017M]5oO\nLG/\\1q\u0013\u0011\t9'!\u0019\u0003\u001bI{\u0017M]5oO\nKG/\\1q\u0003u9W\r^*ik\u001a4G.\u001a)vg\"lUM]4fe2{7-\u0019;j_:\u001cHcA-\u0002n!1\u0011\u0011C\tA\u0002]\n!cZ3u\u001b\u0016\u0014x-\u001a:M_\u000e\fG/[8ogR\u0019\u0011,a\u001d\t\r\u0005E!\u00031\u00018\u0003-9W\r^*uCR,8/Z:\u0015\u0011\u0005e\u00141PA?\u0003\u007f\u0002B\u0001O><\u0011\"1\u0011\u0011C\nA\u0002]BQAI\nA\u0002\u0011Ba!!!\u0014\u0001\u0004y\u0015aE2b]\u001a+Go\u00195NKJ<WMU3tk2$\u0018!E;oe\u0016<\u0017n\u001d;feNCWO\u001a4mKR!\u0011qQAG!\rA\u0014\u0011R\u0005\u0004\u0003\u0017\u001b$\u0001B+oSRDa!!\u0005\u0015\u0001\u00049\u0014aC;qI\u0006$X-\u00129pG\"$B!a\"\u0002\u0014\"9\u0011QS\u000bA\u0002\u0005%\u0011\u0001\u00038fo\u0016\u0003xn\u00195")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private boolean fetchMergeResult;
    private final SparkConf conf;
    private final Map<Object, MapStatus[]> mapStatuses;
    private final Map<Object, MergeStatus[]> mergeStatuses;
    private final scala.collection.concurrent.Map<Object, Seq<BlockManagerId>> shufflePushMergerLocations;
    private final KeyLock<Object> fetchingLock;
    private volatile boolean bitmap$0;

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    public Map<Object, MergeStatus[]> mergeStatuses() {
        return this.mergeStatuses;
    }

    private boolean fetchMergeResult$lzycompute() {
        MapOutputTrackerWorker mapOutputTrackerWorker = this;
        synchronized (mapOutputTrackerWorker) {
            if (!this.bitmap$0) {
                this.fetchMergeResult = Utils$.MODULE$.isPushBasedShuffleEnabled(this.conf, false, Utils$.MODULE$.isPushBasedShuffleEnabled$default$3());
                this.bitmap$0 = true;
            }
        }
        return this.fetchMergeResult;
    }

    private boolean fetchMergeResult() {
        return !this.bitmap$0 ? this.fetchMergeResult$lzycompute() : this.fetchMergeResult;
    }

    public scala.collection.concurrent.Map<Object, Seq<BlockManagerId>> shufflePushMergerLocations() {
        return this.shufflePushMergerLocations;
    }

    private KeyLock<Object> fetchingLock() {
        return this.fetchingLock;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        MapSizesByExecutorId mapSizesByExecutorId = this.getMapSizesByExecutorIdImpl(shuffleId, startMapIndex, endMapIndex, startPartition, endPartition, false);
        Predef$.MODULE$.assert(mapSizesByExecutorId.enableBatchFetch());
        return mapSizesByExecutorId.iter();
    }

    @Override
    public MapSizesByExecutorId getPushBasedShuffleMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        return this.getMapSizesByExecutorIdImpl(shuffleId, startMapIndex, endMapIndex, startPartition, endPartition, true);
    }

    private MapSizesByExecutorId getMapSizesByExecutorIdImpl(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition, boolean useMergeResult) {
        MapSizesByExecutorId mapSizesByExecutorId;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Fetching outputs for shuffle ").append(shuffleId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, useMergeResult ? this.fetchMergeResult() : false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergedOutputStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergedOutputStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergedOutputStatuses2 = (MergeStatus[])tuple23._2();
        try {
            int actualEndMapIndex = endMapIndex == Integer.MAX_VALUE ? mapOutputStatuses2.length : endMapIndex;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Convert map statuses for shuffle ").append(shuffleId).append(", ").append("mappers ").append(startMapIndex).append("-").append(actualEndMapIndex).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
            mapSizesByExecutorId = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, mapOutputStatuses2, startMapIndex, actualEndMapIndex, (Option<MergeStatus[]>)Option$.MODULE$.apply((Object)mergedOutputStatuses2));
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return mapSizesByExecutorId;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, this.fetchMergeResult());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapOutputStatuses = (MapStatus[])tuple2._1();
        MergeStatus[] mergeResultStatuses = (MergeStatus[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mapOutputStatuses, (Object)mergeResultStatuses);
        Tuple2 tuple23 = tuple22;
        MapStatus[] mapOutputStatuses2 = (MapStatus[])tuple23._1();
        MergeStatus[] mergeResultStatuses2 = (MergeStatus[])tuple23._2();
        try {
            MergeStatus mergeStatus = mergeResultStatuses2[partitionId];
            MapOutputTracker$.MODULE$.validateStatus(mergeStatus, shuffleId, partitionId);
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, mergeStatus.tracker());
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesForMergeResult(int shuffleId, int partitionId, RoaringBitmap chunkTracker) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        MapStatus[] mapOutputStatuses;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Fetching backup outputs for shuffle ").append(shuffleId).append(", partition ").append(partitionId).toString());
        Tuple2<MapStatus[], MergeStatus[]> tuple2 = this.getStatuses(shuffleId, this.conf, this.fetchMergeResult());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MapStatus[] mapStatusArray = mapOutputStatuses = (MapStatus[])tuple2._1();
        MapStatus[] mapOutputStatuses2 = mapStatusArray;
        try {
            iterator = MapOutputTracker$.MODULE$.getMapStatusesForMergeStatus(shuffleId, partitionId, mapOutputStatuses2, chunkTracker);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            this.mergeStatuses().clear();
            throw e;
        }
        return iterator;
    }

    @Override
    public Seq<BlockManagerId> getShufflePushMergerLocations(int shuffleId) {
        return (Seq)this.shufflePushMergerLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> this.getMergerLocations(shuffleId));
    }

    private Seq<BlockManagerId> getMergerLocations(int shuffleId) {
        return (Seq)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            block2: {
                Seq fetchedMergers = (Seq)this.shufflePushMergerLocations().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                if (fetchedMergers != null) break block2;
                fetchedMergers = (Seq)this.askTracker(new GetShufflePushMergerLocations(shuffleId), ClassTag$.MODULE$.apply(Seq.class));
                if (fetchedMergers.nonEmpty()) {
                    this.shufflePushMergerLocations().update((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMergers);
                } else {
                    fetchedMergers = (Seq)Nil$.MODULE$;
                }
            }
            return var2_2;
        });
    }

    private Tuple2<MapStatus[], MergeStatus[]> getStatuses(int shuffleId, SparkConf conf, boolean canFetchMergeResult) {
        Tuple2 tuple2;
        if (canFetchMergeResult) {
            MapStatus[] mapOutputStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            MergeStatus[] mergeOutputStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (mapOutputStatuses == null || mergeOutputStatuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Don't have map/merge outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedMapStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    MergeStatus[] fetchedMergeStatuses = (MergeStatus[])this.mergeStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedMapStatuses == null || fetchedMergeStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        Tuple2 fetchedBytes = (Tuple2)this.askTracker(new GetMapAndMergeResultStatuses(shuffleId), ClassTag$.MODULE$.apply(Tuple2.class));
                        try {
                            fetchedMapStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._1(), conf);
                            fetchedMergeStatuses = (MergeStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses((byte[])fetchedBytes._2(), conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(67).append("Unable to deserialize broadcasted map/merge statuses").append(" for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map/merge output locations");
                        this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMapStatuses);
                        boxedUnit = this.mergeStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedMergeStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Fetching map/merge output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedMapStatuses, (Object)fetchedMergeStatuses);
                });
            } else {
                tuple2 = new Tuple2((Object)mapOutputStatuses, (Object)mergeOutputStatuses);
            }
        } else {
            MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
            if (statuses == null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
                long startTimeNs = System.nanoTime();
                tuple2 = (Tuple2)this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    MapStatus[] fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                    if (fetchedStatuses == null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                        byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                        try {
                            fetchedStatuses = (MapStatus[])MapOutputTracker$.MODULE$.deserializeOutputStatuses(fetchedBytes, conf);
                        }
                        catch (SparkException e) {
                            throw new MetadataFetchFailedException(shuffleId, -1, new StringBuilder(61).append("Unable to deserialize broadcasted map statuses for shuffle ").append(shuffleId).append(": ").append(e.getCause()).toString());
                        }
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the map output locations");
                        boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                    return new Tuple2((Object)fetchedStatuses, null);
                });
            } else {
                tuple2 = new Tuple2((Object)statuses, null);
            }
        }
        return tuple2;
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
        this.mergeStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
        this.shufflePushMergerLocations().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
                this.mergeStatuses().clear();
                this.shufflePushMergerLocations().clear();
            }
        }
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        this.conf = conf;
        super(conf);
        this.mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.mergeStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.shufflePushMergerLocations = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.fetchingLock = new KeyLock();
    }
}

