/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HintsServiceMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintsServiceMetrics.class);
    private static final MetricNameFactory factory = new DefaultNameFactory("HintsService");
    public static final Meter hintsSucceeded = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("HintsSucceeded"));
    public static final Meter hintsFailed = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("HintsFailed"));
    public static final Meter hintsTimedOut = CassandraMetricsRegistry.Metrics.meter(factory.createMetricName("HintsTimedOut"));
    private static final Histogram globalDelayHistogram = CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("Hint_delays"), false);
    private static final LoadingCache<InetAddressAndPort, Histogram> delayByEndpoint = Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).build(address -> CassandraMetricsRegistry.Metrics.histogram(factory.createMetricName("Hint_delays-" + address.toString().replace(':', '.')), false));

    public static void updateDelayMetrics(InetAddressAndPort endpoint, long delay) {
        if (delay <= 0L) {
            logger.warn("Invalid negative latency in hint delivery delay: {}", (Object)delay);
            return;
        }
        globalDelayHistogram.update(delay);
        ((Histogram)delayByEndpoint.get((Object)endpoint)).update(delay);
    }
}

