/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.cassandra.net.AsyncPromise;

public class AsyncChannelPromise
extends AsyncPromise<Void>
implements ChannelPromise {
    private final Channel channel;

    public AsyncChannelPromise(Channel channel) {
        super((EventExecutor)channel.eventLoop());
        this.channel = channel;
    }

    AsyncChannelPromise(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        super((EventExecutor)channel.eventLoop(), listener);
        this.channel = channel;
    }

    public static AsyncChannelPromise withListener(ChannelHandlerContext context, GenericFutureListener<? extends Future<? super Void>> listener) {
        return AsyncChannelPromise.withListener(context.channel(), listener);
    }

    public static AsyncChannelPromise withListener(Channel channel, GenericFutureListener<? extends Future<? super Void>> listener) {
        return new AsyncChannelPromise(channel, listener);
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return context.writeAndFlush(message, (ChannelPromise)AsyncChannelPromise.withListener(context.channel(), listener));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message, GenericFutureListener<? extends Future<? super Void>> listener) {
        return channel.writeAndFlush(message, (ChannelPromise)AsyncChannelPromise.withListener(channel, listener));
    }

    public static ChannelFuture writeAndFlush(ChannelHandlerContext context, Object message) {
        return context.writeAndFlush(message, (ChannelPromise)new AsyncChannelPromise(context.channel()));
    }

    public static ChannelFuture writeAndFlush(Channel channel, Object message) {
        return channel.writeAndFlush(message, (ChannelPromise)new AsyncChannelPromise(channel));
    }

    public Channel channel() {
        return this.channel;
    }

    public boolean isVoid() {
        return false;
    }

    public ChannelPromise setSuccess() {
        return this.setSuccess(null);
    }

    public ChannelPromise setSuccess(Void v) {
        super.setSuccess(v);
        return this;
    }

    public boolean trySuccess() {
        return this.trySuccess(null);
    }

    public ChannelPromise setFailure(Throwable throwable) {
        super.setFailure(throwable);
        return this;
    }

    public ChannelPromise sync() throws InterruptedException {
        super.sync();
        return this;
    }

    public ChannelPromise syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    public ChannelPromise await() throws InterruptedException {
        super.await();
        return this;
    }

    public ChannelPromise awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    public ChannelPromise addListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        super.addListener(listener);
        return this;
    }

    public ChannelPromise addListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        super.addListeners((GenericFutureListener<? extends Future<? super V>>[])listeners);
        return this;
    }

    public ChannelPromise removeListener(GenericFutureListener<? extends Future<? super Void>> listener) {
        super.removeListener(listener);
        return this;
    }

    public ChannelPromise removeListeners(GenericFutureListener<? extends Future<? super Void>> ... listeners) {
        super.removeListeners((GenericFutureListener<? extends Future<? super V>>[])listeners);
        return this;
    }

    public ChannelPromise unvoid() {
        return this;
    }
}

