/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.AcceptVersions;
import org.apache.cassandra.net.ConnectionType;
import org.apache.cassandra.net.Crc;
import org.apache.cassandra.net.GlobalBufferPoolAllocator;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundConnectionSettings;
import org.apache.cassandra.utils.memory.BufferPools;

class HandshakeProtocol {
    static final long TIMEOUT_MILLIS = 3L * DatabaseDescriptor.getRpcTimeout(TimeUnit.MILLISECONDS);

    HandshakeProtocol() {
    }

    private static int getBits(int packed, int start, int count) {
        return packed >>> start & ~(-1 << count);
    }

    static class ConfirmOutboundPre40 {
        private static final int MAX_LENGTH = 23;
        final int maxMessagingVersion;
        final InetAddressAndPort from;

        ConfirmOutboundPre40(int maxMessagingVersion, InetAddressAndPort from) {
            this.maxMessagingVersion = maxMessagingVersion;
            this.from = from;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ByteBuf encode() {
            ByteBuffer buffer = BufferPools.forNetworking().get(23, BufferType.OFF_HEAP);
            try (DataOutputBufferFixed out = new DataOutputBufferFixed(buffer);){
                out.writeInt(this.maxMessagingVersion);
                InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(this.from, (DataOutputPlus)out, 10);
                buffer.flip();
                ByteBuf byteBuf = GlobalBufferPoolAllocator.wrap(buffer);
                return byteBuf;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        static ConfirmOutboundPre40 maybeDecode(ByteBuf in) {
            ByteBuffer nio = in.nioBuffer();
            int start = nio.position();
            DataInputBuffer input = new DataInputBuffer(nio, false);
            try {
                int version = input.readInt();
                InetAddressAndPort address = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(input, version);
                in.skipBytes(nio.position() - start);
                return new ConfirmOutboundPre40(version, address);
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @VisibleForTesting
        public boolean equals(Object other) {
            if (!(other instanceof ConfirmOutboundPre40)) {
                return false;
            }
            ConfirmOutboundPre40 that = (ConfirmOutboundPre40)other;
            return this.maxMessagingVersion == that.maxMessagingVersion && Objects.equals(this.from, that.from);
        }

        public String toString() {
            return String.format("ConfirmOutboundPre40(maxMessagingVersion: %d; address: %s)", this.maxMessagingVersion, this.from);
        }
    }

    static class Accept {
        private static final int MAX_LENGTH = 12;
        final int useMessagingVersion;
        final int maxMessagingVersion;

        Accept(int useMessagingVersion, int maxMessagingVersion) {
            this.useMessagingVersion = useMessagingVersion;
            this.maxMessagingVersion = maxMessagingVersion;
        }

        ByteBuf encode(ByteBufAllocator allocator) {
            ByteBuf buffer = allocator.directBuffer(12);
            buffer.clear();
            buffer.writeInt(this.maxMessagingVersion);
            buffer.writeInt(this.useMessagingVersion);
            buffer.writeInt(Crc.computeCrc32(buffer, 0, 8));
            return buffer;
        }

        static ByteBuf respondPre40(int messagingVersion, ByteBufAllocator allocator) {
            ByteBuf buffer = allocator.directBuffer(4);
            buffer.clear();
            buffer.writeInt(messagingVersion);
            return buffer;
        }

        static Accept maybeDecode(ByteBuf in, int handshakeMessagingVersion) throws Crc.InvalidCrc {
            int readerIndex = in.readerIndex();
            if (in.readableBytes() < 4) {
                return null;
            }
            int maxMessagingVersion = in.readInt();
            int useMessagingVersion = 0;
            if (maxMessagingVersion < 12 || handshakeMessagingVersion < 12) {
                return new Accept(useMessagingVersion, maxMessagingVersion);
            }
            if (in.readableBytes() < 8) {
                in.readerIndex(readerIndex);
                return null;
            }
            useMessagingVersion = in.readInt();
            int computed = Crc.computeCrc32(in, readerIndex, readerIndex + 8);
            int read = in.readInt();
            if (read != computed) {
                throw new Crc.InvalidCrc(read, computed);
            }
            return new Accept(useMessagingVersion, maxMessagingVersion);
        }

        @VisibleForTesting
        public boolean equals(Object other) {
            return other instanceof Accept && this.useMessagingVersion == ((Accept)other).useMessagingVersion && this.maxMessagingVersion == ((Accept)other).maxMessagingVersion;
        }

        public String toString() {
            return String.format("Accept(use: %d, max: %d)", this.useMessagingVersion, this.maxMessagingVersion);
        }
    }

    static class Initiate {
        private static final int MIN_LENGTH = 8;
        private static final int MAX_LENGTH = 31;
        @Deprecated
        final int requestMessagingVersion;
        final AcceptVersions acceptVersions;
        final ConnectionType type;
        final OutboundConnectionSettings.Framing framing;
        final InetAddressAndPort from;

        Initiate(int requestMessagingVersion, AcceptVersions acceptVersions, ConnectionType type, OutboundConnectionSettings.Framing framing, InetAddressAndPort from) {
            this.requestMessagingVersion = requestMessagingVersion;
            this.acceptVersions = acceptVersions;
            this.type = type;
            this.framing = framing;
            this.from = from;
        }

        @VisibleForTesting
        int encodeFlags() {
            int flags = 0;
            if (this.type.isMessaging()) {
                flags |= this.type.twoBitID();
            }
            if (this.type.isStreaming()) {
                flags |= 8;
            }
            flags |= (this.framing.id & 1) << 2 | (this.framing.id & 2) << 3;
            flags |= this.requestMessagingVersion << 8;
            if (this.requestMessagingVersion < 12 || this.acceptVersions.max < 12) {
                return flags;
            }
            flags |= this.acceptVersions.min << 16;
            return flags |= this.acceptVersions.max << 24;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ByteBuf encode() {
            ByteBuffer buffer = BufferPools.forNetworking().get(31, BufferType.OFF_HEAP);
            try (DataOutputBufferFixed out = new DataOutputBufferFixed(buffer);){
                out.writeInt(-900387334);
                out.writeInt(this.encodeFlags());
                if (this.requestMessagingVersion >= 12 && this.acceptVersions.max >= 12) {
                    InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(this.from, (DataOutputPlus)out, this.requestMessagingVersion);
                    out.writeInt(Crc.computeCrc32(buffer, 0, buffer.position()));
                }
                buffer.flip();
                ByteBuf byteBuf = GlobalBufferPoolAllocator.wrap(buffer);
                return byteBuf;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static Initiate maybeDecode(ByteBuf buf) throws IOException {
            if (buf.readableBytes() < 8) {
                return null;
            }
            ByteBuffer nio = buf.nioBuffer();
            int start = nio.position();
            try (DataInputBuffer in = new DataInputBuffer(nio, false);){
                Message.validateLegacyProtocolMagic(in.readInt());
                int flags = in.readInt();
                int requestedMessagingVersion = HandshakeProtocol.getBits(flags, 8, 8);
                int minMessagingVersion = HandshakeProtocol.getBits(flags, 16, 8);
                int maxMessagingVersion = HandshakeProtocol.getBits(flags, 24, 8);
                int framingBits = HandshakeProtocol.getBits(flags, 2, 1) | HandshakeProtocol.getBits(flags, 4, 1) << 1;
                OutboundConnectionSettings.Framing framing = OutboundConnectionSettings.Framing.forId(framingBits);
                boolean isStream = HandshakeProtocol.getBits(flags, 3, 1) == 1;
                ConnectionType type = isStream ? ConnectionType.STREAMING : ConnectionType.fromId(HandshakeProtocol.getBits(flags, 0, 2));
                InetAddressAndPort from = null;
                if (requestedMessagingVersion >= 12 && maxMessagingVersion >= 12) {
                    from = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, requestedMessagingVersion);
                    int computed = Crc.computeCrc32(nio, start, nio.position());
                    int read = in.readInt();
                    if (read != computed) {
                        throw new Crc.InvalidCrc(read, computed);
                    }
                }
                buf.skipBytes(nio.position() - start);
                Initiate initiate = new Initiate(requestedMessagingVersion, (AcceptVersions)(minMessagingVersion == 0 && maxMessagingVersion == 0 ? null : new AcceptVersions(minMessagingVersion, maxMessagingVersion)), type, framing, from);
                return initiate;
            }
            catch (EOFException e) {
                return null;
            }
        }

        @VisibleForTesting
        public boolean equals(Object other) {
            if (!(other instanceof Initiate)) {
                return false;
            }
            Initiate that = (Initiate)other;
            return this.type == that.type && this.framing == that.framing && this.requestMessagingVersion == that.requestMessagingVersion && Objects.equals(this.acceptVersions, that.acceptVersions);
        }

        public String toString() {
            return String.format("Initiate(request: %d, min: %d, max: %d, type: %s, framing: %b, from: %s)", new Object[]{this.requestMessagingVersion, this.acceptVersions == null ? this.requestMessagingVersion : this.acceptVersions.min, this.acceptVersions == null ? this.requestMessagingVersion : this.acceptVersions.max, this.type, this.framing, this.from});
        }
    }
}

