/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.charset.StandardCharsets;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.AbstractTextSerializer;
import org.apache.cassandra.serializers.MarshalException;

public class AsciiSerializer
extends AbstractTextSerializer {
    public static final AsciiSerializer instance = new AsciiSerializer();

    private AsciiSerializer() {
        super(StandardCharsets.US_ASCII);
    }

    @Override
    public <V> void validate(V value, ValueAccessor<V> accessor) throws MarshalException {
        int size = accessor.size(value);
        for (int i = 0; i < size; ++i) {
            byte b = accessor.getByte(value, i);
            if (b >= 0) continue;
            throw new MarshalException("Invalid byte for ascii: " + Byte.toString(b));
        }
    }
}

