/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.NameFileFilter;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;

@ExtensionPoint(id="HopImportMigratedFiles", description="Imports variables into a Hop project", extensionPointId="HopImportMigratedFiles")
public class HopImportMigratedFiles
implements IExtensionPoint<Object[]> {
    public void callExtensionPoint(ILogChannel iLogChannel, IVariables variables, Object[] migrationObject) throws HopException {
        String projectName = (String)migrationObject[0];
        HashMap filesMap = (HashMap)migrationObject[1];
        FileObject inputFolder = (FileObject)migrationObject[2];
        boolean skipExitingFiles = (Boolean)migrationObject[3];
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ProjectConfig projectConfig = config.findProjectConfig(projectName);
        String projectHome = HopVfs.getFileObject((String)projectConfig.getProjectHome()).getName().getURI();
        try {
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(HopGui.getInstance().getShell());
            monitorDialog.run(true, monitor -> {
                try {
                    monitor.beginTask("Importing Kettle files...", filesMap.size());
                    this.importFiles(filesMap, inputFolder, projectHome, skipExitingFiles, monitor);
                    monitor.done();
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "Error importing files");
                }
            });
        }
        catch (Exception e) {
            throw new HopException("Error migrating file to project '" + projectName + "'", (Throwable)e);
        }
    }

    private void importFiles(HashMap<String, DOMSource> filesMap, FileObject inputFolder, String projectHome, boolean skipExitingFiles, IProgressMonitor monitor) throws TransformerConfigurationException, HopException, FileSystemException, InterruptedException {
        TransformerFactory transformerFactory = XmlHandler.createSecureTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        int processed = 0;
        Iterator<String> filesIterator = filesMap.keySet().iterator();
        while (filesIterator.hasNext() && !monitor.isCanceled()) {
            DOMSource domSource;
            String filename = filesIterator.next();
            FileObject sourceFile = HopVfs.getFileObject((String)filename);
            if (sourceFile.isFolder()) {
                monitor.worked(++processed);
                continue;
            }
            String targetFilename = filename.replaceAll(inputFolder.getName().getURI(), projectHome);
            monitor.subTask("Importing file to: " + targetFilename);
            FileObject targetFile = HopVfs.getFileObject((String)targetFilename);
            if (skipExitingFiles && targetFile.exists()) {
                monitor.worked(++processed);
                continue;
            }
            if (!targetFile.getParent().exists()) {
                targetFile.getParent().createFolder();
            }
            if ((domSource = filesMap.get(filename)) == null) {
                try {
                    NameFileFilter filter = new NameFileFilter(Collections.singletonList(sourceFile.getName().getBaseName()));
                    targetFile.getParent().copyFrom(sourceFile.getParent(), (FileSelector)new FileFilterSelector((FileFilter)filter));
                    monitor.worked(++processed);
                    continue;
                }
                catch (IOException e) {
                    throw new HopException("Error copying file '" + filename, (Throwable)e);
                }
            }
            StreamResult streamResult = new StreamResult(HopVfs.getOutputStream((String)targetFilename, (boolean)false));
            try {
                transformer.transform(domSource, streamResult);
            }
            catch (TransformerException e) {
                throw new HopException("Error importing file " + filename, (Throwable)e);
            }
            finally {
                monitor.worked(++processed);
            }
        }
    }
}

