/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.PeekingIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.util.MutablePair;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
class Aggregators {
    Aggregators() {
    }

    static <ValT, AccT, ResT, InT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Aggregator<InT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, ResT> value(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> fn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<InT, ValT> valueFn, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<ResT> outEnc) {
        return new ValueAggregator<ValT, AccT, ResT, InT>(fn, valueFn, accEnc, outEnc);
    }

    static <ValT, AccT, ResT, InT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Aggregator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>>> windowedValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> fn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, ValT> valueFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowEnc, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> outEnc) {
        if (!windowing.needsMerge()) {
            return new NonMergingWindowedAggregator<ValT, AccT, ResT, InT>(fn, valueFn, windowing, windowEnc, accEnc, outEnc);
        }
        if (windowing.getWindowFn().getClass().equals(Sessions.class)) {
            return new SessionsAggregator<ValT, AccT, ResT, InT>(fn, valueFn, windowing, windowEnc, accEnc, outEnc);
        }
        return new MergingWindowedAggregator<ValT, AccT, ResT, InT>(fn, valueFn, windowing, windowEnc, accEnc, outEnc);
    }

    private static abstract class CombineFnAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT, @UnknownKeyFor BuffT, @UnknownKeyFor OutT>
    extends Aggregator<InT, BuffT, OutT> {
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> fn;
        private final  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<InT, ValT> valueFn;
        private final @UnknownKeyFor @NonNull @Initialized Encoder<BuffT> bufferEnc;
        private final @UnknownKeyFor @NonNull @Initialized Encoder<OutT> outputEnc;

        public CombineFnAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> fn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<InT, ValT> valueFn, @UnknownKeyFor @NonNull @Initialized Encoder<BuffT> bufferEnc, @UnknownKeyFor @NonNull @Initialized Encoder<OutT> outputEnc) {
            this.fn = fn;
            this.valueFn = valueFn;
            this.bufferEnc = bufferEnc;
            this.outputEnc = outputEnc;
        }

        protected final ValT value(InT in) {
            return (ValT)this.valueFn.apply(in);
        }

        protected final AccT emptyAcc() {
            return (AccT)this.fn.createAccumulator();
        }

        protected final AccT mergeAccs(AccT a1, AccT a2) {
            return (AccT)this.fn.mergeAccumulators((Iterable)ImmutableList.of(a1, a2));
        }

        protected final AccT addToAcc(AccT acc, ValT val) {
            return (AccT)this.fn.addInput(acc, val);
        }

        protected final ResT extract(AccT acc) {
            return (ResT)this.fn.extractOutput(acc);
        }

        public @UnknownKeyFor @NonNull @Initialized Encoder<BuffT> bufferEncoder() {
            return this.bufferEnc;
        }

        public @UnknownKeyFor @NonNull @Initialized Encoder<OutT> outputEncoder() {
            return this.outputEnc;
        }
    }

    private static abstract class WindowedAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT, @UnknownKeyFor W extends @NonNull @UnknownKeyFor @Initialized BoundedWindow, @UnknownKeyFor MapT extends @UnknownKeyFor @NonNull @Initialized Map<W, @NonNull @UnknownKeyFor @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>>>
    extends CombineFnAggregator<ValT, AccT, ResT, WindowedValue<InT>, MapT, Collection<WindowedValue<ResT>>> {
        private final @UnknownKeyFor @NonNull @Initialized TimestampCombiner tsCombiner;

        public WindowedAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> combineFn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, ValT> valueFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized Encoder<W> windowEnc, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> outEnc, @UnknownKeyFor @NonNull @Initialized Class<MapT> clazz) {
            super(combineFn, valueFn, EncoderHelpers.mapEncoder(windowEnc, EncoderHelpers.mutablePairEncoder(EncoderHelpers.encoderOf(Instant.class), accEnc), clazz), EncoderHelpers.collectionEncoder(outEnc));
            this.tsCombiner = windowing.getTimestampCombiner();
        }

        protected final @UnknownKeyFor @NonNull @Initialized Instant resolveTimestamp(@UnknownKeyFor @NonNull @Initialized BoundedWindow w, @UnknownKeyFor @NonNull @Initialized Instant t1, @UnknownKeyFor @NonNull @Initialized Instant t2) {
            return this.tsCombiner.merge(w, new Instant[]{t1, t2});
        }

        protected final @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT> initAcc(ValT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            return new MutablePair((Object)timestamp, this.addToAcc(this.emptyAcc(), value));
        }

        protected final <T extends MutablePair<Instant, AccT>> @PolyNull T mergeAccs(W window, @PolyNull T a1, @PolyNull T a2) {
            if (a1 == null || a2 == null) {
                return a1 == null ? a2 : a1;
            }
            return (T)a1.update((Object)this.resolveTimestamp((BoundedWindow)window, (Instant)a1._1, (Instant)a2._1), this.mergeAccs(a1._2, a2._2));
        }

        protected @UnknownKeyFor @NonNull @Initialized BinaryOperator<@Nullable @UnknownKeyFor @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> combiner(W target) {
            return (a1, a2) -> this.mergeAccs(target, a1, a2);
        }

        protected final @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT> addToAcc(W window, @Nullable @UnknownKeyFor @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT> acc, ValT val, @UnknownKeyFor @NonNull @Initialized Instant ts) {
            if (acc == null) {
                return this.initAcc(val, ts);
            }
            return acc.update((Object)this.resolveTimestamp((BoundedWindow)window, (Instant)acc._1, ts), this.addToAcc(acc._2, val));
        }

        public final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> finish(MapT buffer) {
            return Collections2.transform(buffer.entrySet(), this::windowedValue);
        }

        private @UnknownKeyFor @NonNull @Initialized WindowedValue<ResT> windowedValue(@UnknownKeyFor @NonNull @Initialized Map.Entry<W, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> e) {
            return WindowedValue.of(this.extract(e.getValue()._2), (Instant)((Instant)e.getValue()._1), (BoundedWindow)((BoundedWindow)e.getKey()), (PaneInfo)PaneInfo.NO_FIRING);
        }
    }

    private static class NonMergingWindowedAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT>
    extends WindowedAggregator<ValT, AccT, ResT, InT, BoundedWindow, Map<BoundedWindow, MutablePair<Instant, AccT>>> {
        public NonMergingWindowedAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> combineFn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, ValT> valueFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowEnc, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> outEnc) {
            super(combineFn, valueFn, windowing, windowEnc, accEnc, outEnc, Map.class);
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> zero() {
            return new HashMap<BoundedWindow, MutablePair<Instant, AccT>>();
        }

        public final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> reduce(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> buff, @UnknownKeyFor @NonNull @Initialized WindowedValue<InT> input) {
            Collection windows = input.getWindows();
            return this.reduce(buff, windows, this.value(input), input.getTimestamp());
        }

        protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> reduce(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> buff, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, ValT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            for (BoundedWindow window : windows) {
                buff.compute(window, (w, acc) -> this.addToAcc(w, acc, value, timestamp));
            }
            return buff;
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> merge(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b1, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b2) {
            if (b1.isEmpty()) {
                return b2;
            }
            if (b2.isEmpty()) {
                return b1;
            }
            if (b2.size() > b1.size()) {
                return this.merge(b2, b1);
            }
            b2.forEach((w, acc) -> b1.merge((BoundedWindow)w, (MutablePair<Instant, AccT>)acc, this.combiner(w)));
            return b1;
        }
    }

    private static class MergingWindowedAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT>
    extends NonMergingWindowedAggregator<ValT, AccT, ResT, InT> {
        private final @UnknownKeyFor @NonNull @Initialized WindowFn<ValT, @UnknownKeyFor @NonNull @Initialized BoundedWindow> windowFn;

        public MergingWindowedAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> combineFn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, ValT> valueFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windowEnc, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> outEnc) {
            super(combineFn, valueFn, windowing, windowEnc, accEnc, outEnc);
            this.windowFn = windowing.getWindowFn();
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> reduce(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> buff, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows, ValT value, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            if (buff.isEmpty()) {
                return super.reduce(buff, windows, value, timestamp);
            }
            Function<BoundedWindow, ReduceFn<AccT>> accFn = target -> (acc, w) -> {
                MutablePair accW = (MutablePair)buff.remove(w);
                return accW != null ? this.mergeAccs(w, acc, accW) : this.addToAcc(w, acc, value, timestamp);
            };
            Set<BoundedWindow> unmerged = this.mergeWindows(buff, (Set<BoundedWindow>)ImmutableSet.copyOf(windows), accFn);
            if (!unmerged.isEmpty()) {
                return super.reduce(buff, unmerged, value, timestamp);
            }
            return buff;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> merge(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b1, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b2) {
            Function<BoundedWindow, ReduceFn<AccT>> reduceFn = target -> (acc, w) -> this.mergeAccs(w, this.mergeAccs(w, acc, (MutablePair)b1.remove(w)), (MutablePair)b2.remove(w));
            Set<BoundedWindow> unmerged = b2.keySet();
            if (!(unmerged = this.mergeWindows(b1, unmerged, reduceFn)).isEmpty()) {
                b2.keySet().retainAll(unmerged);
                return super.merge(b1, b2);
            }
            return b1;
        }

        private @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> mergeWindows(final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> buff, final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> newWindows, final @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized ReduceFn<AccT>> reduceFn) {
            try {
                final HashSet<BoundedWindow> newUnmerged = new HashSet<BoundedWindow>(newWindows);
                WindowFn<ValT, BoundedWindow> windowFn = this.windowFn;
                Objects.requireNonNull(windowFn);
                this.windowFn.mergeWindows(new WindowFn.MergeContext(windowFn){

                    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows() {
                        return Sets.union(buff.keySet(), (Set)newWindows);
                    }

                    public void merge(@UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized BoundedWindow> merges, @UnknownKeyFor @NonNull @Initialized BoundedWindow target) {
                        @Nullable MutablePair<Instant, AccT> merged = merges.stream().reduce(null, (BiFunction)reduceFn.apply(target), this.combiner(target));
                        if (merged != null) {
                            buff.put(target, merged);
                        }
                        newUnmerged.removeAll(merges);
                    }
                });
                return newUnmerged;
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to merge accumulators windows", e);
            }
        }

        private static interface ReduceFn<@UnknownKeyFor AccT>
        extends BiFunction<MutablePair<Instant, AccT>, BoundedWindow, MutablePair<Instant, AccT>> {
        }
    }

    private static class SessionsAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT>
    extends WindowedAggregator<ValT, AccT, ResT, InT, IntervalWindow, TreeMap<IntervalWindow, MutablePair<Instant, AccT>>> {
        SessionsAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> combineFn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>, ValT> valueFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowing, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized IntervalWindow> windowEnc, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<@UnknownKeyFor @NonNull @Initialized WindowedValue<ResT>> outEnc) {
            super(combineFn, valueFn, windowing, windowEnc, accEnc, outEnc, TreeMap.class);
            Preconditions.checkArgument((boolean)windowing.getWindowFn().getClass().equals(Sessions.class));
        }

        public final @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> zero() {
            return new TreeMap<IntervalWindow, MutablePair<Instant, AccT>>();
        }

        public @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> reduce(@UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> buff, @UnknownKeyFor @NonNull @Initialized WindowedValue<InT> input) {
            for (IntervalWindow window : input.getWindows()) {
                MutablePair acc = null;
                IntervalWindow first = null;
                IntervalWindow last = null;
                @Nullable Map.Entry<IntervalWindow, MutablePair<Instant, AccT>> lower = buff.floorEntry(window);
                if (lower != null && window.intersects(lower.getKey())) {
                    acc = lower.getValue();
                    window = window.span(lower.getKey());
                    first = last = lower.getKey();
                }
                for (Map.Entry entry : buff.tailMap(window, false).entrySet()) {
                    MutablePair entryAcc = (MutablePair)entry.getValue();
                    IntervalWindow entryWindow = (IntervalWindow)entry.getKey();
                    if (!window.intersects(entryWindow)) break;
                    window = window.span(entryWindow);
                    MutablePair mutablePair = acc = acc == null ? entryAcc : this.mergeAccs(window, acc, entryAcc);
                    if (first == null) {
                        first = last = entryWindow;
                        continue;
                    }
                    last = entryWindow;
                }
                if (first != null && last != null) {
                    buff.navigableKeySet().subSet(first, true, last, true).clear();
                }
                buff.put(window, this.addToAcc(window, acc, this.value(input), input.getTimestamp()));
            }
            return buff;
        }

        public @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> merge(@UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b1, @UnknownKeyFor @NonNull @Initialized TreeMap<@UnknownKeyFor @NonNull @Initialized IntervalWindow, @UnknownKeyFor @NonNull @Initialized MutablePair<@UnknownKeyFor @NonNull @Initialized Instant, AccT>> b2) {
            if (b1.isEmpty()) {
                return b2;
            }
            if (b2.isEmpty()) {
                return b1;
            }
            Object res = this.zero();
            PeekingIterator it1 = Iterators.peekingIterator(b1.entrySet().iterator());
            PeekingIterator it2 = Iterators.peekingIterator(b2.entrySet().iterator());
            MutablePair acc = null;
            IntervalWindow window = null;
            while (it1.hasNext() || it2.hasNext()) {
                Map.Entry nextMin;
                Map.Entry entry = it1.hasNext() && it2.hasNext() ? (((IntervalWindow)((Map.Entry)it1.peek()).getKey()).compareTo((IntervalWindow)((Map.Entry)it2.peek()).getKey()) <= 0 ? (Map.Entry)it1.next() : (Map.Entry)it2.next()) : (nextMin = it1.hasNext() ? (Map.Entry)it1.next() : (Map.Entry)it2.next());
                if (window != null && window.intersects((IntervalWindow)nextMin.getKey())) {
                    window = window.span((IntervalWindow)nextMin.getKey());
                    acc = this.mergeAccs(window, acc, (MutablePair)nextMin.getValue());
                    continue;
                }
                if (window != null && acc != null) {
                    ((TreeMap)res).put(window, acc);
                }
                acc = (MutablePair)nextMin.getValue();
                window = (IntervalWindow)nextMin.getKey();
            }
            if (window != null && acc != null) {
                ((TreeMap)res).put(window, acc);
            }
            return res;
        }
    }

    private static class ValueAggregator<@UnknownKeyFor ValT, @UnknownKeyFor AccT, @UnknownKeyFor ResT, @UnknownKeyFor InT>
    extends CombineFnAggregator<ValT, AccT, ResT, InT, AccT, ResT> {
        public ValueAggregator(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Combine.CombineFn<ValT, AccT, ResT> fn,  @UnknownKeyFor @NonNull @Initialized ScalaInterop.Fun1<InT, ValT> valueFn, @UnknownKeyFor @NonNull @Initialized Encoder<AccT> accEnc, @UnknownKeyFor @NonNull @Initialized Encoder<ResT> outEnc) {
            super(fn, valueFn, accEnc, outEnc);
        }

        public AccT zero() {
            return this.emptyAcc();
        }

        public AccT reduce(AccT buff, InT in) {
            return this.addToAcc(buff, this.value(in));
        }

        public AccT merge(AccT b1, AccT b2) {
            return this.mergeAccs(b1, b2);
        }

        public ResT finish(AccT buff) {
            return this.extract(buff);
        }
    }
}

