/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class AvroRowWriter<@UnknownKeyFor AvroT, @UnknownKeyFor T>
extends BigQueryRowWriter<T> {
    private final @UnknownKeyFor @NonNull @Initialized DataFileWriter<AvroT> writer;
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, AvroT> toAvroRecord;

    AvroRowWriter(@UnknownKeyFor @NonNull @Initialized String basename, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, AvroT> toAvroRecord, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super(basename, "application/octet-stream");
        this.schema = schema;
        this.toAvroRecord = toAvroRecord;
        this.writer = new DataFileWriter((DatumWriter)writerFactory.apply((Object)schema)).create(schema, this.getOutputStream());
    }

    @Override
    public void write(T element) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AvroWriteRequest<T> writeRequest = new AvroWriteRequest<T>(element, this.schema);
        this.writer.append(this.toAvroRecord.apply(writeRequest));
    }

    public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
        return this.schema;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.writer.close();
        super.close();
    }
}

