/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@VisibleForTesting
class PassThroughThenCleanup<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private @UnknownKeyFor @NonNull @Initialized CleanupOperation cleanupOperation;
    private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdSideInput;

    PassThroughThenCleanup(@UnknownKeyFor @NonNull @Initialized CleanupOperation cleanupOperation, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> jobIdSideInput) {
        this.cleanupOperation = cleanupOperation;
        this.jobIdSideInput = jobIdSideInput;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
        TupleTag mainOutput = new TupleTag();
        TupleTag cleanupSignal = new TupleTag();
        PCollectionTuple outputs = (PCollectionTuple)input.apply((PTransform)ParDo.of(new IdentityFn()).withOutputTags(mainOutput, TupleTagList.of((TupleTag)cleanupSignal)));
        PCollectionView cleanupSignalView = (PCollectionView)outputs.get(cleanupSignal).setCoder((Coder)VoidCoder.of()).apply((PTransform)View.asIterable());
        ((PCollection)input.getPipeline().apply("Create(CleanupOperation)", (PTransform)Create.of((Object)this.cleanupOperation, (Object[])new CleanupOperation[0]))).apply("Cleanup", (PTransform)ParDo.of((DoFn)new DoFn<CleanupOperation, Void>(){

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ((CleanupOperation)c.element()).cleanup(new ContextContainer(c, (PCollectionView<String>)PassThroughThenCleanup.this.jobIdSideInput));
            }
        }).withSideInputs(new PCollectionView[]{this.jobIdSideInput, cleanupSignalView}));
        return outputs.get(mainOutput).setCoder(input.getCoder());
    }

    static class ContextContainer {
        private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> view;
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context;

        public ContextContainer(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> view) {
            this.view = view;
            this.context = context;
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
            return this.context.getPipelineOptions();
        }

        public @UnknownKeyFor @NonNull @Initialized String getJobId() {
            return (String)this.context.sideInput(this.view);
        }
    }

    static abstract class CleanupOperation
    implements Serializable {
        CleanupOperation() {
        }

        abstract void cleanup(@UnknownKeyFor @NonNull @Initialized ContextContainer var1) throws @UnknownKeyFor @NonNull @Initialized Exception;

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return 0;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }
    }

    private static class IdentityFn<@UnknownKeyFor T>
    extends DoFn<T, T> {
        private IdentityFn() {
        }

        @DoFn.ProcessElement
        public void processElement(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            c.output(c.element());
        }
    }
}

