/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.spanner.admin.database.v1.DatabaseAdminGrpc;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.v1.SpannerGrpc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

class DdlBatch
extends AbstractBaseUnitOfWork {
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final List<String> statements = new ArrayList<String>();
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    private DdlBatch(Builder builder) {
        super(builder);
        this.ddlClient = builder.ddlClient;
        this.dbClient = builder.dbClient;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.BATCH;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return this.getState().isActive();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ApiFuture<ResultSet> executeQueryAsync(AbstractStatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!(options[i] instanceof Connection.InternalMetadataQuery)) continue;
                Preconditions.checkNotNull((Object)statement);
                Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
                Preconditions.checkArgument((analyzeMode == AnalyzeMode.NONE ? 1 : 0) != 0, (Object)"Analyze is not allowed for DDL batch");
                ArrayList temp = new ArrayList();
                Collections.addAll(temp, options);
                temp.remove(i);
                Options.QueryOption[] internalOptions = temp.toArray(new Options.QueryOption[0]);
                Callable<ResultSet> callable = () -> DirectExecuteResultSet.ofResultSet(this.dbClient.singleUse().executeQuery(statement.getStatement(), internalOptions));
                return this.executeStatementAsync(statement, callable, SpannerGrpc.getExecuteStreamingSqlMethod());
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing queries is not allowed for DDL batches.");
    }

    @Override
    public Timestamp getReadTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no read timestamp available for DDL batches.");
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for DDL batches.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public CommitResponse getCommitResponse() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit response available for DDL batches.");
    }

    @Override
    public CommitResponse getCommitResponseOrNull() {
        return null;
    }

    @Override
    public ApiFuture<Void> executeDdlAsync(AbstractStatementParser.ParsedStatement ddl) {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be used for further statements");
        Preconditions.checkArgument((ddl.getType() == AbstractStatementParser.StatementType.DDL ? 1 : 0) != 0, (Object)("Only DDL statements are allowed. \"" + ddl.getSqlWithoutComments() + "\" is not a DDL-statement."));
        Preconditions.checkArgument((!DdlClient.isCreateDatabaseStatement(ddl.getSqlWithoutComments()) ? 1 : 0) != 0, (Object)"CREATE DATABASE is not supported in DDL batches.");
        this.statements.add(ddl.getSqlWithoutComments());
        return ApiFutures.immediateFuture(null);
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(AbstractStatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing updates is not allowed for DDL batches.");
    }

    @Override
    public ApiFuture<ResultSet> analyzeUpdateAsync(AbstractStatementParser.ParsedStatement update, AnalyzeMode analyzeMode, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Analyzing updates is not allowed for DDL batches.");
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<AbstractStatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Executing batch updates is not allowed for DDL batches.");
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Writing mutations is not allowed for DDL batches.");
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be ran");
        if (this.statements.isEmpty()) {
            this.state = UnitOfWork.UnitOfWorkState.RAN;
            return ApiFutures.immediateFuture((Object)new long[0]);
        }
        Callable<long[]> callable = () -> {
            try {
                OperationFuture<Void, UpdateDatabaseDdlMetadata> operation = this.ddlClient.executeDdl(this.statements);
                try {
                    this.getWithStatementTimeout(operation, AbstractStatementParser.RUN_BATCH_STATEMENT);
                    long[] updateCounts = new long[this.statements.size()];
                    Arrays.fill(updateCounts, 1L);
                    this.state = UnitOfWork.UnitOfWorkState.RAN;
                    return updateCounts;
                }
                catch (SpannerException e) {
                    long[] updateCounts = this.extractUpdateCounts(operation);
                    throw SpannerExceptionFactory.newSpannerBatchUpdateException(e.getErrorCode(), e.getMessage(), updateCounts);
                }
            }
            catch (Throwable t) {
                this.state = UnitOfWork.UnitOfWorkState.RUN_FAILED;
                throw t;
            }
        };
        this.state = UnitOfWork.UnitOfWorkState.RUNNING;
        return this.executeStatementAsync(AbstractStatementParser.RUN_BATCH_STATEMENT, callable, DatabaseAdminGrpc.getUpdateDatabaseDdlMethod());
    }

    long[] extractUpdateCounts(OperationFuture<Void, UpdateDatabaseDdlMetadata> operation) {
        try {
            return this.extractUpdateCounts((UpdateDatabaseDdlMetadata)operation.getMetadata().get());
        }
        catch (Throwable t) {
            return new long[0];
        }
    }

    @VisibleForTesting
    long[] extractUpdateCounts(UpdateDatabaseDdlMetadata metadata) {
        long[] updateCounts = new long[metadata.getStatementsCount()];
        for (int i = 0; i < updateCounts.length; ++i) {
            updateCounts[i] = metadata.getCommitTimestampsCount() > i && metadata.getCommitTimestamps(i) != null ? 1L : 0L;
        }
        return updateCounts;
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(this.state == UnitOfWork.UnitOfWorkState.STARTED, "The batch is no longer active and cannot be aborted.");
        this.state = UnitOfWork.UnitOfWorkState.ABORTED;
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not allowed for DDL batches.");
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not allowed for DDL batches.");
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, DdlBatch> {
        private DdlClient ddlClient;
        private DatabaseClient dbClient;

        private Builder() {
        }

        Builder setDdlClient(DdlClient client) {
            Preconditions.checkNotNull((Object)client);
            this.ddlClient = client;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        @Override
        DdlBatch build() {
            Preconditions.checkState((this.ddlClient != null ? 1 : 0) != 0, (Object)"No DdlClient specified");
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DbClient specified");
            return new DdlBatch(this);
        }
    }
}

