/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforfile;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.waitforfile.ActionWaitForFile;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionWaitForFileDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionWaitForFile.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionWaitForFile.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wFilename;
    private TextVar wMaximumTimeout;
    private TextVar wCheckCycleTime;
    private Button wSuccessOnTimeout;
    private Button wFileSizeCheck;
    private Button wAddFilenameResult;
    private ActionWaitForFile action;
    private boolean changed;

    public ActionWaitForFileDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionWaitForFile)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionWaitForFile.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.shell.setMinimumSize(400, 300);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"System.ActionName.Label", (String[])new String[0]));
        wlName.setToolTipText(BaseMessages.getString(PKG, (String)"System.ActionName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wName, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wName, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wName, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
        Label wlMaximumTimeout = new Label((Composite)this.shell, 131072);
        wlMaximumTimeout.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.MaximumTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaximumTimeout);
        FormData fdlMaximumTimeout = new FormData();
        fdlMaximumTimeout.left = new FormAttachment(0, 0);
        fdlMaximumTimeout.top = new FormAttachment((Control)this.wFilename, margin);
        fdlMaximumTimeout.right = new FormAttachment(middle, -margin);
        wlMaximumTimeout.setLayoutData((Object)fdlMaximumTimeout);
        this.wMaximumTimeout = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMaximumTimeout);
        this.wMaximumTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.MaximumTimeout.Tooltip", (String[])new String[0]));
        this.wMaximumTimeout.addModifyListener(lsMod);
        FormData fdMaximumTimeout = new FormData();
        fdMaximumTimeout.left = new FormAttachment(middle, 0);
        fdMaximumTimeout.top = new FormAttachment((Control)this.wFilename, margin);
        fdMaximumTimeout.right = new FormAttachment(100, 0);
        this.wMaximumTimeout.setLayoutData((Object)fdMaximumTimeout);
        Label wlCheckCycleTime = new Label((Composite)this.shell, 131072);
        wlCheckCycleTime.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.CheckCycleTime.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCheckCycleTime);
        FormData fdlCheckCycleTime = new FormData();
        fdlCheckCycleTime.left = new FormAttachment(0, 0);
        fdlCheckCycleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        fdlCheckCycleTime.right = new FormAttachment(middle, -margin);
        wlCheckCycleTime.setLayoutData((Object)fdlCheckCycleTime);
        this.wCheckCycleTime = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wCheckCycleTime);
        this.wCheckCycleTime.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.CheckCycleTime.Tooltip", (String[])new String[0]));
        this.wCheckCycleTime.addModifyListener(lsMod);
        FormData fdCheckCycleTime = new FormData();
        fdCheckCycleTime.left = new FormAttachment(middle, 0);
        fdCheckCycleTime.top = new FormAttachment((Control)this.wMaximumTimeout, margin);
        fdCheckCycleTime.right = new FormAttachment(100, 0);
        this.wCheckCycleTime.setLayoutData((Object)fdCheckCycleTime);
        Label wlSuccessOnTimeout = new Label((Composite)this.shell, 131072);
        wlSuccessOnTimeout.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.SuccessOnTimeout.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSuccessOnTimeout);
        FormData fdlSuccessOnTimeout = new FormData();
        fdlSuccessOnTimeout.left = new FormAttachment(0, 0);
        fdlSuccessOnTimeout.top = new FormAttachment((Control)this.wCheckCycleTime, margin);
        fdlSuccessOnTimeout.right = new FormAttachment(middle, -margin);
        wlSuccessOnTimeout.setLayoutData((Object)fdlSuccessOnTimeout);
        this.wSuccessOnTimeout = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wSuccessOnTimeout);
        this.wSuccessOnTimeout.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.SuccessOnTimeout.Tooltip", (String[])new String[0]));
        FormData fdSuccessOnTimeout = new FormData();
        fdSuccessOnTimeout.left = new FormAttachment(middle, 0);
        fdSuccessOnTimeout.top = new FormAttachment((Control)wlSuccessOnTimeout, 0, 0x1000000);
        fdSuccessOnTimeout.right = new FormAttachment(100, 0);
        this.wSuccessOnTimeout.setLayoutData((Object)fdSuccessOnTimeout);
        this.wSuccessOnTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForFileDialog.this.action.setChanged();
            }
        });
        Label wlFileSizeCheck = new Label((Composite)this.shell, 131072);
        wlFileSizeCheck.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FileSizeCheck.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileSizeCheck);
        FormData fdlFileSizeCheck = new FormData();
        fdlFileSizeCheck.left = new FormAttachment(0, 0);
        fdlFileSizeCheck.top = new FormAttachment((Control)wlSuccessOnTimeout, 2 * margin);
        fdlFileSizeCheck.right = new FormAttachment(middle, -margin);
        wlFileSizeCheck.setLayoutData((Object)fdlFileSizeCheck);
        this.wFileSizeCheck = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wFileSizeCheck);
        this.wFileSizeCheck.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FileSizeCheck.Tooltip", (String[])new String[0]));
        FormData fdFileSizeCheck = new FormData();
        fdFileSizeCheck.left = new FormAttachment(middle, 0);
        fdFileSizeCheck.top = new FormAttachment((Control)wlFileSizeCheck, 0, 0x1000000);
        fdFileSizeCheck.right = new FormAttachment(100, 0);
        this.wFileSizeCheck.setLayoutData((Object)fdFileSizeCheck);
        this.wFileSizeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForFileDialog.this.action.setChanged();
            }
        });
        Label wlAddFilenameResult = new Label((Composite)this.shell, 131072);
        wlAddFilenameResult.setText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.AddFilenameResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddFilenameResult);
        FormData fdlAddFilenameResult = new FormData();
        fdlAddFilenameResult.left = new FormAttachment(0, 0);
        fdlAddFilenameResult.top = new FormAttachment((Control)wlFileSizeCheck, 2 * margin);
        fdlAddFilenameResult.right = new FormAttachment(middle, -margin);
        wlAddFilenameResult.setLayoutData((Object)fdlAddFilenameResult);
        this.wAddFilenameResult = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAddFilenameResult);
        this.wAddFilenameResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWaitForFile.AddFilenameResult.Tooltip", (String[])new String[0]));
        FormData fdAddFilenameResult = new FormData();
        fdAddFilenameResult.left = new FormAttachment(middle, 0);
        fdAddFilenameResult.top = new FormAttachment((Control)wlAddFilenameResult, 0, 0x1000000);
        fdAddFilenameResult.right = new FormAttachment(100, 0);
        this.wAddFilenameResult.setLayoutData((Object)fdAddFilenameResult);
        this.wAddFilenameResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWaitForFileDialog.this.action.setChanged();
            }
        });
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)(2 * margin), null);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wFilename.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        this.wMaximumTimeout.setText(Const.NVL((String)this.action.getMaximumTimeout(), (String)""));
        this.wCheckCycleTime.setText(Const.NVL((String)this.action.getCheckCycleTime(), (String)""));
        this.wSuccessOnTimeout.setSelection(this.action.isSuccessOnTimeout());
        this.wFileSizeCheck.setSelection(this.action.isFileSizeCheck());
        this.wAddFilenameResult.setSelection(this.action.isAddFilenameToResult());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setMaximumTimeout(this.wMaximumTimeout.getText());
        this.action.setCheckCycleTime(this.wCheckCycleTime.getText());
        this.action.setSuccessOnTimeout(this.wSuccessOnTimeout.getSelection());
        this.action.setFileSizeCheck(this.wFileSizeCheck.getSelection());
        this.action.setAddFilenameToResult(this.wAddFilenameResult.getSelection());
        this.dispose();
    }
}

