/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="BufferedReader wraps stream we don't own and should not close")
class DockerCommand {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DockerCommand.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_DOCKER_COMMAND = "docker";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern CONTAINER_ID_PATTERN = Pattern.compile("\\p{XDigit}{64}");
    private final @UnknownKeyFor @NonNull @Initialized String dockerExecutable;
    private final @UnknownKeyFor @NonNull @Initialized Duration commandTimeout;

    public static @UnknownKeyFor @NonNull @Initialized DockerCommand getDefault() {
        return DockerCommand.forExecutable(DEFAULT_DOCKER_COMMAND, Duration.ofMinutes(2L));
    }

    static @UnknownKeyFor @NonNull @Initialized DockerCommand forExecutable(@UnknownKeyFor @NonNull @Initialized String dockerExecutable, @UnknownKeyFor @NonNull @Initialized Duration commandTimeout) {
        return new DockerCommand(dockerExecutable, commandTimeout);
    }

    private DockerCommand(@UnknownKeyFor @NonNull @Initialized String dockerExecutable, @UnknownKeyFor @NonNull @Initialized Duration commandTimeout) {
        this.dockerExecutable = dockerExecutable;
        this.commandTimeout = commandTimeout;
    }

    public @UnknownKeyFor @NonNull @Initialized String runImage(@UnknownKeyFor @NonNull @Initialized String imageTag, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> dockerOpts, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> args) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Preconditions.checkArgument((!imageTag.isEmpty() ? 1 : 0) != 0, (Object)"Docker image tag required");
        try {
            this.runShortCommand((List<String>)ImmutableList.builder().add((Object)this.dockerExecutable).add((Object)"pull").add((Object)imageTag).build());
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to pull docker image {}", (Object)imageTag, (Object)e);
            }
            LOG.warn("Unable to pull docker image {}, cause: {}", (Object)imageTag, (Object)e.getMessage());
        }
        return this.runShortCommand((List<String>)ImmutableList.builder().add((Object)this.dockerExecutable).add((Object)"run").add((Object)"-d").addAll(dockerOpts).add((Object)imageTag).addAll(args).build());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isContainerRunning(@UnknownKeyFor @NonNull @Initialized String containerId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Preconditions.checkArgument((!containerId.isEmpty() ? 1 : 0) != 0, (Object)"Docker containerId required");
        return this.runShortCommand((List<String>)ImmutableList.builder().add((Object)this.dockerExecutable).add((Object)"inspect").add((Object)"-f").add((Object)"{{.State.Running}}").add((Object)containerId).build()).equalsIgnoreCase("true");
    }

    public @UnknownKeyFor @NonNull @Initialized String getContainerLogs(@UnknownKeyFor @NonNull @Initialized String containerId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Preconditions.checkArgument((containerId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)CONTAINER_ID_PATTERN.matcher(containerId).matches(), (Object)"Container ID must be a 64-character hexadecimal string");
        return this.runShortCommand(Arrays.asList(this.dockerExecutable, "logs", containerId), true, "\n");
    }

    public void killContainer(@UnknownKeyFor @NonNull @Initialized String containerId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Preconditions.checkArgument((containerId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)CONTAINER_ID_PATTERN.matcher(containerId).matches(), (Object)"Container ID must be a 64-character hexadecimal string");
        this.runShortCommand(Arrays.asList(this.dockerExecutable, "kill", containerId));
    }

    public void removeContainer(@UnknownKeyFor @NonNull @Initialized String containerId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Preconditions.checkArgument((containerId != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)CONTAINER_ID_PATTERN.matcher(containerId).matches(), (Object)"Container ID must be a 64-character hexadecimal string");
        this.runShortCommand(Arrays.asList(this.dockerExecutable, "rm", containerId));
    }

    private @UnknownKeyFor @NonNull @Initialized String runShortCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> invocation) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.runShortCommand(invocation, false, "");
    }

    private @UnknownKeyFor @NonNull @Initialized String runShortCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> invocation, @UnknownKeyFor @NonNull @Initialized boolean redirectErrorStream, @UnknownKeyFor @NonNull @Initialized CharSequence delimiter) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        CompletableFuture<String> errorFuture;
        String errorStringName;
        ProcessBuilder pb = new ProcessBuilder(invocation);
        pb.redirectErrorStream(redirectErrorStream);
        Process process = pb.start();
        CompletableFuture<String> resultString = CompletableFuture.supplyAsync(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            return reader.lines().collect(Collectors.joining(delimiter));
        });
        if (redirectErrorStream) {
            errorStringName = "stdout and stderr";
            errorFuture = resultString;
        } else {
            errorStringName = "stderr";
            errorFuture = CompletableFuture.supplyAsync(() -> {
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                return reader.lines().collect(Collectors.joining(delimiter));
            });
        }
        boolean processDone = process.waitFor(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
        if (!processDone) {
            process.destroy();
            throw new TimeoutException(String.format("Timed out while waiting for command '%s'", invocation.stream().collect(Collectors.joining(" "))));
        }
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            String errorString;
            try {
                errorString = errorFuture.get(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception stderrEx) {
                errorString = String.format("Error capturing %s: %s", errorStringName, stderrEx.getMessage());
            }
            throw new IOException(String.format("Received exit code %d for command '%s'. %s: %s", exitCode, invocation.stream().collect(Collectors.joining(" ")), errorStringName, errorString));
        }
        try {
            return resultString.get(this.commandTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new IOException(cause);
        }
    }
}

