/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.kinesis.clientlibrary.config.AWSCredentialsProviderPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.BooleanPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.ClientConfigurationPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.DatePropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.IPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.InitialPositionInStreamPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.IntegerPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.LongPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.SetPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.config.StringPropertyValueDecoder;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KinesisClientLibConfigurator {
    private static final Log LOG = LogFactory.getLog(KinesisClientLibConfigurator.class);
    private static final String PREFIX = "with";
    private static final String PROP_APP_NAME = "applicationName";
    private static final String PROP_STREAM_NAME = "streamName";
    private static final String PROP_CREDENTIALS_PROVIDER_KINESIS = "AWSCredentialsProvider";
    private static final String PROP_CREDENTIALS_PROVIDER_DYNAMODB = "AWSCredentialsProviderDynamoDB";
    private static final String PROP_CREDENTIALS_PROVIDER_CLOUDWATCH = "AWSCredentialsProviderCloudWatch";
    private static final String PROP_WORKER_ID = "workerId";
    private Map<Class<?>, IPropertyValueDecoder<?>> classToDecoder;
    private Map<String, List<Method>> nameToMethods;

    public KinesisClientLibConfigurator() {
        List<IPropertyValueDecoder> getters = Arrays.asList(new IntegerPropertyValueDecoder(), new LongPropertyValueDecoder(), new BooleanPropertyValueDecoder(), new DatePropertyValueDecoder(), new AWSCredentialsProviderPropertyValueDecoder(), new StringPropertyValueDecoder(), new InitialPositionInStreamPropertyValueDecoder(), new ClientConfigurationPropertyValueDecoder(), new SetPropertyValueDecoder());
        this.classToDecoder = new Hashtable();
        for (IPropertyValueDecoder getter : getters) {
            for (Class clazz : getter.getSupportedTypes()) {
                this.classToDecoder.put(clazz, getter);
            }
        }
        this.nameToMethods = new Hashtable<String, List<Method>>();
        for (Method method : KinesisClientLibConfiguration.class.getMethods()) {
            if (!this.nameToMethods.containsKey(method.getName())) {
                this.nameToMethods.put(method.getName(), new ArrayList());
            }
            this.nameToMethods.get(method.getName()).add(method);
        }
    }

    public KinesisClientLibConfiguration getConfiguration(Properties properties) {
        StringPropertyValueDecoder stringValueDecoder = new StringPropertyValueDecoder();
        AWSCredentialsProviderPropertyValueDecoder awsCPPropGetter = new AWSCredentialsProviderPropertyValueDecoder();
        String applicationName = (String)stringValueDecoder.decodeValue(properties.getProperty(PROP_APP_NAME));
        String streamName = (String)stringValueDecoder.decodeValue(properties.getProperty(PROP_STREAM_NAME));
        AWSCredentialsProvider provider = (AWSCredentialsProvider)awsCPPropGetter.decodeValue(properties.getProperty(PROP_CREDENTIALS_PROVIDER_KINESIS));
        if (applicationName == null || applicationName.isEmpty()) {
            throw new IllegalArgumentException("Value of applicationName should be explicitly provided.");
        }
        if (streamName == null || streamName.isEmpty()) {
            throw new IllegalArgumentException("Value of streamName should be explicitly provided.");
        }
        String propCredentialsProviderDynamoDBValue = properties.getProperty(PROP_CREDENTIALS_PROVIDER_DYNAMODB);
        AWSCredentialsProvider providerDynamoDB = propCredentialsProviderDynamoDBValue == null ? provider : (AWSCredentialsProvider)awsCPPropGetter.decodeValue(propCredentialsProviderDynamoDBValue);
        String propCredentialsProviderCloudWatchValue = properties.getProperty(PROP_CREDENTIALS_PROVIDER_CLOUDWATCH);
        AWSCredentialsProvider providerCloudWatch = propCredentialsProviderCloudWatchValue == null ? provider : (AWSCredentialsProvider)awsCPPropGetter.decodeValue(propCredentialsProviderCloudWatchValue);
        String workerId = (String)stringValueDecoder.decodeValue(properties.getProperty(PROP_WORKER_ID));
        if (workerId == null || workerId.isEmpty()) {
            workerId = UUID.randomUUID().toString();
            LOG.info((Object)("Value of workerId is not provided in the properties. WorkerId is automatically assigned as: " + workerId));
        }
        KinesisClientLibConfiguration config = new KinesisClientLibConfiguration(applicationName, streamName, provider, providerDynamoDB, providerCloudWatch, workerId);
        HashSet<String> requiredNames = new HashSet<String>(Arrays.asList(PROP_STREAM_NAME, PROP_APP_NAME, PROP_WORKER_ID, PROP_CREDENTIALS_PROVIDER_KINESIS));
        for (Object keyObject : properties.keySet()) {
            String key = keyObject.toString();
            if (requiredNames.contains(key)) continue;
            this.withProperty(key, properties, config);
        }
        return config;
    }

    public KinesisClientLibConfiguration getConfiguration(InputStream configStream) {
        Properties properties = new Properties();
        try {
            properties.load(configStream);
        }
        catch (IOException e) {
            String msg = "Could not load properties from the stream provided";
            throw new IllegalStateException(msg, e);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException e) {
                String msg = "Encountered error while trying to close properties file.";
                throw new IllegalStateException(msg, e);
            }
        }
        return this.getConfiguration(properties);
    }

    private void withProperty(String propertyKey, Properties properties, KinesisClientLibConfiguration config) {
        if (propertyKey.isEmpty()) {
            throw new IllegalArgumentException("The property can't be empty string");
        }
        String targetMethodName = PREFIX + Character.toUpperCase(propertyKey.charAt(0)) + propertyKey.substring(1);
        String propertyValue = properties.getProperty(propertyKey);
        if (this.nameToMethods.containsKey(targetMethodName)) {
            for (Method method : this.nameToMethods.get(targetMethodName)) {
                if (method.getParameterTypes().length == 1 && method.getName().equals(targetMethodName)) {
                    Class<?> paramType = method.getParameterTypes()[0];
                    if (this.classToDecoder.containsKey(paramType)) {
                        IPropertyValueDecoder<?> decoder = this.classToDecoder.get(paramType);
                        try {
                            method.invoke((Object)config, decoder.decodeValue(propertyValue));
                            LOG.info((Object)String.format("Successfully set property %s with value %s", propertyKey, propertyValue));
                            return;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            LOG.warn((Object)String.format("Encountered an error while invoking method %s with value %s. Exception was %s", method, propertyValue, e));
                            continue;
                        }
                        catch (UnsupportedOperationException e) {
                            LOG.warn((Object)String.format("The property %s is not supported as type %s at this time.", propertyKey, paramType));
                            continue;
                        }
                    }
                    LOG.debug((Object)String.format("No method for decoding parameters of type %s so method %s could not be invoked.", paramType, method));
                    continue;
                }
                LOG.debug((Object)String.format("Method %s doesn't look like it is appropriate for setting property %s. Looking for something called %s.", method, propertyKey, targetMethodName));
            }
        } else {
            LOG.debug((Object)String.format("There was no appropriately named method for setting property %s.", propertyKey));
        }
    }
}

