/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Condition;

final class AutoValue_Condition
extends Condition {
    private final String title;
    private final String description;
    private final String expression;

    private AutoValue_Condition(String title, String description, String expression) {
        this.title = title;
        this.description = description;
        this.expression = expression;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        return "Condition{title=" + this.title + ", description=" + this.description + ", expression=" + this.expression + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Condition) {
            Condition that = (Condition)o;
            return this.title.equals(that.getTitle()) && this.description.equals(that.getDescription()) && this.expression.equals(that.getExpression());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.title.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        return h$ ^= this.expression.hashCode();
    }

    @Override
    public Condition.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Condition.Builder {
        private String title;
        private String description;
        private String expression;

        Builder() {
        }

        private Builder(Condition source) {
            this.title = source.getTitle();
            this.description = source.getDescription();
            this.expression = source.getExpression();
        }

        @Override
        public Condition.Builder setTitle(String title) {
            if (title == null) {
                throw new NullPointerException("Null title");
            }
            this.title = title;
            return this;
        }

        @Override
        public Condition.Builder setDescription(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public Condition.Builder setExpression(String expression) {
            if (expression == null) {
                throw new NullPointerException("Null expression");
            }
            this.expression = expression;
            return this;
        }

        @Override
        public Condition build() {
            if (this.title == null || this.description == null || this.expression == null) {
                StringBuilder missing = new StringBuilder();
                if (this.title == null) {
                    missing.append(" title");
                }
                if (this.description == null) {
                    missing.append(" description");
                }
                if (this.expression == null) {
                    missing.append(" expression");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Condition(this.title, this.description, this.expression);
        }
    }
}

