/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.METRICS)
@Internal
public class MetricsEnvironment {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(MetricsEnvironment.class);
    private static final @UnknownKeyFor @NonNull @Initialized AtomicBoolean METRICS_SUPPORTED = new AtomicBoolean(false);
    private static final @UnknownKeyFor @NonNull @Initialized AtomicBoolean REPORTED_MISSING_CONTAINER = new AtomicBoolean(false);
    private static final @UnknownKeyFor @NonNull @Initialized ThreadLocal<@NonNull @UnknownKeyFor @Initialized MetricsContainerHolder> CONTAINER_FOR_THREAD = ThreadLocal.withInitial(MetricsContainerHolder::new);
    private static final @UnknownKeyFor @NonNull @Initialized AtomicReference<@Nullable @UnknownKeyFor @Initialized MetricsContainer> PROCESS_WIDE_METRICS_CONTAINER = new AtomicReference();

    public static @UnknownKeyFor @NonNull @Initialized MetricsEnvironmentState getMetricsEnvironmentStateForCurrentThread() {
        return CONTAINER_FOR_THREAD.get();
    }

    public static @Nullable @UnknownKeyFor @Initialized MetricsContainer setCurrentContainer(@Nullable @UnknownKeyFor @Initialized MetricsContainer container) {
        MetricsContainerHolder holder = CONTAINER_FOR_THREAD.get();
        @Nullable MetricsContainer previous = holder.container;
        holder.container = container;
        return previous;
    }

    public static @Nullable @UnknownKeyFor @Initialized MetricsContainer setProcessWideContainer(@Nullable @UnknownKeyFor @Initialized MetricsContainer container) {
        return PROCESS_WIDE_METRICS_CONTAINER.getAndSet(container);
    }

    public static void setMetricsSupported(@UnknownKeyFor @NonNull @Initialized boolean supported) {
        METRICS_SUPPORTED.set(supported);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isMetricsSupported() {
        return METRICS_SUPPORTED.get();
    }

    public static @UnknownKeyFor @NonNull @Initialized Closeable scopedMetricsContainer(@UnknownKeyFor @NonNull @Initialized MetricsContainer container) {
        return new ScopedContainer(container);
    }

    public static @Nullable @UnknownKeyFor @Initialized MetricsContainer getCurrentContainer() {
        MetricsContainer container = CONTAINER_FOR_THREAD.get().container;
        if (container == null && REPORTED_MISSING_CONTAINER.compareAndSet(false, true)) {
            if (MetricsEnvironment.isMetricsSupported()) {
                LOG.error("Unable to update metrics on the current thread. Most likely caused by using metrics outside the managed work-execution thread.");
            } else {
                LOG.warn("Reporting metrics are not supported in the current execution environment.");
            }
        }
        return container;
    }

    public static @Nullable @UnknownKeyFor @Initialized MetricsContainer getProcessWideContainer() {
        return PROCESS_WIDE_METRICS_CONTAINER.get();
    }

    static /* synthetic */ ThreadLocal access$200() {
        return CONTAINER_FOR_THREAD;
    }

    public static interface MetricsEnvironmentState {
        public @Nullable @UnknownKeyFor @Initialized MetricsContainer activate(@Nullable @UnknownKeyFor @Initialized MetricsContainer var1);
    }

    public static class MetricsContainerHolder
    implements MetricsEnvironmentState {
        private @Nullable @UnknownKeyFor @Initialized MetricsContainer container = null;

        @Override
        public @Nullable @UnknownKeyFor @Initialized MetricsContainer activate(@Nullable @UnknownKeyFor @Initialized MetricsContainer metricsContainer) {
            MetricsContainer old = this.container;
            this.container = metricsContainer;
            return old;
        }
    }

    private static class ScopedContainer
    implements Closeable {
        private final @UnknownKeyFor @NonNull @Initialized MetricsContainerHolder holder = (MetricsContainerHolder)MetricsEnvironment.access$200().get();
        private final @Nullable @UnknownKeyFor @Initialized MetricsContainer oldContainer = MetricsContainerHolder.access$000(this.holder);

        private ScopedContainer(@UnknownKeyFor @NonNull @Initialized MetricsContainer newContainer) {
            this.holder.container = newContainer;
        }

        @Override
        public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.holder.container = this.oldContainer;
        }
    }
}

