/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class UuidLogicalType
implements Schema.LogicalType<UUID, Row> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:logical_type:uuid:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String LEAST_SIGNIFICANT_BITS_FIELD_NAME = "LeastSignificantBits";
    public static final @UnknownKeyFor @NonNull @Initialized String MOST_SIGNIFICANT_BITS_FIELD_NAME = "MostSignificantBits";
    public static final @UnknownKeyFor @NonNull @Initialized Schema UUID_SCHEMA = Schema.builder().addInt64Field("MostSignificantBits").addInt64Field("LeastSignificantBits").build();

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getArgumentType() {
        return Schema.FieldType.STRING;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getArgument() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Schema.FieldType getBaseType() {
        return Schema.FieldType.row(UUID_SCHEMA);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized UUID input) {
        return Row.withSchema(UUID_SCHEMA).addValues(input.getMostSignificantBits(), input.getLeastSignificantBits()).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized UUID toInputType(@UnknownKeyFor @NonNull @Initialized Row base) {
        Long leastSignificantBitsValue = base.getInt64(LEAST_SIGNIFICANT_BITS_FIELD_NAME);
        Long mostSignificantBitsValue = base.getInt64(MOST_SIGNIFICANT_BITS_FIELD_NAME);
        if (leastSignificantBitsValue == null || mostSignificantBitsValue == null) {
            throw new IllegalStateException(String.format("Most (%s) and least (%s) significant bits value shouldn't be null for UUID", mostSignificantBitsValue, leastSignificantBitsValue));
        }
        return new UUID(mostSignificantBitsValue, leastSignificantBitsValue);
    }
}

