/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class VariableBytes
extends PassThroughLogicalType<byte[]> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = (String)SchemaApi.LogicalTypes.Enum.VAR_BYTES.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    private final @Nullable @UnknownKeyFor @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized int maxByteArrayLength;

    public static @UnknownKeyFor @NonNull @Initialized VariableBytes of(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int maxByteArrayLength) {
        return new VariableBytes(name, maxByteArrayLength);
    }

    public static @UnknownKeyFor @NonNull @Initialized VariableBytes of(@UnknownKeyFor @NonNull @Initialized int maxByteArrayLength) {
        return VariableBytes.of(null, maxByteArrayLength);
    }

    private VariableBytes(@Nullable @UnknownKeyFor @Initialized String name, @UnknownKeyFor @NonNull @Initialized int maxByteArrayLength) {
        super(IDENTIFIER, Schema.FieldType.INT32, maxByteArrayLength, Schema.FieldType.BYTES);
        this.name = name;
        this.maxByteArrayLength = maxByteArrayLength;
    }

    public @UnknownKeyFor @NonNull @Initialized int getMaxLength() {
        return this.maxByteArrayLength;
    }

    public @Nullable @UnknownKeyFor @Initialized String getName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toInputType(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] base) {
        Preconditions.checkArgument((base.length <= this.maxByteArrayLength ? 1 : 0) != 0);
        return base;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "VariableBytes: " + this.maxByteArrayLength;
    }
}

