/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Partition<@UnknownKeyFor T>
extends PTransform<PCollection<T>, PCollectionList<T>> {
    private final transient @UnknownKeyFor @NonNull @Initialized PartitionDoFn<T> partitionDoFn;

    public static <T> @UnknownKeyFor @NonNull @Initialized Partition<T> of(@UnknownKeyFor @NonNull @Initialized int numPartitions, @UnknownKeyFor @NonNull @Initialized PartitionWithSideInputsFn<@UnknownKeyFor @Nullable @Initialized ? super T> partitionFn, @UnknownKeyFor @NonNull @Initialized Requirements requirements) {
        Contextful<Contextful.Fn<Object, Integer>> ctfFn = Contextful.fn((element, c) -> partitionFn.partitionFor(element, numPartitions, c), requirements);
        return new Partition(new PartitionDoFn(numPartitions, ctfFn, partitionFn));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Partition<T> of(@UnknownKeyFor @NonNull @Initialized int numPartitions, @UnknownKeyFor @NonNull @Initialized PartitionFn<@UnknownKeyFor @Nullable @Initialized ? super T> partitionFn) {
        Contextful<Contextful.Fn<Object, Integer>> ctfFn = Contextful.fn((element, c) -> partitionFn.partitionFor(element, numPartitions), Requirements.empty());
        return new Partition(new PartitionDoFn(numPartitions, ctfFn, partitionFn));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollectionList<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> in) {
        TupleTagList outputTags = this.partitionDoFn.getOutputTags();
        PCollectionTuple outputs = (PCollectionTuple)((Object)in.apply(ParDo.of(this.partitionDoFn).withOutputTags(new TupleTag<Void>(){}, outputTags).withSideInputs(this.partitionDoFn.getSideInputs())));
        PCollectionList<?> pcs = PCollectionList.empty(in.getPipeline());
        Coder<T> coder = in.getCoder();
        Iterator<TupleTag<?>> iterator = outputTags.getAll().iterator();
        while (iterator.hasNext()) {
            TupleTag<?> outputTag;
            TupleTag<?> typedOutputTag = outputTag = iterator.next();
            pcs = pcs.and(outputs.get(typedOutputTag).setCoder(coder));
        }
        return pcs;
    }

    @Override
    public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.include("partitionFn", this.partitionDoFn);
    }

    private Partition(@UnknownKeyFor @NonNull @Initialized PartitionDoFn<T> partitionDoFn) {
        this.partitionDoFn = partitionDoFn;
    }

    private static class PartitionDoFn<@UnknownKeyFor X>
    extends DoFn<X, Void> {
        private final @UnknownKeyFor @NonNull @Initialized int numPartitions;
        private final @UnknownKeyFor @NonNull @Initialized TupleTagList outputTags;
        private final @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<X, @UnknownKeyFor @NonNull @Initialized Integer>> ctxFn;
        private final @UnknownKeyFor @NonNull @Initialized Object originalFnClassForDisplayData;

        private PartitionDoFn(@UnknownKeyFor @NonNull @Initialized int numPartitions, @UnknownKeyFor @NonNull @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<X, @UnknownKeyFor @NonNull @Initialized Integer>> ctxFn, @UnknownKeyFor @NonNull @Initialized Object originalFnClassForDisplayData) {
            this.ctxFn = ctxFn;
            this.originalFnClassForDisplayData = originalFnClassForDisplayData;
            if (numPartitions <= 0) {
                throw new IllegalArgumentException("numPartitions must be > 0");
            }
            this.numPartitions = numPartitions;
            TupleTagList buildOutputTags = TupleTagList.empty();
            for (int partition = 0; partition < numPartitions; ++partition) {
                buildOutputTags = buildOutputTags.and(new TupleTag());
            }
            this.outputTags = buildOutputTags;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTagList getOutputTags() {
            return this.outputTags;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Object input = c.element();
            int partition = this.ctxFn.getClosure().apply(input, Contextful.Fn.Context.wrapProcessContext(c));
            if (0 > partition || partition >= this.numPartitions) {
                throw new IndexOutOfBoundsException("Partition function returned out of bounds index: " + partition + " not in [0.." + this.numPartitions + ")");
            }
            TupleTag<?> typedTag = this.outputTags.get(partition);
            c.output(typedTag, input);
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("numPartitions", this.numPartitions).withLabel("Partition Count")).add(DisplayData.item("partitionFn", this.originalFnClassForDisplayData.getClass()).withLabel("Partition Function"));
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Iterable<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.ctxFn.getRequirements().getSideInputs();
        }
    }

    public static interface PartitionWithSideInputsFn<@UnknownKeyFor T>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized int partitionFor(T var1, @UnknownKeyFor @NonNull @Initialized int var2, @UnknownKeyFor @NonNull @Initialized Contextful.Fn.Context var3);
    }

    public static interface PartitionFn<@UnknownKeyFor T>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized int partitionFor(T var1, @UnknownKeyFor @NonNull @Initialized int var2);
    }
}

