/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.Sample;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Experimental
public class Wait {
    public static <T> @UnknownKeyFor @NonNull @Initialized OnSignal<T> on(PCollection<?> ... signals) {
        return Wait.on(Arrays.asList(signals));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized OnSignal<T> on(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> signals) {
        return new OnSignal(signals);
    }

    private static class CollectWindowsFn<@UnknownKeyFor T>
    extends DoFn<T, Void> {
        private @Nullable @UnknownKeyFor @Initialized Set<@UnknownKeyFor @NonNull @Initialized BoundedWindow> windows;

        private CollectWindowsFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.windows = Sets.newHashSetWithExpectedSize((int)1);
        }

        @DoFn.ProcessElement
        public void process(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            this.windows.add(w);
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            for (BoundedWindow w : this.windows) {
                c.output(null, w.maxTimestamp(), w);
            }
        }
    }

    private static class ToWaitView
    extends PTransform<PCollection<?>, PCollectionView<?>> {
        private ToWaitView() {
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> expand(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input) {
            return this.expandTyped(input);
        }

        private <SignalT> /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> expandTyped(@UnknownKeyFor @NonNull @Initialized PCollection<SignalT> input) {
            return (PCollectionView)((PCollection)((PCollection)input.apply(Window.configure().triggering(Never.ever()).discardingFiredPanes())).apply(ParDo.of(new CollectWindowsFn()))).apply(Sample.any(1L)).apply(View.asList());
        }
    }

    public static class OnSignal<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final transient /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> signals;

        private OnSignal(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> signals) {
            this.signals = signals;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            ArrayList views = Lists.newArrayList();
            for (int i = 0; i < this.signals.size(); ++i) {
                views.add((PCollectionView)this.signals.get(i).apply("To wait view " + i, new ToWaitView()));
            }
            return (PCollection)input.apply("Wait", MapElements.into(input.getCoder().getEncodedTypeDescriptor()).via(Contextful.fn((t, c) -> t, Requirements.requiresSideInputs(views))));
        }
    }
}

